/*
 * Decompiled with CFR 0.152.
 */
package net.lavender.lavsdelight.common.block;

import java.util.function.Supplier;
import net.lavender.lavsdelight.common.block.common.SackBlock;
import net.lavender.lavsdelight.common.block.common.WildCropBlock;
import net.lavender.lavsdelight.common.block.custom.CheeseWheel;
import net.lavender.lavsdelight.common.block.custom.DreamCatcher;
import net.lavender.lavsdelight.common.block.custom.IronRichGravel;
import net.lavender.lavsdelight.common.block.custom.WildBlossom;
import net.lavender.lavsdelight.common.item.LDItems;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockInit {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"lavsdelight");
    public static final RegistryObject<Block> CHEESE_WHEEL = BlockInit.registerBlock("cheese_wheel", () -> new CheeseWheel(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56745_).m_278166_(PushReaction.IGNORE).m_60978_(0.5f).m_284180_(MapColor.f_283832_)));
    public static final RegistryObject<Block> PEACH_CRATE = BlockInit.registerBlock("peach_crate", () -> new Block(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50011_)));
    public static final RegistryObject<Block> PEACH_PIT_SACK = BlockInit.registerBlock("peach_pit_sack", () -> new SackBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50106_)));
    public static final RegistryObject<Block> SALT_BAG = BlockInit.registerBlock("salt_bag", () -> new SackBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50106_)));
    public static final RegistryObject<Block> IRON_RICH_GRAVEL = BlockInit.registerBlock("iron_rich_gravel", () -> new IronRichGravel(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_49994_).m_60918_(SoundType.f_56739_).m_284180_(MapColor.f_283779_)));
    public static final RegistryObject<Block> HALITE = BlockInit.registerBlock("halite", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_154661_).m_60913_(0.8f, 0.8f).m_278166_(PushReaction.NORMAL).m_280658_(NoteBlockInstrument.CHIME).m_60999_().m_284180_(MapColor.f_283744_)));
    public static final RegistryObject<Block> WILD_BLOSSOM = BLOCKS.register("wild_blossom", () -> new WildBlossom(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50685_).m_284268_(DyeColor.WHITE)));
    public static final RegistryObject<Block> WILD_MINT = BlockInit.registerBlock("wild_mint", () -> new WildCropBlock(MobEffects.f_19606_, 160, BlockBehaviour.Properties.m_284310_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60988_().m_284180_(MapColor.f_283915_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> AZALEA = BlockInit.registerBlock("azalea", () -> new FlowerBlock(MobEffects.f_19596_, 160, BlockBehaviour.Properties.m_284310_().m_222979_(BlockBehaviour.OffsetType.XZ).m_60988_().m_284268_(DyeColor.WHITE).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> LAVENDER = BlockInit.registerBlock("lavender", () -> new FlowerBlock(MobEffects.f_19605_, 160, BlockBehaviour.Properties.m_284310_().m_222979_(BlockBehaviour.OffsetType.XYZ).m_60988_().m_284180_(MapColor.f_283765_).m_60910_().m_60966_().m_60918_(SoundType.f_56740_)));
    public static final RegistryObject<Block> POTTED_AZALEA = BLOCKS.register("potted_azalea", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, AZALEA, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283919_)));
    public static final RegistryObject<Block> POTTED_LAVENDER = BLOCKS.register("potted_lavender", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, LAVENDER, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283765_)));
    public static final RegistryObject<Block> POTTED_MINT = BLOCKS.register("potted_mint", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.f_50276_, WILD_MINT, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283916_)));
    public static final RegistryObject<Block> DREAM_CATCHER = BlockInit.registerBlock("dream_catcher", () -> new DreamCatcher(BlockBehaviour.Properties.m_284310_().m_60918_(SoundType.f_56736_).m_60966_().m_60910_().m_284180_(MapColor.f_283825_)));

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> RegistryObject<Item> registerBlockItem(String name, RegistryObject<T> block) {
        return LDItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

