/*
 * Decompiled with CFR 0.152.
 */
package net.Lucas.elytrachestplates.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.Lucas.elytrachestplates.entity.client.DiamondElytraModel;
import net.Lucas.elytrachestplates.entity.client.NetheriteElytraModel;
import net.Lucas.elytrachestplates.item.ModItems;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class NetheriteElytraLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation WINGS_LOCATION = new ResourceLocation("elytrachestplates", "textures/entity/netherite_elytra.png");
    private final NetheriteElytraModel<T> elytraModel;

    public NetheriteElytraLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer);
        this.elytraModel = new NetheriteElytraModel(pModelSet.bakeLayer(DiamondElytraModel.WINGS_LAYER_LOCATION));
    }

    public void render(@NotNull PoseStack pMatrixStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack itemstack = pLivingEntity.getItemBySlot(EquipmentSlot.CHEST);
        if (this.shouldRender(itemstack)) {
            AbstractClientPlayer abstractclientplayer;
            PlayerSkin playerskin;
            ResourceLocation resourcelocation = pLivingEntity instanceof AbstractClientPlayer ? ((playerskin = (abstractclientplayer = (AbstractClientPlayer)pLivingEntity).getSkin()).elytraTexture() != null ? playerskin.elytraTexture() : (playerskin.capeTexture() != null && abstractclientplayer.isModelPartShown(PlayerModelPart.CAPE) ? playerskin.capeTexture() : this.getElytraTexture())) : this.getElytraTexture();
            pMatrixStack.pushPose();
            pMatrixStack.translate(0.0f, 0.0f, 0.125f);
            this.getParentModel().copyPropertiesTo(this.elytraModel);
            this.elytraModel.setupAnim(pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            VertexConsumer vertexconsumer = ItemRenderer.getArmorFoilBuffer((MultiBufferSource)pBuffer, (RenderType)RenderType.armorCutoutNoCull((ResourceLocation)resourcelocation), (boolean)false, (boolean)itemstack.hasFoil());
            this.elytraModel.renderToBuffer(pMatrixStack, vertexconsumer, pPackedLight, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
            pMatrixStack.popPose();
        }
    }

    public boolean shouldRender(ItemStack stack) {
        return stack.getItem() == ModItems.NETHERITE_ELYTRA_CHESTPLATE.get();
    }

    public ResourceLocation getElytraTexture() {
        return WINGS_LOCATION;
    }
}

