/*
 * Decompiled with CFR 0.152.
 */
package net.Lucas.elytrachestplates.item;

import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.gameevent.GameEvent;

public class DiamondElytraChestplate
extends ArmorItem {
    public DiamondElytraChestplate(Holder<ArmorMaterial> pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return (double)stack.getDamageValue() / (double)stack.getMaxDamage() <= 0.9;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        int unbreakingLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.UNBREAKING, (ItemStack)stack);
        float saveChance = 1.0f / (float)(unbreakingLevel + 1);
        if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            float randomFloat = RandomSource.create().nextFloat();
            if (nextFlightTick % 20 == 0 && randomFloat <= saveChance) {
                stack.hurtAndBreak(1, entity, EquipmentSlot.CHEST);
            }
            entity.gameEvent((Holder)GameEvent.ELYTRA_GLIDE);
        }
        return true;
    }
}

