/*
 * Decompiled with CFR 0.152.
 */
package net.Lucas.elytrachestplates.entity.client;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class DiamondElytraModel<T extends LivingEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation WINGS_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("elytrachestplates", "diamond_elytra"), "main");
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public DiamondElytraModel(ModelPart pRoot) {
        this.leftWing = pRoot.m_171324_("left_wing");
        this.rightWing = pRoot.m_171324_("right_wing");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        CubeDeformation cubedeformation = new CubeDeformation(1.0f);
        partdefinition.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-10.0f, 0.0f, 0.0f, 10.0f, 20.0f, 2.0f, cubedeformation), PartPose.m_171423_((float)5.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.0f, (float)-0.2617994f));
        partdefinition.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171480_().m_171488_(0.0f, 0.0f, 0.0f, 10.0f, 20.0f, 2.0f, cubedeformation), PartPose.m_171423_((float)-5.0f, (float)0.0f, (float)0.0f, (float)0.2617994f, (float)0.0f, (float)0.2617994f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of();
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.leftWing, (Object)this.rightWing);
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = 0.2617994f;
        float f1 = -0.2617994f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (pEntity.m_21255_()) {
            float f4 = 1.0f;
            Vec3 vec3 = pEntity.m_20184_();
            if (vec3.f_82480_ < 0.0) {
                Vec3 vec31 = vec3.m_82541_();
                f4 = 1.0f - (float)Math.pow(-vec31.f_82480_, 1.5);
            }
            f = f4 * 0.34906584f + (1.0f - f4) * f;
            f1 = f4 * -1.5707964f + (1.0f - f4) * f1;
        } else if (pEntity.m_6047_()) {
            f = 0.6981317f;
            f1 = -0.7853982f;
            f2 = 3.0f;
            f3 = 0.08726646f;
        }
        this.leftWing.f_104201_ = f2;
        if (pEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractclientplayer = (AbstractClientPlayer)pEntity;
            abstractclientplayer.f_108542_ += (f - abstractclientplayer.f_108542_) * 0.1f;
            abstractclientplayer.f_108543_ += (f3 - abstractclientplayer.f_108543_) * 0.1f;
            abstractclientplayer.f_108544_ += (f1 - abstractclientplayer.f_108544_) * 0.1f;
            this.leftWing.f_104203_ = abstractclientplayer.f_108542_;
            this.leftWing.f_104204_ = abstractclientplayer.f_108543_;
            this.leftWing.f_104205_ = abstractclientplayer.f_108544_;
        } else {
            this.leftWing.f_104203_ = f;
            this.leftWing.f_104205_ = f1;
            this.leftWing.f_104204_ = f3;
        }
        this.rightWing.f_104204_ = -this.leftWing.f_104204_;
        this.rightWing.f_104201_ = this.leftWing.f_104201_;
        this.rightWing.f_104203_ = this.leftWing.f_104203_;
        this.rightWing.f_104205_ = -this.leftWing.f_104205_;
    }
}

