/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.warpedblocks.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.petemc.warpedblocks.datagen.ModBlockStateProvider;
import net.petemc.warpedblocks.datagen.ModBlockTagGenerator;
import net.petemc.warpedblocks.datagen.ModGlobalLootModifiersProvider;
import net.petemc.warpedblocks.datagen.ModItemModelProvider;
import net.petemc.warpedblocks.datagen.ModItemTagGenerator;
import net.petemc.warpedblocks.datagen.ModLootTableProvider;
import net.petemc.warpedblocks.datagen.ModPoiTypeTagsProvider;
import net.petemc.warpedblocks.datagen.ModRecipeProvider;

@Mod.EventBusSubscriber(modid="warpedblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        ModBlockTagGenerator blockTagGenerator = (ModBlockTagGenerator)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagGenerator(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifiersProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)new ModPoiTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
    }
}

