/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Util {
    public static void traverseSupercover(Vector3d start, Vector3d end, Function<Vector3d, Boolean> callback) {
        Vector3d startFloor = new Vector3d(Math.floor(start.x), Math.floor(start.y), Math.floor(start.z));
        Vector3d endFloor = new Vector3d(Math.floor(end.x), Math.floor(end.y), Math.floor(end.z));
        Vector3d delta = new Vector3d(Math.abs(endFloor.x - startFloor.x), Math.abs(endFloor.y - startFloor.y), Math.abs(endFloor.z - startFloor.z));
        Vector3d step = new Vector3d((double)Integer.compare((int)endFloor.x, (int)startFloor.x), (double)Integer.compare((int)endFloor.y, (int)startFloor.y), (double)Integer.compare((int)endFloor.z, (int)startFloor.z));
        Vector3d current = new Vector3d((Vector3dc)startFloor);
        Vector3d deltaDist = new Vector3d(delta.x == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(end.x - start.x), delta.y == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(end.y - start.y), delta.z == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / Math.abs(end.z - start.z));
        Vector3d maxDist = new Vector3d(delta.x == 0.0 ? Double.POSITIVE_INFINITY : deltaDist.x * (step.x > 0.0 ? startFloor.x + 1.0 - start.x : start.x - startFloor.x), delta.y == 0.0 ? Double.POSITIVE_INFINITY : deltaDist.y * (step.y > 0.0 ? startFloor.y + 1.0 - start.y : start.y - startFloor.y), delta.z == 0.0 ? Double.POSITIVE_INFINITY : deltaDist.z * (step.z > 0.0 ? startFloor.z + 1.0 - start.z : start.z - startFloor.z));
        for (int i = 0; i < 1 + (int)delta.x + (int)delta.y + (int)delta.z; ++i) {
            Vector3d center = new Vector3d((Vector3dc)current).add(0.5, 0.5, 0.5);
            if (callback.apply(center).booleanValue()) {
                return;
            }
            if (maxDist.x < maxDist.y && maxDist.x < maxDist.z) {
                current.x += step.x;
                maxDist.x += deltaDist.x;
                continue;
            }
            if (maxDist.y < maxDist.z) {
                current.y += step.y;
                maxDist.y += deltaDist.y;
                continue;
            }
            current.z += step.z;
            maxDist.z += deltaDist.z;
        }
    }

    public static BlockPos locateAir(Vec3 origin, ServerLevel level, int limit) {
        return Util.locateNearestMatchingBlock(origin, blockPos -> level.m_46859_(blockPos) && !level.m_46859_(blockPos.m_121945_(Direction.DOWN)), limit);
    }

    public static BlockPos locateNearestMatchingBlock(Vec3 origin, Function<BlockPos, Boolean> condition, int limit) {
        ArrayList<BlockPos> processedNeighbors = new ArrayList<BlockPos>();
        ArrayList<BlockPos> seenNeighbors = new ArrayList<BlockPos>();
        PriorityQueue<Neighbor> neighbors = new PriorityQueue<Neighbor>(Comparator.comparingDouble(neighbour -> neighbour.distance));
        class Neighbor {
            public final BlockPos position;
            public final double distance;

            public Neighbor(BlockPos position, double distance) {
                this.position = position;
                this.distance = distance;
            }
        }
        neighbors.add(new Neighbor(new BlockPos((int)origin.f_82479_, (int)origin.f_82480_, (int)origin.f_82481_), 0.0));
        for (int steps = 0; !neighbors.isEmpty() && steps < limit; ++steps) {
            Neighbor neighbor = neighbors.poll();
            if (condition.apply(neighbor.position).booleanValue()) {
                return neighbor.position;
            }
            processedNeighbors.add(neighbor.position);
            for (Direction dir : Direction.values()) {
                BlockPos newPos = neighbor.position.m_7918_(dir.m_122429_(), dir.m_122430_(), dir.m_122431_());
                if (processedNeighbors.contains(newPos) || seenNeighbors.contains(newPos)) continue;
                seenNeighbors.add(newPos);
                neighbors.add(new Neighbor(newPos, newPos.m_252807_().m_82554_(origin)));
            }
        }
        return null;
    }
}

