/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.woukie.createmissiles.block.FrostSnowLayer;
import org.jetbrains.annotations.Nullable;

public class InfernalAshLayer
extends Block {
    public static final int MAX_HEIGHT = 8;
    public static final IntegerProperty LAYERS = BlockStateProperties.f_61417_;
    protected static final VoxelShape[] SHAPE_BY_LAYER = new VoxelShape[]{Shapes.m_83040_(), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    public static final int HEIGHT_IMPASSABLE = 5;

    public InfernalAshLayer(BlockBehaviour.Properties properties) {
        super(properties);
        properties.m_280606_();
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(1)));
    }

    public void m_141947_(Level level, BlockPos blockPos, BlockState blockState, Entity entity) {
        if (!entity.m_6095_().equals(EntityType.f_20551_)) {
            int damage = (Integer)blockState.m_61143_((Property)FrostSnowLayer.LAYERS) * 2 / 8;
            entity.m_6469_(level.m_269111_().m_269264_(), (float)damage);
        }
    }

    public boolean m_5946_(BlockState blockState, Fluid fluid) {
        return super.m_5946_(blockState, fluid);
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        if (Objects.requireNonNull(pathComputationType) == PathComputationType.LAND) {
            return (Integer)blockState.m_61143_((Property)LAYERS) < 5;
        }
        return false;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_7947_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public VoxelShape m_5909_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE_BY_LAYER[(Integer)blockState.m_61143_((Property)LAYERS)];
    }

    public boolean m_7923_(BlockState blockState) {
        return true;
    }

    public float m_7749_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return (Integer)blockState.m_61143_((Property)LAYERS) == 8 ? 0.2f : 1.0f;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        BlockState blockState2 = levelReader.m_8055_(blockPos.m_7495_());
        if (blockState2.m_204336_(BlockTags.f_215833_)) {
            return false;
        }
        if (blockState2.m_204336_(BlockTags.f_215834_)) {
            return true;
        }
        return Block.m_49918_((VoxelShape)blockState2.m_60812_((BlockGetter)levelReader, blockPos.m_7495_()), (Direction)Direction.UP) || blockState2.m_60713_((Block)this) && (Integer)blockState2.m_61143_((Property)LAYERS) == 8;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean m_6864_(BlockState blockState, BlockPlaceContext blockPlaceContext) {
        int i = (Integer)blockState.m_61143_((Property)LAYERS);
        if (blockPlaceContext.m_43722_().m_150930_(this.m_5456_()) && i < 8) {
            if (blockPlaceContext.m_7058_()) {
                return blockPlaceContext.m_43719_() == Direction.UP;
            }
            return true;
        }
        return i == 1;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        BlockState blockState = blockPlaceContext.m_43725_().m_8055_(blockPlaceContext.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            int i = (Integer)blockState.m_61143_((Property)LAYERS);
            return (BlockState)blockState.m_61124_((Property)LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        return super.m_5573_(blockPlaceContext);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LAYERS});
    }
}

