/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.controlpanel;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.MultiblockHelper;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlock;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlockEntity;
import net.woukie.createmissiles.block.controlpanel.ControlPanelInstanceTracker;
import net.woukie.createmissiles.block.controlpanel.messages.TriggerBuildParticles;
import net.woukie.createmissiles.block.entity.AbstractBasicBlockEntity;
import net.woukie.createmissiles.block.launchpad.LaunchPadBlock;
import net.woukie.createmissiles.block.launchpad.LaunchPadBlockEntity;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelBlockEntity;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.inventory.ControlPanelMenu;
import net.woukie.createmissiles.missiles.Trajectories;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.MissilePartType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.trajectories.BallisticTrajectory;
import net.woukie.createmissiles.recipe.MissileIngredient;
import net.woukie.createmissiles.recipe.MissilePartRecipe;
import net.woukie.createmissiles.registry.BlockEntities;
import net.woukie.createmissiles.registry.Blocks;
import net.woukie.createmissiles.registry.EntityTypes;
import net.woukie.createmissiles.registry.Packets;
import net.woukie.createmissiles.registry.PartTypes;
import net.woukie.createmissiles.registry.RecipeTypes;
import net.woukie.createmissiles.registry.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ControlPanelBlockEntity
extends AbstractBasicBlockEntity {
    public static final double speedRequired = 64.0;
    private boolean initialized;
    private UUID entityId = null;
    private final ContainerData dataAccess;
    private boolean launching = false;
    private AssemblyPanelBlockEntity assemblyPanel;
    private BlockPos cornerLaunchPadPos;
    private int warheadBuildPercent;
    private int chassisBuildPercent;
    private int thrusterBuildPercent;

    public ControlPanelBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.items = NonNullList.m_122780_((int)96, (Object)ItemStack.f_41583_);
        this.dataAccess = new ContainerData(){

            public int m_6413_(int i) {
                return switch (i) {
                    case 0 -> ControlPanelBlockEntity.this.m_58899_().m_123341_();
                    case 1 -> ControlPanelBlockEntity.this.m_58899_().m_123342_();
                    case 2 -> ControlPanelBlockEntity.this.m_58899_().m_123343_();
                    case 3 -> {
                        if (ControlPanelBlockEntity.this.cornerLaunchPadPos == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 4 -> {
                        if (ControlPanelBlockEntity.this.assemblyPanel == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 5 -> {
                        if (MultiblockHelper.findEdgeBlock((BlockEntity)ControlPanelBlockEntity.this, ControlPanelBlockEntity.this.m_58904_(), (BlockEntityType)BlockEntities.NAVIGATION_PANEL.get()) == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 6 -> (int)ControlPanelBlockEntity.this.getSpeed();
                    default -> 0;
                };
            }

            public void m_8050_(int i, int j) {
            }

            public int m_6499_() {
                return 7;
            }
        };
    }

    public float getSpeed() {
        BlockEntity blockEntity;
        Direction launchPadDirection = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        BlockPos launchPad = this.m_58899_().m_5484_(launchPadDirection, 1);
        Level level = this.m_58904_();
        if (level != null && (blockEntity = level.m_7702_(launchPad)) instanceof LaunchPadBlockEntity) {
            LaunchPadBlockEntity launchPadBlockEntity = (LaunchPadBlockEntity)blockEntity;
            return launchPadBlockEntity.getSpeed();
        }
        return 0.0f;
    }

    public void giveItem(@NotNull ItemStack itemStack) {
        MissilePartRecipe recipe = this.findAcceptingRecipe(itemStack);
        if (recipe == null) {
            return;
        }
        MissilePartType partType = PartTypes.get(recipe.getAssembly());
        this.addItemToPartOfInventory(itemStack, partType.getStartSlot(), partType.getEndSlot());
    }

    private void addItemToPartOfInventory(ItemStack itemStack, int fromIndex, int toIndex) {
        ItemStack stack;
        int i;
        for (i = fromIndex; i < toIndex; ++i) {
            stack = this.m_8020_(i);
            if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)itemStack)) continue;
            itemStack.m_41764_(0);
            stack.m_41769_(1);
            return;
        }
        for (i = fromIndex; i < toIndex; ++i) {
            stack = this.m_8020_(i);
            if (!stack.m_41619_()) continue;
            this.m_6836_(i, itemStack.m_278832_());
            return;
        }
    }

    public MissilePartRecipe findAcceptingRecipe(ItemStack itemStack) {
        if (this.f_58857_ == null || itemStack.m_41613_() != 1) {
            return null;
        }
        if (this.assemblyPanel == null) {
            return null;
        }
        MissilePartType warheadType = PartTypes.get(this.assemblyPanel.m_8020_(0));
        MissilePartType chassisType = PartTypes.get(this.assemblyPanel.m_8020_(1));
        MissilePartType thrusterType = PartTypes.get(this.assemblyPanel.m_8020_(2));
        List missilePartRecipes = this.f_58857_.m_7465_().m_44013_((RecipeType)RecipeTypes.MISSILE_PART.get());
        for (MissilePartRecipe recipe : missilePartRecipes) {
            ResourceLocation assembly = recipe.getAssembly();
            if (!(warheadType != null && assembly.equals((Object)warheadType.getResourceLocation()) || chassisType != null && assembly.equals((Object)chassisType.getResourceLocation())) && (thrusterType == null || !assembly.equals((Object)thrusterType.getResourceLocation())) || !recipe.itemComplements(itemStack, (Container)this)) continue;
            return recipe;
        }
        return null;
    }

    public void tick() {
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)AssemblyPanelBlock.f_54117_)).m_122424_();
        this.cornerLaunchPadPos = MultiblockHelper.findCorner(this.m_58899_(), facing, this.f_58857_);
        this.assemblyPanel = (AssemblyPanelBlockEntity)MultiblockHelper.findEdgeBlock(this.cornerLaunchPadPos, facing, this.m_58904_(), (BlockEntityType)BlockEntities.ASSEMBLY_PANEL.get());
        int oldWarheadBuildPercent = this.warheadBuildPercent;
        int oldChassisBuildPercent = this.chassisBuildPercent;
        int oldThrusterBuildPercent = this.thrusterBuildPercent;
        int oldBuildTotal = oldWarheadBuildPercent + oldChassisBuildPercent + oldThrusterBuildPercent;
        this.warheadBuildPercent = 0;
        this.chassisBuildPercent = 0;
        this.thrusterBuildPercent = 0;
        if (this.assemblyPanel == null) {
            return;
        }
        MissilePartType warheadType = PartTypes.get(this.assemblyPanel.m_8020_(0));
        MissilePartType chassisType = PartTypes.get(this.assemblyPanel.m_8020_(1));
        MissilePartType thrusterType = PartTypes.get(this.assemblyPanel.m_8020_(2));
        this.warheadBuildPercent = MissilePartRecipe.getBuildPercentage(warheadType, this.f_58857_, (List<ItemStack>)this.items);
        this.chassisBuildPercent = MissilePartRecipe.getBuildPercentage(chassisType, this.f_58857_, (List<ItemStack>)this.items);
        this.thrusterBuildPercent = MissilePartRecipe.getBuildPercentage(thrusterType, this.f_58857_, (List<ItemStack>)this.items);
        if (this.f_58857_ != null) {
            BlockPos soundOrigin = this.cornerLaunchPadPos.m_121945_(facing).m_121945_(facing.m_122427_());
            int newBuildTotal = this.warheadBuildPercent + this.chassisBuildPercent + this.thrusterBuildPercent;
            if (oldBuildTotal < newBuildTotal) {
                Vec3 p = soundOrigin.m_252807_();
                if (!this.f_58857_.f_46443_) {
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((LaunchPadBlock)((Object)Blocks.LAUNCH_PAD.get())).m_49966_()), p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, 10, 0.5, 0.0, 0.5, 45.0);
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123755_, p.f_82479_, p.f_82480_ + 0.5, p.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    boolean partComplete = oldWarheadBuildPercent != 100 && this.warheadBuildPercent == 100 || oldChassisBuildPercent != 100 && this.chassisBuildPercent == 100 || oldThrusterBuildPercent != 100 && this.thrusterBuildPercent == 100;
                    float pitch = (float)newBuildTotal / 1200.0f + 0.75f;
                    pitch += (float)(Math.random() / 5.0) - 0.1f;
                    if (newBuildTotal == 300) {
                        this.f_58857_.m_247517_(null, soundOrigin, (SoundEvent)SoundEvents.DING.get(), SoundSource.BLOCKS);
                    } else if (partComplete) {
                        this.f_58857_.m_5594_(null, soundOrigin, (SoundEvent)SoundEvents.BUILD_SPECIAL.get(), SoundSource.BLOCKS, 1.0f, pitch);
                    } else {
                        this.f_58857_.m_5594_(null, soundOrigin, (SoundEvent)SoundEvents.BUILD.get(), SoundSource.BLOCKS, 1.0f, pitch);
                    }
                    Packets.TRIGGER_BUILD_PARTICLES.sendToPlayers((Iterable)((ServerLevel)this.f_58857_).m_8795_(serverPlayer -> serverPlayer.m_20182_().m_82554_(p) < 128.0), (Object)new TriggerBuildParticles(p.m_252839_(), warheadType == null ? new ResourceLocation("") : warheadType.getResourceLocation(), chassisType == null ? new ResourceLocation("") : chassisType.getResourceLocation(), thrusterType == null ? new ResourceLocation("") : thrusterType.getResourceLocation(), this.warheadBuildPercent, this.chassisBuildPercent, this.thrusterBuildPercent));
                }
            }
        }
    }

    public void serverTick() {
        ServerLevel level;
        if (!this.initialized && this.m_58898_()) {
            this.initialized = true;
            ControlPanelInstanceTracker.add(this);
        }
        if ((level = (ServerLevel)this.m_58904_()) == null) {
            return;
        }
        if (this.launching) {
            this.launch();
        }
        BlockPos entityPosition = this.m_58899_();
        if (this.cornerLaunchPadPos != null) {
            Direction forward = ((Direction)this.m_58900_().m_61143_((Property)AssemblyPanelBlock.f_54117_)).m_122424_();
            entityPosition = new BlockPos((Vec3i)this.cornerLaunchPadPos).m_121945_(forward).m_121945_(forward.m_122427_());
        }
        Entity entity = level.m_8791_(this.entityId);
        if (this.entityId == null) {
            entity = new MissileEntity((EntityType)EntityTypes.MISSILE.get(), (Level)level);
            entity.m_6034_((double)entityPosition.m_123341_() + 0.5, (double)entityPosition.m_123342_() + 0.5, (double)entityPosition.m_123343_() + 0.5);
            level.m_7967_(entity);
            this.entityId = entity.m_20148_();
            this.m_6596_();
        }
        if (entity != null && entity.m_6095_().equals(EntityTypes.MISSILE.get())) {
            MissileEntity missileEntity = (MissileEntity)entity;
            if (this.cornerLaunchPadPos == null) {
                this.ejectNotNeededItems(null, 0, 96);
                missileEntity.setWarheadBuildPercent(0);
                missileEntity.setChassisBuildPercent(0);
                missileEntity.setThrusterBuildPercent(0);
            }
            if (this.assemblyPanel != null) {
                ItemStack warheadItem = this.assemblyPanel.m_8020_(0);
                ItemStack chassisItem = this.assemblyPanel.m_8020_(1);
                ItemStack thrusterItem = this.assemblyPanel.m_8020_(2);
                MissilePartType warheadType = PartTypes.get(warheadItem);
                MissilePartType chassisType = PartTypes.get(chassisItem);
                MissilePartType thrusterType = PartTypes.get(thrusterItem);
                missileEntity.setWarheadBuildPercent(this.warheadBuildPercent);
                missileEntity.setWarheadType(warheadType == null ? null : warheadType.getResourceLocation());
                missileEntity.setChassisBuildPercent(this.chassisBuildPercent);
                missileEntity.setChassisType(chassisType == null ? null : chassisType.getResourceLocation());
                missileEntity.setThrusterBuildPercent(this.thrusterBuildPercent);
                missileEntity.setThrusterType(thrusterType == null ? null : thrusterType.getResourceLocation());
                this.ejectNotNeededItems(warheadType, 0, 32);
                this.ejectNotNeededItems(chassisType, 32, 64);
                this.ejectNotNeededItems(thrusterType, 64, 96);
            } else {
                this.ejectNotNeededItems(null, 0, 96);
                missileEntity.setWarheadBuildPercent(0);
                missileEntity.setChassisBuildPercent(0);
                missileEntity.setThrusterBuildPercent(0);
            }
            missileEntity.m_146884_(entityPosition.m_252807_());
        }
    }

    private void ejectNotNeededItems(@Nullable MissilePartType partType, int backupStartSlot, int backupEndSlot) {
        if (this.f_58857_ == null) {
            return;
        }
        Optional<MissilePartRecipe> recipe = MissilePartRecipe.fromResourceLocation(this.f_58857_, partType == null ? null : partType.getResourceLocation());
        Map ingredientStatus = recipe.map(a -> a.getMissileIngredients().stream().collect(Collectors.toMap(b -> b, MissileIngredient::count))).orElseGet(Map::of);
        int start = partType != null ? partType.getStartSlot() : backupStartSlot;
        int end = partType != null ? partType.getEndSlot() : backupEndSlot;
        for (int i = start; i < end; ++i) {
            ItemStack item = this.m_8020_(i);
            if (item.m_41619_()) continue;
            Optional<MissileIngredient> matchingIngredient = ingredientStatus.keySet().stream().filter(a -> a.test(item)).findFirst();
            if (matchingIngredient.isPresent()) {
                int requiredCount;
                int itemCount = item.m_41613_();
                if (itemCount < (requiredCount = ((Integer)ingredientStatus.get(matchingIngredient.get())).intValue())) {
                    ingredientStatus.put(matchingIngredient.get(), requiredCount - itemCount);
                    continue;
                }
                if (itemCount != requiredCount) {
                    ItemStack ejected = item.m_41620_(requiredCount - itemCount);
                    DefaultDispenseItemBehavior.m_123378_((Level)this.f_58857_, (ItemStack)ejected, (int)1, (Direction)Direction.UP, (Position)this.m_58899_().m_252807_());
                }
                ingredientStatus.remove(matchingIngredient.get());
                continue;
            }
            DefaultDispenseItemBehavior.m_123378_((Level)this.f_58857_, (ItemStack)item.m_278832_(), (int)1, (Direction)Direction.UP, (Position)this.m_58899_().m_252807_());
        }
    }

    public void launch() {
        if (this.m_58904_() == null || this.m_58904_().m_7654_() == null || Thread.currentThread() != this.m_58904_().m_7654_().m_6304_()) {
            this.launching = true;
            return;
        }
        this.launching = false;
        if (this.cornerLaunchPadPos == null) {
            return;
        }
        if (this.assemblyPanel == null) {
            return;
        }
        NavigationPanelBlockEntity navigationPanel = (NavigationPanelBlockEntity)MultiblockHelper.findEdgeBlock((BlockEntity)this, this.m_58904_(), (BlockEntityType)BlockEntities.NAVIGATION_PANEL.get());
        if (navigationPanel == null) {
            return;
        }
        if ((double)Math.abs(this.getSpeed()) < 64.0) {
            return;
        }
        MissilePartRecipe warheadRecipe = null;
        MissilePartRecipe chassisRecipe = null;
        MissilePartRecipe thrusterRecipe = null;
        WarheadType warheadType = (WarheadType)PartTypes.get(this.assemblyPanel.m_8020_(0));
        ChassisType chassisType = (ChassisType)PartTypes.get(this.assemblyPanel.m_8020_(1));
        ThrusterType thrusterType = (ThrusterType)PartTypes.get(this.assemblyPanel.m_8020_(2));
        if (warheadType == null || chassisType == null || thrusterType == null) {
            return;
        }
        List missilePartRecipes = this.m_58904_().m_7465_().m_44013_((RecipeType)RecipeTypes.MISSILE_PART.get());
        for (MissilePartRecipe recipe : missilePartRecipes) {
            if (warheadRecipe != null && chassisRecipe != null && thrusterRecipe != null) break;
            ResourceLocation assembly = recipe.getAssembly();
            if (assembly.equals((Object)warheadType.getResourceLocation())) {
                warheadRecipe = recipe;
                continue;
            }
            if (assembly.equals((Object)chassisType.getResourceLocation())) {
                chassisRecipe = recipe;
                continue;
            }
            if (!assembly.equals((Object)thrusterType.getResourceLocation())) continue;
            thrusterRecipe = recipe;
        }
        if (warheadRecipe == null || chassisRecipe == null || thrusterRecipe == null) {
            return;
        }
        if (!warheadRecipe.m_5818_((Container)this, this.m_58904_())) {
            return;
        }
        if (!chassisRecipe.m_5818_((Container)this, this.m_58904_())) {
            return;
        }
        if (!thrusterRecipe.m_5818_((Container)this, this.m_58904_())) {
            return;
        }
        Direction launchPadDirection = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        BlockPos targetBlock = navigationPanel.getTarget();
        if (targetBlock == null) {
            return;
        }
        Vector3f target = targetBlock.m_252807_().m_252839_();
        BlockPos sourceBlockPos = this.cornerLaunchPadPos.m_5484_(launchPadDirection, 1).m_121945_(launchPadDirection.m_122427_());
        Vector3f source = sourceBlockPos.m_252807_().m_252839_();
        this.m_58904_().m_247517_(null, sourceBlockPos, (SoundEvent)SoundEvents.BUTTON.get(), SoundSource.BLOCKS);
        Trajectory trajectory = thrusterType.createTrajectory(this.f_58857_, new Vector3d((Vector3fc)source), new Vector3d((Vector3fc)target), warheadType, chassisType, thrusterType, (Container)this, navigationPanel);
        if (trajectory instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)trajectory;
            ballisticTrajectory.setLowerLaunchAngle(navigationPanel.getLowerLaunchAngle());
            ballisticTrajectory.setUpperLaunchAngle(navigationPanel.getUpperLaunchAngle());
        }
        Trajectories trajectories = Trajectories.get();
        trajectories.launch(trajectory);
        warheadType.onLaunch(trajectory, (ServerLevel)this.f_58857_);
        chassisType.onLaunch(trajectory, (ServerLevel)this.f_58857_);
        thrusterType.onLaunch(trajectory, (ServerLevel)this.f_58857_);
        trajectories.m_77762_();
        this.m_6211_();
    }

    public int m_6893_() {
        return Integer.MAX_VALUE;
    }

    public void m_7651_() {
        ServerLevel level;
        Entity entity;
        super.m_7651_();
        ControlPanelInstanceTracker.remove(this);
        if (this.m_58904_() != null && !this.m_58904_().f_46443_ && (entity = (level = (ServerLevel)this.m_58904_()).m_8791_(this.entityId)) != null && entity.m_6095_().equals(EntityTypes.MISSILE.get())) {
            entity.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void m_142466_(@NotNull CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compoundTag, (NonNullList)this.items);
        if (compoundTag.m_128441_("EntityID")) {
            this.entityId = compoundTag.m_128342_("EntityID");
        }
    }

    protected void m_183515_(@NotNull CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        ContainerHelper.m_18973_((CompoundTag)compoundTag, (NonNullList)this.items);
        if (this.entityId != null) {
            compoundTag.m_128362_("EntityID", this.entityId);
        }
    }

    public void m_187476_(@NotNull ItemStack itemStack) {
        CompoundTag data = this.m_187482_();
        data.m_128473_("EntityID");
        data.m_128473_("Items");
        BlockItem.m_186338_((ItemStack)itemStack, (BlockEntityType)this.m_58903_(), (CompoundTag)data);
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"container.createmissiles.control_panel");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int id, @NotNull Inventory playerInventory) {
        Direction facing = ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
        BlockEntity navigationPanel = MultiblockHelper.findEdgeBlock(this.cornerLaunchPadPos, facing, this.m_58904_(), (BlockEntityType)BlockEntities.NAVIGATION_PANEL.get());
        return new ControlPanelMenu(id, playerInventory, (Container)this, this.dataAccess, (Container)(this.assemblyPanel == null ? new SimpleContainer(3) : this.assemblyPanel), (Container)(navigationPanel == null ? new SimpleContainer(1) : (Container)navigationPanel));
    }

    @Override
    public boolean m_7155_(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return false;
    }

    @Override
    public boolean m_7157_(int i, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return false;
    }
}

