/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.controlpanel.messages;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.woukie.createmissiles.client.MissilePartModel;
import net.woukie.createmissiles.missiles.parts.MissilePartType;
import net.woukie.createmissiles.registry.PartModels;
import net.woukie.createmissiles.registry.PartTypes;
import net.woukie.createmissiles.registry.ParticleTypes;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TriggerBuildParticles {
    public final Vector3f pos;
    public final ResourceLocation warhead;
    public final ResourceLocation chassis;
    public final ResourceLocation thruster;
    public final int warheadBuildPercent;
    public final int chassisBuildPercent;
    public final int thrusterBuildPercent;

    public TriggerBuildParticles(FriendlyByteBuf buf) {
        this(buf.m_269394_(), buf.m_130281_(), buf.m_130281_(), buf.m_130281_(), buf.readInt(), buf.readInt(), buf.readInt());
    }

    public TriggerBuildParticles(Vector3f pos, ResourceLocation warhead, ResourceLocation chassis, ResourceLocation thruster, int warheadBuildPercent, int chassisBuildPercent, int thrusterBuildPercent) {
        this.pos = pos;
        this.warhead = warhead;
        this.chassis = chassis;
        this.thruster = thruster;
        this.warheadBuildPercent = warheadBuildPercent;
        this.chassisBuildPercent = chassisBuildPercent;
        this.thrusterBuildPercent = thrusterBuildPercent;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_269582_(this.pos);
        buf.m_130085_(this.warhead);
        buf.m_130085_(this.chassis);
        buf.m_130085_(this.thruster);
        buf.writeInt(this.warheadBuildPercent);
        buf.writeInt(this.chassisBuildPercent);
        buf.writeInt(this.thrusterBuildPercent);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        MissilePartModel model;
        MissilePartType warheadType = PartTypes.get(this.warhead);
        MissilePartType chassisType = PartTypes.get(this.chassis);
        MissilePartType thrusterType = PartTypes.get(this.thruster);
        Map<Object, Object> thrusterAttachments = new HashMap();
        Map<Object, Object> chassisAttachments = new HashMap();
        Map<Object, Object> warheadAttachments = new HashMap();
        if (thrusterType != null) {
            model = PartModels.getModel(thrusterType.getResourceLocation());
            thrusterAttachments = model.getAttachements(model.getStage(this.thrusterBuildPercent));
        }
        if (chassisType != null) {
            model = PartModels.getModel(chassisType.getResourceLocation());
            chassisAttachments = model.getAttachements(model.getStage(this.chassisBuildPercent));
        }
        if (warheadType != null) {
            model = PartModels.getModel(warheadType.getResourceLocation());
            warheadAttachments = model.getAttachements(model.getStage(this.thrusterBuildPercent));
        }
        Vector3f rocketTip = new Vector3f().add((Vector3fc)thrusterAttachments.getOrDefault("bottom", new Vector3f())).add((Vector3fc)thrusterAttachments.getOrDefault("top", new Vector3f())).add((Vector3fc)chassisAttachments.getOrDefault("bottom", new Vector3f())).add((Vector3fc)chassisAttachments.getOrDefault("top", new Vector3f())).add((Vector3fc)warheadAttachments.getOrDefault("bottom", new Vector3f())).add((Vector3fc)warheadAttachments.getOrDefault("top", new Vector3f())).div(16.0f);
        double r = Math.random();
        int i = 0;
        while ((double)i < r * 2.0 + 1.0) {
            double x = (double)this.pos.x + (double)rocketTip.x * Math.random();
            double y = (double)this.pos.y + 0.5 + (double)rocketTip.y * Math.random();
            double z = (double)this.pos.z + (double)rocketTip.z * Math.random();
            x += Math.random() * 0.1 - 0.05;
            z += Math.random() * 0.1 - 0.05;
            for (int j = 0; j < 10; ++j) {
                Player player = contextSupplier.get().getPlayer();
                if (player == null) {
                    return;
                }
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.BUILD_SHRAPNEL.get(), x, y, z, 0.0, 0.0, 0.0);
            }
            ++i;
        }
    }
}

