/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.launchpad;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.woukie.createmissiles.MultiblockHelper;
import net.woukie.createmissiles.block.controlpanel.ControlPanelBlockEntity;
import net.woukie.createmissiles.block.launchpad.LaunchPadBlockEntity;
import net.woukie.createmissiles.registry.BlockEntities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchPadBlock
extends KineticBlock
implements IBE<LaunchPadBlockEntity>,
ICogWheel,
WorldlyContainerHolder {
    public LaunchPadBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public WorldlyContainer m_5840_(@NotNull BlockState blockState, @NotNull LevelAccessor levelAccessor, @NotNull BlockPos blockPos) {
        return new InputContainer(levelAccessor, blockPos);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return Direction.Axis.Y;
    }

    public Class<LaunchPadBlockEntity> getBlockEntityClass() {
        return LaunchPadBlockEntity.class;
    }

    public BlockEntityType<? extends LaunchPadBlockEntity> getBlockEntityType() {
        return (BlockEntityType)BlockEntities.LAUNCH_PAD.get();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.375, (double)1.0), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.625, (double)0.0, (double)1.0, (double)0.8125, (double)1.0));
    }

    public IRotate.SpeedLevel getMinimumRequiredSpeedLevel() {
        return IRotate.SpeedLevel.of((float)16.0f);
    }

    public boolean isSmallCog() {
        return true;
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final LevelAccessor level;
        private final BlockPos pos;

        public InputContainer(LevelAccessor levelAccessor, BlockPos blockPos) {
            super(1);
            this.level = levelAccessor;
            this.pos = blockPos;
        }

        public int m_6893_() {
            return 1;
        }

        public int @NotNull [] m_7071_(@NotNull Direction direction) {
            return new int[]{0};
        }

        public boolean m_7155_(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
            ControlPanelBlockEntity controlPanelBlockEntity = MultiblockHelper.findControlPanelFromLaunchPad((Level)this.level, this.pos);
            if (controlPanelBlockEntity == null) {
                return false;
            }
            return controlPanelBlockEntity.findAcceptingRecipe(itemStack) != null;
        }

        public boolean m_7157_(int i, @NotNull ItemStack itemStack, @NotNull Direction direction) {
            return false;
        }

        public void m_6596_() {
            ItemStack item = this.m_8020_(0);
            if (item.m_41619_()) {
                return;
            }
            ControlPanelBlockEntity controlPanelBlockEntity = MultiblockHelper.findControlPanelFromLaunchPad((Level)this.level, this.pos);
            if (controlPanelBlockEntity == null) {
                return;
            }
            controlPanelBlockEntity.giveItem(item);
        }
    }
}

