/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.navigationpanel.messages;

import dev.architectury.networking.NetworkManager;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelBlockEntity;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelInstanceTracker;

public class ClickFuelMessage {
    public final BlockPos source;
    public final float fuelPercent;

    public ClickFuelMessage(FriendlyByteBuf buf) {
        this(buf.m_130135_(), buf.readFloat());
    }

    public ClickFuelMessage(BlockPos source, float fuelPercent) {
        this.source = source;
        this.fuelPercent = fuelPercent;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.source);
        buf.writeFloat(this.fuelPercent);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        Player player = contextSupplier.get().getPlayer();
        if (player == null) {
            return;
        }
        NavigationPanelBlockEntity blockEntity = NavigationPanelInstanceTracker.get(player.m_9236_(), this.source);
        if (blockEntity == null) {
            return;
        }
        if (this.fuelPercent >= 0.0f && this.fuelPercent <= 1.0f) {
            blockEntity.fuelClicked(this.fuelPercent);
        }
    }
}

