/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.world.phys.Vec3;

public class FlashHandler {
    private static final ConcurrentLinkedQueue<Flash> flashes = new ConcurrentLinkedQueue();

    public static void addFlash(Flash flash) {
        flashes.add(flash);
    }

    public static void cleanUp() {
        flashes.removeIf(flash -> ((double)System.currentTimeMillis() - (double)flash.startTime) / (double)flash.length > 1.0);
    }

    public static void handleHudRender(GuiGraphics guiGraphics) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Vec3 position = player.m_20182_();
        flashes.forEach(flash -> {
            double timeIntensity = ((double)System.currentTimeMillis() - (double)flash.startTime) / (double)flash.length;
            if (timeIntensity >= 1.0) {
                return;
            }
            timeIntensity = Math.pow(1.0 - timeIntensity, 3.0);
            double distance = position.m_82554_(flash.origin.m_252807_());
            distance = Math.min(distance / (double)flash.radius.intValue(), 1.0);
            double distanceIntensity = Math.pow(1.0 - distance, 3.0);
            int colour = FastColor.ARGB32.m_13660_((int)((int)(255.0 * distanceIntensity * timeIntensity)), (int)FastColor.ARGB32.m_13665_((int)flash.colour), (int)FastColor.ARGB32.m_13667_((int)flash.colour), (int)FastColor.ARGB32.m_13669_((int)flash.colour));
            guiGraphics.m_280509_(0, 0, guiGraphics.m_280182_(), guiGraphics.m_280206_(), colour);
        });
    }

    public static void handleRenderLevel(PoseStack poseStack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Vec3 position = player.m_20182_();
        for (Flash flash : flashes) {
            double timeIntensity = ((double)System.currentTimeMillis() - (double)flash.startTime) / (double)flash.length;
            double shakeIndex = timeIntensity * (double)(flash.shakeSamples.size() - 2);
            if (timeIntensity >= 1.0) continue;
            timeIntensity = Math.pow(1.0 - timeIntensity, 3.0);
            Vec3 shake1 = flash.shakeSamples.get((int)shakeIndex);
            Vec3 shake2 = flash.shakeSamples.get((int)shakeIndex + 1);
            Vec3 shake = shake1.m_165921_(shake2, shakeIndex % 1.0);
            double distance = position.m_82554_(flash.origin.m_252807_());
            distance = Math.min(distance / (double)flash.radius.intValue(), 1.0);
            double intensity = Math.pow(1.0 - distance, 3.0);
            double scaledIntensity = Math.pow(-(flash.intensity / 4.0 + 1.0), -1.0) + 1.0;
            shake = shake.m_82490_(timeIntensity * intensity * scaledIntensity * 3.0);
            poseStack.m_85837_(shake.f_82479_, shake.f_82480_, shake.f_82481_);
        }
    }

    public static class Flash {
        public BlockPos origin;
        public Integer colour;
        public Integer radius;
        public Double intensity;
        public long startTime;
        public long length;
        public List<Vec3> shakeSamples = new ArrayList<Vec3>();

        public Flash(Integer colour, BlockPos origin, Integer radius, Double intensity, long length) {
            this.colour = colour;
            this.origin = origin;
            this.radius = radius;
            this.intensity = intensity;
            this.startTime = System.currentTimeMillis();
            this.length = length;
            int i = 0;
            while ((long)i < 20L * length / 1000L) {
                this.shakeSamples.add(new Vec3(Math.random() * 2.0 - 0.5, Math.random() * 2.0 - 0.5, Math.random() * 2.0 - 0.5));
                ++i;
            }
        }
    }
}

