/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client.screens;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.inventory.ControlPanelMenu;
import net.woukie.createmissiles.recipe.MissileIngredient;
import net.woukie.createmissiles.recipe.MissilePartRecipe;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;

public class ControlPanelScreen
extends AbstractContainerScreen<ControlPanelMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("createmissiles", "textures/gui/container/control_panel.png");
    private static final ResourceLocation COVER_LEFT = new ResourceLocation("createmissiles", "textures/gui/sprites/container/cover_l.png");
    private static final ResourceLocation COVER_RIGHT = new ResourceLocation("createmissiles", "textures/gui/sprites/container/cover_r.png");
    private static final ResourceLocation BUTTON = new ResourceLocation("createmissiles", "textures/gui/sprites/container/button.png");
    private static final ResourceLocation BUTTON_HOVER = new ResourceLocation("createmissiles", "textures/gui/sprites/container/button_hover.png");
    private static final int consoleLeft = 8;
    private static final int consoleTop = 18;
    private static final int consoleWidth = 105;
    private static final int consoleHeight = 52;
    private static final int buttonLeft = 116;
    private static final int buttonTop = 18;
    private static final int buttonWidth = 52;
    private static final int buttonHeight = 52;
    private static final int coverLeft = 116;
    private static final int coverTop = 18;
    private static final int coverWidth = 26;
    private static final int coverHeight = 52;
    private static final List<Character> textAnimatePallette = List.of(Character.valueOf('\u2588'), Character.valueOf('\u2593'), Character.valueOf('\u2592'), Character.valueOf('\u2591'), Character.valueOf(' '));
    private static final double textAnimateWaveLenth = 3.0;
    private double currentOpenPercent = 0.0;
    private double currentScrollPosition = 0.0;
    private final long openedTime = System.currentTimeMillis();

    public ControlPanelScreen(ControlPanelMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    public void m_88315_(@NotNull GuiGraphics gui, int i, int j, float f) {
        super.m_88315_(gui, i, j, f);
        this.m_280072_(gui, i, j);
    }

    private void renderButton(@NotNull GuiGraphics gui, boolean buttonOpen, double mouseX, double mouseY) {
        double speed = 0.01f;
        double targetOpenPercent = buttonOpen ? 1.0 : 0.0;
        this.currentOpenPercent += targetOpenPercent > this.currentOpenPercent ? speed : -speed;
        double adjusted = buttonOpen ? this.easeOutBounce(this.currentOpenPercent) : this.easeInBounce(this.currentOpenPercent);
        int width = (int)(adjusted * 26.0 + 0.5);
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, 0.0f, 2.0f);
        gui.m_280163_(COVER_LEFT, 116, 18, (float)width, 0.0f, 26 - width, 52, 26, 52);
        gui.m_280163_(COVER_RIGHT, 142 + width, 18, 0.0f, 0.0f, 26 - width, 52, 26, 52);
        gui.m_280168_().m_85849_();
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        ResourceLocation resource = buttonOpen && this.m_6774_(116, 18, 52, 52, mouseX, mouseY) ? BUTTON_HOVER : BUTTON;
        gui.m_280163_(resource, 116, 18, 0.0f, 0.0f, 52, 52, 52, 52);
        gui.m_280168_().m_85849_();
    }

    private double easeOutBounce(double x) {
        double n1 = 7.5625;
        double d1 = 2.75;
        if (x < 1.0 / d1) {
            return n1 * x * x;
        }
        if (x < 2.0 / d1) {
            return n1 * (x -= 1.5 / d1) * x + 0.75;
        }
        if (x < 2.5 / d1) {
            return n1 * (x -= 2.25 / d1) * x + 0.9375;
        }
        return n1 * (x -= 2.625 / d1) * x + 0.984375;
    }

    private double easeInBounce(double x) {
        return 1.0 - this.easeOutBounce(1.0 - x);
    }

    private boolean renderLogs(GuiGraphics gui) {
        ArrayList<Text> text = new ArrayList<Text>();
        boolean launchPadValid = this.addLaunchPadStatus(text);
        boolean navigationPanelValid = this.addNavigationPanelStatus(text);
        boolean assemblyPanelValid = this.addAssemblyPanelStatus(text);
        int lineCount = 9;
        ClientLevel level = this.f_96541_ != null ? this.f_96541_.f_91073_ : null;
        Map<MissileIngredient, Integer> warheadItemsLeft = MissilePartRecipe.getRemainingItems(PartTypes.get(((ControlPanelMenu)this.m_6262_()).getWarhead()), (Level)level, (List<ItemStack>)((ControlPanelMenu)this.m_6262_()).m_38927_());
        Map<MissileIngredient, Integer> chassisItemsLeft = MissilePartRecipe.getRemainingItems(PartTypes.get(((ControlPanelMenu)this.m_6262_()).getChassis()), (Level)level, (List<ItemStack>)((ControlPanelMenu)this.m_6262_()).m_38927_());
        Map<MissileIngredient, Integer> thrusterItemsLeft = MissilePartRecipe.getRemainingItems(PartTypes.get(((ControlPanelMenu)this.m_6262_()).getThruster()), (Level)level, (List<ItemStack>)((ControlPanelMenu)this.m_6262_()).m_38927_());
        int warheadPercent = MissilePartRecipe.getBuildPercentage(warheadItemsLeft);
        int chassisPercent = MissilePartRecipe.getBuildPercentage(chassisItemsLeft);
        int thrusterPercent = MissilePartRecipe.getBuildPercentage(thrusterItemsLeft);
        text.add(new Text("\n" + Component.m_237115_((String)"gui.createmissiles.control_panel.warhead_title").getString() + ": ", Color.WHITE));
        text.add(new Text(warheadPercent + "%\n", warheadPercent == 0 ? Color.RED : (warheadPercent == 100 ? Color.GREEN : Color.YELLOW)));
        if (warheadItemsLeft != null) {
            lineCount += this.writeIngredientStatus(text, warheadItemsLeft);
        }
        text.add(new Text("\n" + Component.m_237115_((String)"gui.createmissiles.control_panel.chassis_title").getString() + ": ", Color.WHITE));
        text.add(new Text(chassisPercent + "%\n", chassisPercent == 0 ? Color.RED : (chassisPercent == 100 ? Color.GREEN : Color.YELLOW)));
        if (chassisItemsLeft != null) {
            lineCount += this.writeIngredientStatus(text, chassisItemsLeft);
        }
        text.add(new Text("\n" + Component.m_237115_((String)"gui.createmissiles.control_panel.thruster_title").getString() + ": ", Color.WHITE));
        text.add(new Text(thrusterPercent + "%\n", thrusterPercent == 0 ? Color.RED : (thrusterPercent == 100 ? Color.GREEN : Color.YELLOW)));
        if (thrusterItemsLeft != null) {
            lineCount += this.writeIngredientStatus(text, thrusterItemsLeft);
        }
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_(8.0f, 18.0f, 0.0f);
        double lineHeight = 4.5;
        this.currentScrollPosition = Math.max(-lineHeight * (double)lineCount - 1.0 + 52.0, this.currentScrollPosition);
        this.currentScrollPosition = Math.min(0.0, this.currentScrollPosition);
        gui.m_280168_().m_85837_(0.0, this.currentScrollPosition, 0.0);
        gui.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        gui.m_280588_(8 + this.f_97735_, 18 + this.f_97736_, 8 + this.f_97735_ + 105, 18 + this.f_97736_ + 52);
        this.animateText(text);
        FormattedText formattedText = FormattedText.m_130768_(text.stream().map(a -> FormattedText.m_130762_((String)a.text, (Style)a.getStyle())).toList());
        gui.m_280554_(this.f_96547_, formattedText, 2, 2, 206, 100);
        gui.m_280618_();
        gui.m_280168_().m_85849_();
        return launchPadValid && navigationPanelValid && assemblyPanelValid && chassisPercent == 100 && warheadPercent == 100 && thrusterPercent == 100;
    }

    private void animateText(List<Text> text) {
        long timePassed = System.currentTimeMillis() - this.openedTime;
        int hideAfter = (int)(timePassed / 10L);
        int currentCharacter = 0;
        for (Text line : text) {
            StringBuilder obuscated = new StringBuilder();
            char[] cArray = line.text.toCharArray();
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character character = Character.valueOf(cArray[i]);
                if (currentCharacter <= hideAfter) {
                    if (!character.equals(Character.valueOf('\n'))) {
                        int distance = hideAfter - currentCharacter;
                        double proportionThroughList = (double)(distance += (int)(Math.random() * 3.0 - 1.5)) / ((double)textAnimatePallette.size() * 3.0);
                        if ((proportionThroughList = Math.max(0.0, proportionThroughList)) <= 1.0) {
                            int palletteIndex = (int)(proportionThroughList * (double)(textAnimatePallette.size() - 1));
                            character = textAnimatePallette.get(palletteIndex);
                        }
                    }
                    obuscated.append(character);
                }
                ++currentCharacter;
            }
            line.text = obuscated.toString();
        }
    }

    private boolean addLaunchPadStatus(List<Text> text) {
        String title = Component.m_237115_((String)"gui.createmissiles.control_panel.launch_pad_title").getString();
        text.add(new Text(title + ": ", Color.WHITE));
        if (!((ControlPanelMenu)this.m_6262_()).launchPadExists()) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.no_launch_pad").getString() + "\n";
            text.add(new Text(status, Color.RED));
            return false;
        }
        if (!((ControlPanelMenu)this.m_6262_()).launchPadPowered()) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.launch_pad_no_power").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        String status = Component.m_237115_((String)"gui.createmissiles.control_panel.valid").getString() + "\n";
        text.add(new Text(status, Color.GREEN));
        return true;
    }

    private boolean addNavigationPanelStatus(List<Text> text) {
        String title = Component.m_237115_((String)"gui.createmissiles.control_panel.navigation_panel_title").getString();
        text.add(new Text(title + ": ", Color.WHITE));
        if (!((ControlPanelMenu)this.m_6262_()).navigationPanelExists()) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.no_navigation_panel").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        if (!((ControlPanelMenu)this.m_6262_()).hasDestination()) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.no_destination").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        String status = Component.m_237115_((String)"gui.createmissiles.control_panel.valid").getString() + "\n";
        text.add(new Text(status, Color.GREEN));
        return true;
    }

    private boolean addAssemblyPanelStatus(List<Text> text) {
        String title = Component.m_237115_((String)"gui.createmissiles.control_panel.assembly_panel_title").getString();
        text.add(new Text(title + ": ", Color.WHITE));
        if (!((ControlPanelMenu)this.m_6262_()).assemblyPanelExists()) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.no_assembly_panel").getString() + "\n";
            text.add(new Text(status, Color.RED));
            return false;
        }
        ItemStack warheadStack = ((ControlPanelMenu)this.m_6262_()).getWarhead();
        ItemStack chassisStack = ((ControlPanelMenu)this.m_6262_()).getChassis();
        ItemStack thrusterStack = ((ControlPanelMenu)this.m_6262_()).getThruster();
        if (warheadStack == null) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.no_warhead").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        if (chassisStack == null) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.no_chassis").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        if (thrusterStack == null) {
            String status = Component.m_237115_((String)"gui.createmissiles.control_panel.no_thruster").getString() + "\n";
            text.add(new Text(status, Color.YELLOW));
            return false;
        }
        String status = Component.m_237115_((String)"gui.createmissiles.control_panel.valid").getString() + "\n";
        text.add(new Text(status, Color.GREEN));
        return true;
    }

    private int writeIngredientStatus(List<Text> text, Map<MissileIngredient, Integer> ingredients) {
        AtomicInteger increment = new AtomicInteger();
        ingredients.forEach((ingredient, left) -> {
            int required = ingredient.count();
            int have = required - left;
            List<ItemStack> items = ingredient.getAllValidItems();
            Component[] names = items.stream().map(ItemStack::m_41611_).toList().toArray(new Component[0]);
            String name = names[(int)((float)Util.m_137550_() / 1000.0f) % names.length].getString();
            text.add(new Text("> " + name.substring(1, name.length() - 1) + " ", Color.WHITE));
            text.add(new Text(have + "/" + required + "\n", have == required ? Color.GREEN : (have == 0 ? Color.RED : Color.YELLOW)));
            increment.addAndGet(name.length() / 32 + 1);
        });
        return increment.get();
    }

    public boolean m_6050_(double d, double e, double f) {
        this.currentScrollPosition += f * 4.0;
        return true;
    }

    protected void m_7286_(GuiGraphics gui, float f, int i, int j) {
        gui.m_280168_().m_85836_();
        gui.m_280168_().m_252880_((float)this.f_97735_, (float)this.f_97736_, 0.0f);
        gui.m_280218_(BACKGROUND, 0, 0, 0, 0, this.f_97726_, this.f_97727_);
        boolean buttonOpen = this.renderLogs(gui);
        this.renderButton(gui, buttonOpen, i, j);
        gui.m_280168_().m_85849_();
    }

    public boolean m_6375_(double x, double y, int i) {
        if (this.m_6774_(116, 18, 52, 52, x, y)) {
            ((ControlPanelMenu)this.m_6262_()).clickLaunch();
        }
        return super.m_6375_(x, y, i);
    }

    private static class Text {
        public String text;
        public Color color;

        Text(String text, Color color) {
            this.text = text;
            this.color = color;
        }

        public Style getStyle() {
            return switch (this.color.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 3 -> Style.f_131099_.m_178520_(0xFFFFFF);
                case 0 -> Style.f_131099_.m_178520_(65280);
                case 1 -> Style.f_131099_.m_178520_(0xFFFF00);
                case 2 -> Style.f_131099_.m_178520_(0xFF0000);
            };
        }
    }

    private static enum Color {
        GREEN,
        YELLOW,
        RED,
        WHITE;

    }
}

