/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.woukie.createmissiles.block.FrostSnowLayer;
import net.woukie.createmissiles.entity.AreaEntity;

public class FrozenAreaEntity
extends AreaEntity {
    public FrozenAreaEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public ParticleOptions getParticle() {
        return ParticleTypes.f_175821_;
    }

    @Override
    public void apply(BlockPos blockPos, ServerLevel level) {
        FrozenAreaEntity.applyFrost(blockPos, (Level)level);
    }

    public void flintAndSteeled() {
        this.m_146870_();
        for (int i = 0; i < 25; ++i) {
            Vec3 pos = this.m_20183_().m_252807_().m_82520_(this.f_19796_.m_188583_() * 3.0, -0.5, this.f_19796_.m_188583_() * 3.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, (double)this.f_19796_.m_188501_() * 0.2 + 0.1, 0.0);
        }
        this.m_9236_().m_247517_(null, BlockPos.m_274446_((Position)this.m_20182_()), SoundEvents.f_11942_, SoundSource.NEUTRAL);
        this.m_9236_().m_247517_(null, BlockPos.m_274446_((Position)this.m_20182_()), SoundEvents.f_11914_, SoundSource.NEUTRAL);
    }

    public static void applyFrost(BlockPos blockPos, Level level) {
        BlockState blockState = level.m_8055_(blockPos);
        BlockState blockStateBelow = level.m_8055_(blockPos.m_7495_());
        Block block = blockState.m_60734_();
        if (block.equals(Blocks.f_50125_)) {
            int currentLayer = (Integer)blockState.m_61143_((Property)FrostSnowLayer.LAYERS);
            BlockState frostSnowState = net.woukie.createmissiles.registry.Blocks.FROST_SNOW.getDefaultState();
            frostSnowState.m_61124_((Property)FrostSnowLayer.LAYERS, (Comparable)Integer.valueOf(currentLayer));
            level.m_7731_(blockPos, frostSnowState, 3);
        } else if (block.equals(net.woukie.createmissiles.registry.Blocks.FROST_SNOW.get())) {
            int currentLayer = (Integer)blockState.m_61143_((Property)FrostSnowLayer.LAYERS);
            if (currentLayer < 8) {
                BlockState newBlockState = (BlockState)blockState.m_61124_((Property)FrostSnowLayer.LAYERS, (Comparable)Integer.valueOf(currentLayer + 1));
                Block.m_49897_((BlockState)blockState, (BlockState)newBlockState, (LevelAccessor)level, (BlockPos)blockPos);
                level.m_46597_(blockPos, newBlockState);
            } else {
                level.m_7731_(blockPos, Blocks.f_152499_.m_49966_(), 3);
            }
        } else if (block.equals(Blocks.f_49990_)) {
            level.m_7731_(blockPos, Blocks.f_50126_.m_49966_(), 3);
        } else if (block.equals(Blocks.f_50126_)) {
            level.m_7731_(blockPos, Blocks.f_50354_.m_49966_(), 3);
        } else if (block.equals(Blocks.f_50354_)) {
            level.m_7731_(blockPos, Blocks.f_50568_.m_49966_(), 3);
        } else if (block.equals(Blocks.f_49991_) && blockState.m_60819_().m_76170_()) {
            level.m_7731_(blockPos, Blocks.f_50080_.m_49966_(), 3);
        } else if (block.equals(Blocks.f_50083_)) {
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 3);
        } else if (block.equals(Blocks.f_50016_) || blockState.m_60722_((Fluid)Fluids.f_76193_) && !block.equals(Blocks.f_152499_)) {
            boolean snowLayerSurvives;
            boolean belowUnsurviable = blockStateBelow.m_204336_(BlockTags.f_215833_);
            boolean belowSurviable = blockStateBelow.m_204336_(BlockTags.f_215833_);
            boolean belowIsFullSnow = blockStateBelow.m_60713_(Blocks.f_50125_) && (Integer)blockStateBelow.m_61143_((Property)SnowLayerBlock.f_56581_) == 8;
            boolean middleCase = Block.m_49918_((VoxelShape)blockStateBelow.m_60812_((BlockGetter)level, blockPos.m_7495_()), (Direction)Direction.UP) || belowIsFullSnow;
            boolean bl = snowLayerSurvives = !belowUnsurviable && (belowSurviable || middleCase);
            if (snowLayerSurvives) {
                if (!block.equals(Blocks.f_50016_)) {
                    level.m_46961_(blockPos, true);
                }
                level.m_7731_(blockPos, Blocks.f_50125_.m_49966_(), 3);
            }
        }
    }
}

