/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.entity.BallEntity;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import org.jetbrains.annotations.NotNull;

public class WitheredballEntity
extends BallEntity {
    private boolean spent;

    public WitheredballEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_6532_(@NotNull HitResult hitResult) {
        WitherSkeleton e;
        if (this.m_9236_().m_7654_() == null || this.spent) {
            return;
        }
        super.m_6532_(hitResult);
        BlockPos spawnPos = Util.locateNearestMatchingBlock(hitResult.m_82450_(), blockPos -> this.m_9236_().m_8055_(blockPos).m_60722_((Fluid)Fluids.f_76193_), 20);
        spawnPos = spawnPos == null ? BlockPos.m_274446_((Position)hitResult.m_82450_()) : spawnPos;
        this.m_9236_().m_247517_(null, spawnPos, SoundEvents.f_11913_, SoundSource.HOSTILE);
        if ((double)this.f_19796_.m_188501_() > 0.5 && (e = (WitherSkeleton)EntityType.f_20497_.m_262496_((ServerLevel)this.m_9236_(), spawnPos, MobSpawnType.MOB_SUMMONED)) != null) {
            e.m_21530_();
        }
        ExplosionHandler.get().createExplosion(new Explosion(this.m_9236_(), spawnPos.m_252807_(), 2.0));
        this.spreadRoses(6, 2, spawnPos, (ServerLevel)this.m_9236_());
        this.spent = true;
        this.m_146870_();
    }

    private void spreadRoses(int radius, int height, BlockPos position, ServerLevel level) {
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                double chance = 1.0 - Math.sqrt(x * x + z * z) / (double)radius;
                if (Math.random() > chance) continue;
                BlockPos selectedBlock = position.m_5484_(Direction.NORTH, x).m_5484_(Direction.EAST, z);
                for (int y = height; y > -height; --y) {
                    BlockPos testPos = selectedBlock.m_5484_(Direction.UP, y);
                    BlockState testState = level.m_8055_(testPos);
                    if (!level.m_46859_(testPos.m_7494_()) && !level.m_8055_(testPos.m_7494_()).m_60722_((Fluid)Fluids.f_76193_)) continue;
                    level.m_46961_(testPos.m_7494_(), false);
                    if (!testState.m_204336_(BlockTags.f_144274_) && !testState.m_60713_(Blocks.f_50093_) && !testState.m_60713_(Blocks.f_50134_) && !testState.m_60713_(Blocks.f_50135_) && !testState.m_60713_(Blocks.f_50136_)) continue;
                    if (Math.random() > 0.5) {
                        level.m_7731_(testPos, Blocks.f_50070_.m_49966_(), 3);
                        continue;
                    }
                    level.m_7731_(testPos, Blocks.f_50083_.m_49966_(), 3);
                }
            }
        }
    }

    public ItemStack m_7846_() {
        return Items.f_42679_.m_7968_();
    }
}

