/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity.drone;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.entity.drone.DroneHandler;
import net.woukie.createmissiles.entity.drone.MapUtils;
import net.woukie.createmissiles.inventory.DroneMenu;
import net.woukie.createmissiles.registry.EntityTypes;
import net.woukie.createmissiles.registry.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class Drone
extends FlyingMob {
    private final ContainerData dataAccess;
    BlockPos storedMapPos;
    BlockPos targetBlock;
    BlockPos originBlock;
    protected SimpleContainer mapContainer;

    public Drone(EntityType<? extends Drone> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DroneMoveControl(this, (Mob)this);
        this.f_21365_ = new EmptyLookControl(this, (Mob)this);
        this.mapContainer = new SimpleContainer(1);
        this.dataAccess = new ContainerData(){

            public int m_6413_(int i) {
                int[] uuidArray = 1.uuidToShortArray(Drone.this.m_20148_());
                return switch (i) {
                    case 0 -> uuidArray[0];
                    case 1 -> uuidArray[1];
                    case 2 -> uuidArray[2];
                    case 3 -> uuidArray[3];
                    case 4 -> uuidArray[4];
                    case 5 -> uuidArray[5];
                    case 6 -> uuidArray[6];
                    case 7 -> uuidArray[7];
                    case 8 -> Drone.this.m_20183_().m_123341_();
                    case 9 -> Drone.this.m_20183_().m_123343_();
                    case 10 -> {
                        if (Drone.this.targetBlock != null || Drone.this.originBlock != null) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 11 -> {
                        if (Drone.this.m_6095_().equals(EntityTypes.BASIC_DRONE.get())) {
                            yield 0;
                        }
                        yield 1;
                    }
                    default -> 0;
                };
            }

            public void m_8050_(int i, int j) {
            }

            public int m_6499_() {
                return 12;
            }

            private static int[] uuidToShortArray(UUID uUID) {
                long mostSig = uUID.getMostSignificantBits();
                long leastSig = uUID.getLeastSignificantBits();
                return new int[]{(int)(mostSig >> 48 & 0xFFFFL), (int)(mostSig >> 32 & 0xFFFFL), (int)(mostSig >> 16 & 0xFFFFL), (int)(mostSig & 0xFFFFL), (int)(leastSig >> 48 & 0xFFFFL), (int)(leastSig >> 32 & 0xFFFFL), (int)(leastSig >> 16 & 0xFFFFL), (int)(leastSig & 0xFFFFL)};
            }
        };
    }

    public void m_6043_() {
    }

    public boolean m_21532_() {
        return true;
    }

    public boolean m_6785_(double d) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            boolean i = true;
            float h = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float j = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * (1.3f + 0.21f * (float)i);
            float k = 0.135f * ((float)i * 0.2f + 1.0f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() + (double)h, this.m_20186_() + (double)k, this.m_20189_() + (double)j, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123757_, this.m_20185_() - (double)h, this.m_20186_() + (double)k, this.m_20189_() - (double)j, 0.0, 0.0, 0.0);
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("StoredMapPosX")) {
            this.storedMapPos = new BlockPos(compoundTag.m_128451_("StoredMapPosX"), compoundTag.m_128451_("StoredMapPosY"), compoundTag.m_128451_("StoredMapPosZ"));
        }
        if (compoundTag.m_128441_("TargetBlockX")) {
            this.targetBlock = new BlockPos(compoundTag.m_128451_("TargetBlockX"), compoundTag.m_128451_("TargetBlockY"), compoundTag.m_128451_("TargetBlockZ"));
        }
        if (compoundTag.m_128441_("OriginBlockX")) {
            this.originBlock = new BlockPos(compoundTag.m_128451_("OriginBlockX"), compoundTag.m_128451_("OriginBlockY"), compoundTag.m_128451_("OriginBlockZ"));
        }
        if (compoundTag.m_128441_("MapItem")) {
            this.mapContainer = new SimpleContainer(new ItemStack[]{ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("MapItem"))});
        }
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        if (this.storedMapPos != null) {
            compoundTag.m_128405_("StoredMapPosX", this.storedMapPos.m_123341_());
            compoundTag.m_128405_("StoredMapPosY", this.storedMapPos.m_123342_());
            compoundTag.m_128405_("StoredMapPosZ", this.storedMapPos.m_123343_());
        }
        if (this.targetBlock != null) {
            compoundTag.m_128405_("TargetBlockX", this.targetBlock.m_123341_());
            compoundTag.m_128405_("TargetBlockY", this.targetBlock.m_123342_());
            compoundTag.m_128405_("TargetBlockZ", this.targetBlock.m_123343_());
        }
        if (this.originBlock != null) {
            compoundTag.m_128405_("OriginBlockX", this.originBlock.m_123341_());
            compoundTag.m_128405_("OriginBlockY", this.originBlock.m_123342_());
            compoundTag.m_128405_("OriginBlockZ", this.originBlock.m_123343_());
        }
        compoundTag.m_128365_("MapItem", (Tag)this.mapContainer.m_8020_(0).m_41739_(new CompoundTag()));
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12231_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12229_;
    }

    public SoundSource m_5720_() {
        return SoundSource.PLAYERS;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12227_;
    }

    protected boolean m_8028_() {
        return false;
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions entityDimensions) {
        return entityDimensions.f_20378_ * 0.35f;
    }

    public boolean m_6097_() {
        return true;
    }

    public void m_8107_() {
        if (this.m_6084_() && this.m_21527_()) {
            this.m_20254_(8);
        }
        super.m_8107_();
    }

    public boolean m_142389_() {
        return true;
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        Entity entity = damageSource.m_7639_();
        if (!this.m_9236_().m_5776_() && entity != null && entity.m_6095_().equals(EntityType.f_20532_)) {
            this.m_9236_().m_247517_(null, this.m_20183_(), SoundEvents.f_12336_, SoundSource.NEUTRAL);
            this.popMap((ServerLevel)this.m_9236_());
            this.dropItem();
            this.m_146870_();
            return true;
        }
        return super.m_6469_(damageSource, f);
    }

    public void m_6667_(DamageSource damageSource) {
        if (!this.m_9236_().f_46443_) {
            this.popMap((ServerLevel)this.m_9236_());
            DroneHandler.get().stopTrackingDrone((ServerLevel)this.m_9236_(), this.m_20148_());
        }
        super.m_6667_(damageSource);
    }

    public void popMap(ServerLevel level) {
        if (this.storedMapPos != null) {
            MapUtils.spawnMapAt(level, this.m_20182_().m_82520_(0.0, 0.5, 0.0), this.storedMapPos);
            level.m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, SoundEvents.f_12493_, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.storedMapPos = null;
        } else {
            DefaultDispenseItemBehavior.m_123378_((Level)this.m_9236_(), (ItemStack)this.mapContainer.m_8020_(0), (int)1, (Direction)Direction.UP, (Position)this.m_20182_());
        }
        this.mapContainer.m_6211_();
    }

    protected void dropItem() {
        DefaultDispenseItemBehavior.m_123378_((Level)this.m_9236_(), (ItemStack)new ItemStack((ItemLike)Items.DRONE_BOX_ITEM.get()), (int)1, (Direction)Direction.UP, (Position)this.m_20182_());
    }

    public boolean m_6087_() {
        return true;
    }

    @Nullable
    public ItemStack m_142340_() {
        return ((Item)Items.DRONE_BOX_ITEM.get()).m_7968_();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (this.storedMapPos != null) {
            this.popMap((ServerLevel)this.m_9236_());
            return InteractionResult.SUCCESS;
        }
        if (this.targetBlock != null || this.originBlock != null) {
            return InteractionResult.FAIL;
        }
        if (!this.m_9236_().f_46443_) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((ix, inventory, playerx) -> new DroneMenu(ix, inventory, this.dataAccess, (Container)this.mapContainer), this.m_5446_()));
        }
        return InteractionResult.SUCCESS;
    }

    public void startMission(BlockPos destination) {
        if (this.mapContainer.m_8020_(0).m_41619_()) {
            return;
        }
        this.m_9236_().m_6263_(null, this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, (SoundEvent)SoundEvents.f_12211_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.0f);
        this.targetBlock = destination;
        this.originBlock = this.m_20183_();
        DroneHandler.get().trackDrone(this);
    }

    protected BodyRotationControl m_7560_() {
        return new DroneBodyRotationControl(this, (Mob)this);
    }

    public class DroneMoveControl
    extends MoveControl {
        private boolean hasOigin;
        private boolean hasTarget;

        public DroneMoveControl(Drone drone, Mob mob) {
            super(mob);
        }

        public void m_8126_() {
            Vector2i originPos;
            Vector2i targetPos;
            if (Drone.this.f_19862_) {
                Drone.this.m_146922_(Drone.this.m_146908_() + 180.0f);
            }
            this.updateTargetStatus();
            this.tickTravelOrWait();
            Vector2i currentPos = new Vector2i(Drone.this.m_20183_().m_123341_(), Drone.this.m_20183_().m_123343_());
            if (this.hasTarget && (targetPos = new Vector2i(Drone.this.targetBlock.m_123341_(), Drone.this.targetBlock.m_123343_())).distance((Vector2ic)currentPos) < 25.0) {
                Drone.this.storedMapPos = Drone.this.targetBlock;
                Drone.this.targetBlock = null;
            }
            if (!this.hasTarget && this.hasOigin && (originPos = new Vector2i(Drone.this.originBlock.m_123341_(), Drone.this.originBlock.m_123343_())).distance((Vector2ic)currentPos) < 3.0) {
                DroneHandler.get().stopTrackingDrone((ServerLevel)Drone.this.m_9236_(), Drone.this.f_19820_);
                Drone.this.originBlock = null;
            }
        }

        private void tickTravelOrWait() {
            if (this.hasTarget) {
                this.tickTravel(Drone.this.targetBlock);
            } else if (this.hasOigin) {
                this.tickTravel(Drone.this.originBlock);
            } else {
                this.tickWait();
            }
            this.updateTargetStatus();
        }

        private void updateTargetStatus() {
            this.hasOigin = Drone.this.originBlock != null;
            boolean bl = this.hasTarget = Drone.this.targetBlock != null;
            if (this.hasTarget && !this.hasOigin) {
                Drone.this.originBlock = Drone.this.targetBlock;
            }
        }

        private void tickWait() {
            if (!Drone.this.m_20096_()) {
                Drone.this.m_20256_(Drone.this.m_20184_().m_82520_(0.0, -0.24, 0.0));
                Drone.this.m_146926_(Mth.m_14148_((float)Drone.this.m_146909_(), (float)70.0f, (float)4.0f));
            } else {
                Drone.this.m_146926_(0.0f);
            }
        }

        private void tickTravel(BlockPos destination) {
            double dZ;
            double dX = (double)destination.m_123341_() - Drone.this.m_20185_();
            double distance = Math.sqrt(dX * dX + (dZ = (double)destination.m_123343_() - Drone.this.m_20189_()) * dZ);
            if (Math.abs(distance) > (double)1.0E-5f) {
                float yTurnSpeed = 1.0f;
                if (distance < 30.0) {
                    yTurnSpeed = 10.0f;
                }
                float angle = (float)Mth.m_14136_((double)dZ, (double)dX);
                float currentYRot = Mth.m_14177_((float)(Drone.this.m_146908_() + 90.0f));
                float targetYRot = Mth.m_14177_((float)(angle * 57.295776f));
                Drone.this.m_146922_(Mth.m_14148_((float)currentYRot, (float)targetYRot, (float)yTurnSpeed) - 90.0f);
                Drone.this.f_20883_ = Drone.this.m_146908_();
                float targetXRot = 0.0f;
                for (int i = 0; i < 50; ++i) {
                    if (!Drone.this.m_9236_().m_46859_(Drone.this.m_20183_().m_6625_(i))) {
                        targetXRot = -70.0f;
                        break;
                    }
                    if (Drone.this.m_9236_().m_46859_(Drone.this.m_20183_().m_6630_(i))) continue;
                    targetXRot = 70.0f;
                    break;
                }
                Drone.this.m_146926_(Mth.m_14148_((float)Drone.this.m_146909_(), (float)targetXRot, (float)1.0f));
                float pitch = Drone.this.m_146909_() * (float)Math.PI / 180.0f;
                float yaw = Drone.this.m_146908_() * (float)Math.PI / 180.0f;
                double x = -Math.sin(yaw) * Math.cos(pitch);
                double y = -Math.sin(pitch);
                double z = Math.cos(yaw) * Math.cos(pitch);
                Vec3 directionVector = new Vec3(x, y, z);
                Vec3 vec3 = Drone.this.m_20184_();
                Drone.this.m_20256_(vec3.m_82549_(directionVector.m_82546_(vec3).m_82490_(0.2)));
            }
        }
    }

    public static class EmptyLookControl
    extends LookControl {
        public EmptyLookControl(Drone drone, Mob mob) {
            super(mob);
        }

        public void m_8128_() {
        }
    }

    class DroneBodyRotationControl
    extends BodyRotationControl {
        public DroneBodyRotationControl(Drone drone, Mob mob) {
            super(mob);
        }

        public void m_8121_() {
            Drone.this.f_20885_ = Drone.this.f_20883_;
            Drone.this.f_20883_ = Drone.this.m_146908_();
        }
    }
}

