/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity.drone;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;

public class MapUtils {
    private static final Set<SpawnMap> spawnMaps = new HashSet<SpawnMap>();

    public static void spawnMapAt(ServerLevel level, Vec3 position, BlockPos target) {
        spawnMaps.add(new SpawnMap(level, position, target));
    }

    public static void serverTick() {
        spawnMaps.removeIf(spawnMap -> {
            BlockPos target = spawnMap.target;
            ServerLevel level = spawnMap.level;
            List<ChunkPos> affectedChunks = MapUtils.getChunksForTarget(target);
            for (ChunkPos pos : affectedChunks) {
                if (level.m_46749_(new BlockPos((pos.f_45578_ << 4) + 8, 0, (pos.f_45579_ << 4) + 8))) continue;
                level.m_8602_(pos.f_45578_, pos.f_45579_, true);
                return false;
            }
            ItemStack stack = MapUtils.createAndFillMap((Level)level, target.m_123341_(), target.m_123343_(), 1);
            DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)stack, (int)1, (Direction)Direction.UP, (Position)spawnMap.position);
            level.m_6263_(null, spawnMap.position.f_82479_, spawnMap.position.f_82480_, spawnMap.position.f_82481_, (SoundEvent)SoundEvents.f_12211_.m_203334_(), SoundSource.PLAYERS, 1.0f, 1.0f);
            affectedChunks.forEach(chunkPos -> level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false));
            return true;
        });
    }

    public static List<ChunkPos> getChunksForTarget(BlockPos target) {
        ArrayList<ChunkPos> chunks = new ArrayList<ChunkPos>();
        int radius = 128;
        int minChunkX = target.m_123341_() - radius >> 4;
        int maxChunkX = target.m_123341_() + radius >> 4;
        int minChunkZ = target.m_123343_() - radius >> 4;
        int maxChunkZ = target.m_123343_() + radius >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int closestX = Math.max(chunkX << 4, Math.min(target.m_123341_(), (chunkX << 4) + 15));
                int closestZ = Math.max(chunkZ << 4, Math.min(target.m_123343_(), (chunkZ << 4) + 15));
                double distanceSquared = Math.pow(target.m_123341_() - closestX, 2.0) + Math.pow(target.m_123343_() - closestZ, 2.0);
                if (!(distanceSquared <= (double)(radius * radius))) continue;
                chunks.add(new ChunkPos(chunkX, chunkZ));
            }
        }
        return chunks;
    }

    public static ItemStack createAndFillMap(Level level, int centerX, int centerZ, int scale) {
        ItemStack map = MapItem.m_42886_((Level)level, (int)centerX, (int)centerZ, (byte)((byte)scale), (boolean)true, (boolean)true);
        MapItemSavedData mapData = MapItem.m_42853_((ItemStack)map, (Level)level);
        if (mapData == null) {
            return map;
        }
        MapUtils.fillMapData(level, centerX, centerZ, Objects.requireNonNull(MapItem.m_42853_((ItemStack)map, (Level)level)));
        return map;
    }

    private static BlockState getCorrectStateForFluidBlock(Level level, BlockState blockState, BlockPos blockPos) {
        FluidState fluidState = blockState.m_60819_();
        return !fluidState.m_76178_() && !blockState.m_60783_((BlockGetter)level, blockPos, Direction.UP) ? fluidState.m_76188_() : blockState;
    }

    public static void fillMapData(Level level, double X, double Z, MapItemSavedData mapItemSavedData) {
        if (level.m_46472_() == mapItemSavedData.f_77887_) {
            int i = 1 << mapItemSavedData.f_77890_;
            int j = mapItemSavedData.f_256718_;
            int k = mapItemSavedData.f_256789_;
            int l = Mth.m_14107_((double)(X - (double)j)) / i + 64;
            int m = Mth.m_14107_((double)(Z - (double)k)) / i + 64;
            int n = 128 / i;
            if (level.m_6042_().f_63856_()) {
                n /= 2;
            }
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos mutableBlockPos2 = new BlockPos.MutableBlockPos();
            boolean bl = false;
            for (int o = l - n + 1; o < l + n; ++o) {
                bl = false;
                double d = 0.0;
                for (int p = m - n - 1; p < m + n; ++p) {
                    double f;
                    if (o < 0 || p < -1 || o >= 128 || p >= 128) continue;
                    int q = Mth.m_144944_((int)(o - l)) + Mth.m_144944_((int)(p - m));
                    boolean bl2 = q > (n - 2) * (n - 2);
                    int r = (j / i + o - 64) * i;
                    int s = (k / i + p - 64) * i;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    LevelChunk levelChunk = level.m_6325_(SectionPos.m_123171_((int)r), SectionPos.m_123171_((int)s));
                    if (levelChunk.m_6430_()) continue;
                    int t = 0;
                    double e = 0.0;
                    if (level.m_6042_().f_63856_()) {
                        u = r + s * 231871;
                        if (((u = u * u * 31287121 + u * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)Blocks.f_50493_.m_49966_().m_284242_((BlockGetter)level, BlockPos.f_121853_), 10);
                        } else {
                            multiset.add((Object)Blocks.f_50069_.m_49966_().m_284242_((BlockGetter)level, BlockPos.f_121853_), 100);
                        }
                        e = 100.0;
                    } else {
                        for (u = 0; u < i; ++u) {
                            for (int v = 0; v < i; ++v) {
                                BlockState blockState;
                                mutableBlockPos.m_122178_(r + u, 0, s + v);
                                int w = levelChunk.m_5885_(Heightmap.Types.WORLD_SURFACE, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_()) + 1;
                                if (w <= level.m_141937_() + 1) {
                                    blockState = Blocks.f_50752_.m_49966_();
                                } else {
                                    do {
                                        mutableBlockPos.m_142448_(--w);
                                    } while ((blockState = levelChunk.m_8055_((BlockPos)mutableBlockPos)).m_284242_((BlockGetter)level, (BlockPos)mutableBlockPos) == MapColor.f_283808_ && w > level.m_141937_());
                                    if (w > level.m_141937_() && !blockState.m_60819_().m_76178_()) {
                                        BlockState blockState2;
                                        int x = w - 1;
                                        mutableBlockPos2.m_122190_((Vec3i)mutableBlockPos);
                                        do {
                                            mutableBlockPos2.m_142448_(x--);
                                            blockState2 = levelChunk.m_8055_((BlockPos)mutableBlockPos2);
                                            ++t;
                                        } while (x > level.m_141937_() && !blockState2.m_60819_().m_76178_());
                                        blockState = MapUtils.getCorrectStateForFluidBlock(level, blockState, (BlockPos)mutableBlockPos);
                                    }
                                }
                                mapItemSavedData.m_77930_((BlockGetter)level, mutableBlockPos.m_123341_(), mutableBlockPos.m_123343_());
                                e += (double)w / (double)(i * i);
                                multiset.add((Object)blockState.m_284242_((BlockGetter)level, (BlockPos)mutableBlockPos));
                            }
                        }
                    }
                    MapColor mapColor = (MapColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)MapColor.f_283808_);
                    MapColor.Brightness brightness = mapColor == MapColor.f_283864_ ? ((f = (double)(t /= i * i) * 0.1 + (double)(o + p & 1) * 0.2) < 0.5 ? MapColor.Brightness.HIGH : (f > 0.9 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL)) : ((f = (e - d) * 4.0 / (double)(i + 4) + ((double)(o + p & 1) - 0.5) * 0.4) > 0.6 ? MapColor.Brightness.HIGH : (f < -0.6 ? MapColor.Brightness.LOW : MapColor.Brightness.NORMAL));
                    d = e;
                    if (p < 0 || q >= n * n || bl2 && (o + p & 1) == 0) continue;
                    bl |= mapItemSavedData.m_164792_(o, p, mapColor.m_284523_(brightness));
                }
            }
        }
    }

    static class SpawnMap {
        private ServerLevel level;
        private Vec3 position;
        private BlockPos target;

        public SpawnMap(ServerLevel level, Vec3 position, BlockPos target) {
            this.level = level;
            this.position = position;
            this.target = target;
        }
    }
}

