/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.jei;

import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.woukie.createmissiles.item.assembly.AssemblyItem;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.registry.Items;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("createmissiles", "main");
    }

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registration) {
        super.registerItemSubtypes(registration);
        registration.useNbtForSubtypes(new Item[]{(Item)Items.WARHEAD_ASSEMBLY.get(), (Item)Items.CHASSIS_ASSEMBLY.get(), (Item)Items.THRUSTER_ASSEMBLY.get()});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        super.registerRecipes(registration);
        PartTypes.getMissilePartTypes().forEach(partType -> {
            ResourceLocation location = partType.getResourceLocation();
            ItemLike item = (ItemLike)Items.WARHEAD_ASSEMBLY.get();
            if (partType instanceof ThrusterType) {
                item = (ItemLike)Items.THRUSTER_ASSEMBLY.get();
            } else if (partType instanceof ChassisType) {
                item = (ItemLike)Items.CHASSIS_ASSEMBLY.get();
            }
            ItemStack stack = AssemblyItem.createWith(location, item);
            MutableComponent description = Component.m_237119_();
            partType.registerJEIStats(description);
            description.m_130946_("\n");
            description.m_7220_((Component)Component.m_237115_((String)("description.jei." + location.m_135827_() + "." + location.m_135815_())));
            registration.addItemStackInfo(stack, new Component[]{description});
        });
        registration.addItemStackInfo(((Item)Items.DRAGON_EGG_SHELL.get()).m_7968_(), new Component[]{Component.m_237115_((String)"description.jei.createmissiles.item.dragon_egg_shell")});
        registration.addItemStackInfo(((Item)Items.EXCAVATOR_UPGRADE_CORE.get()).m_7968_(), new Component[]{Component.m_237115_((String)"description.jei.createmissiles.generic.upgrade_core")});
        registration.addItemStackInfo(((Item)Items.FIREWORK_UPGRADE_CORE.get()).m_7968_(), new Component[]{Component.m_237115_((String)"description.jei.createmissiles.generic.upgrade_core")});
        registration.addItemStackInfo(((Item)Items.FLAMING_UPGRADE_CORE.get()).m_7968_(), new Component[]{Component.m_237115_((String)"description.jei.createmissiles.generic.upgrade_core")});
        registration.addItemStackInfo(((Item)Items.FROST_UPGRADE_CORE.get()).m_7968_(), new Component[]{Component.m_237115_((String)"description.jei.createmissiles.generic.upgrade_core")});
    }
}

