/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.asyncexplosionhandler;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.ExplosionResistanceOverrides;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplodingAreaWorker;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Explosion {
    public static final int EXPLOSION_CHUNKS = 2;
    private final BlockPos originBlockPosition;
    private final double power;
    private final double decay;
    private final ResourceKey<Level> levelKey;
    private final Level level;
    private ListTag workerData;
    private final List<ExplodingAreaWorker> workers = new ArrayList<ExplodingAreaWorker>();
    private final int maxRadius;
    private final ConcurrentHashMap<BlockPos, Float> hardnessMap;
    private boolean complete = false;
    private boolean endEarly = false;

    public Explosion(Level level, Vec3 originPosition, double power) {
        this(level, originPosition, power, 0.3);
    }

    public Explosion(Level level, Vec3 originPosition, double power, double decay) {
        this.levelKey = level.m_46472_();
        this.level = level;
        this.originBlockPosition = BlockPos.m_274446_((Position)originPosition);
        this.power = power;
        this.decay = decay;
        this.maxRadius = (int)((this.power - this.decay - 0.315) / 0.315);
        this.hardnessMap = new ConcurrentHashMap((int)(4.1887902047863905 * (double)this.maxRadius * (double)this.maxRadius * (double)this.maxRadius), 0.75f, 8);
    }

    public void damageEntities() {
        Vec3 c1 = this.originBlockPosition.m_252807_().m_82546_(new Vec3((double)this.maxRadius, (double)this.maxRadius, (double)this.maxRadius));
        Vec3 c2 = this.originBlockPosition.m_252807_().m_82549_(new Vec3((double)this.maxRadius, (double)this.maxRadius, (double)this.maxRadius));
        List entities = this.level.m_45933_(null, new AABB(c1.f_82479_, c1.f_82480_, c1.f_82481_, c2.f_82479_, c2.f_82480_, c2.f_82481_));
        entities.forEach(entity -> {
            if (!(entity instanceof LivingEntity)) {
                return;
            }
            if (entity.m_6128_()) {
                return;
            }
            double proximity = Math.sqrt(entity.m_20238_(this.originBlockPosition.m_252807_()));
            double proportionToEdge = proximity / (double)this.maxRadius;
            double proportionToCenter = 1.0 - proportionToEdge;
            if (!(proportionToEdge <= 1.0)) {
                return;
            }
            AtomicReference<Float> totalHardness = new AtomicReference<Float>(Float.valueOf(0.0f));
            AtomicReference<Integer> passedCount = new AtomicReference<Integer>(0);
            Vector3d origin = new Vector3d((double)this.originBlockPosition.m_123341_(), (double)this.originBlockPosition.m_123342_(), (double)this.originBlockPosition.m_123343_()).add(0.5, 0.5, 0.5);
            Vector3d target = new Vector3d(entity.m_20182_().f_82479_, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_);
            double startPower = this.power;
            Util.traverseSupercover(origin, target, traversedPos -> {
                double distance = traversedPos.distance((Vector3dc)origin);
                if (distance > (double)this.maxRadius) {
                    return true;
                }
                BlockPos traversedBlockPos = BlockPos.m_274561_((double)traversedPos.x, (double)traversedPos.y, (double)traversedPos.z);
                float hardness = ExplosionResistanceOverrides.getResistance(this.level.m_8055_(traversedBlockPos).m_60734_());
                totalHardness.updateAndGet(current -> Float.valueOf(current.floatValue() + hardness));
                passedCount.updateAndGet(a -> {
                    a = a + 1;
                    return a;
                });
                int passedBlocks = Math.max((Integer)passedCount.get(), 1);
                double averageHardness = (double)((Float)totalHardness.get()).floatValue() / (double)passedBlocks;
                double powerLeft = startPower - (0.3 * (averageHardness / 5.0) + 0.315 + this.decay) * distance;
                return powerLeft <= 0.0;
            });
            double distance = target.distance((Vector3dc)origin);
            int passedBlocks = Math.max(passedCount.get(), 1);
            double averageHardness = (double)totalHardness.get().floatValue() / (double)passedBlocks;
            double powerLeft = startPower - (0.3 * (averageHardness / 5.0) + 0.315 + this.decay) * distance;
            if (powerLeft <= 0.0) {
                return;
            }
            double exposure = powerLeft / this.power;
            exposure = exposure >= 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * exposure);
            double impact = proportionToCenter * exposure;
            entity.m_6469_(this.level.m_269111_().m_269036_(null, null), (float)((int)(impact * impact * impact * 7.0 * this.power + 1.0)));
            exposure = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)entity), (double)exposure);
            entity.m_20256_(entity.m_20184_().m_82549_(entity.m_20182_().m_82546_(this.originBlockPosition.m_252807_()).m_82541_().m_82490_(exposure)));
        });
    }

    public void startCrunching() {
        int chunkSize = this.maxRadius * 2 / 2;
        for (int x = 0; x < 2; ++x) {
            for (int y = 0; y < 2; ++y) {
                for (int z = 0; z < 2; ++z) {
                    BlockPos start = this.originBlockPosition.m_7918_(-this.maxRadius + chunkSize * x, -this.maxRadius + chunkSize * y, -this.maxRadius + chunkSize * z);
                    BlockPos end = start.m_7918_(chunkSize, chunkSize, chunkSize);
                    ExplodingAreaWorker worker = new ExplodingAreaWorker(start, end, this.originBlockPosition, this.level, this.power, this.hardnessMap, this.decay);
                    int i = x * 4 + y * 2 + z;
                    if (this.workerData != null && this.workerData.size() > i) {
                        worker.load((CompoundTag)this.workerData.get(i));
                    }
                    Thread thread = new Thread(worker);
                    this.workers.add(worker);
                    thread.start();
                }
            }
        }
        CreateMissiles.LOGGER.info("Started explosion workers at {}", (Object)this.originBlockPosition.m_123344_());
        this.workerData = null;
    }

    public void serverTick(MinecraftServer server) {
        boolean keepDestroying = true;
        this.complete = true;
        while (keepDestroying) {
            keepDestroying = false;
            for (ExplodingAreaWorker worker : this.workers) {
                if (worker.isComplete()) continue;
                this.complete = false;
                if (this.endEarly) {
                    return;
                }
                if (!worker.processBlock(this.level)) continue;
                keepDestroying = true;
            }
        }
    }

    public boolean isComplete() {
        return this.complete;
    }

    public CompoundTag save() {
        CompoundTag hardnessData = new CompoundTag();
        hardnessData.m_128428_("Keys", this.hardnessMap.keySet().stream().map(BlockPos::m_121878_).toList());
        hardnessData.m_177853_("Values", this.hardnessMap.values().stream().map(Float::byteValue).toList());
        ListTag workerList = new ListTag();
        workerList.addAll(this.workers.stream().map(ExplodingAreaWorker::save).toList());
        CompoundTag data = new CompoundTag();
        data.m_128359_("Level", this.levelKey.m_135782_().m_135815_());
        data.m_128405_("PositionX", this.originBlockPosition.m_123341_());
        data.m_128405_("PositionY", this.originBlockPosition.m_123342_());
        data.m_128405_("PositionZ", this.originBlockPosition.m_123343_());
        data.m_128365_("Workers", (Tag)workerList);
        data.m_128347_("Power", this.power);
        data.m_128365_("Hardness", (Tag)hardnessData);
        return data;
    }

    public static Explosion load(CompoundTag data, MinecraftServer server) {
        ServerLevel level = server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(data.m_128461_("Level"))));
        Vec3 origin = new Vec3((double)data.m_128451_("PositionX"), (double)data.m_128451_("PositionY"), (double)data.m_128451_("PositionZ"));
        if (level == null) {
            return null;
        }
        Explosion explosion = new Explosion((Level)level, origin, data.m_128459_("Power"));
        CompoundTag hardnessData = data.m_128469_("Hardness");
        long[] hardnessKeys = hardnessData.m_128467_("Keys");
        byte[] hardnessValues = hardnessData.m_128463_("Values");
        for (int i = 0; i < hardnessKeys.length; ++i) {
            explosion.hardnessMap.put(BlockPos.m_122022_((long)hardnessKeys[i]), Float.valueOf(hardnessValues[i]));
        }
        explosion.workerData = data.m_128437_("Workers", 10);
        return explosion;
    }

    public void stopCrunching() {
        this.endEarly = true;
        this.workers.forEach(ExplodingAreaWorker::endEarly);
    }

    public BlockPos getOrigin() {
        return this.originBlockPosition;
    }

    public Level getLevel() {
        return this.level;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public double getPower() {
        return this.power;
    }
}

