/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.MissilePartType;
import org.joml.Vector3d;

public abstract class WarheadType
extends MissilePartType {
    @Override
    public int getStartSlot() {
        return 0;
    }

    @Override
    public int getEndSlot() {
        return 32;
    }

    @Override
    public void onTick(Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        Vec3 hitPosition = this.hitPosition(trajectory, server);
        if (level == null) {
            return;
        }
        if (trajectory.getTick() > 20 && hitPosition != null || trajectory.getPosition().y < (double)level.m_141937_()) {
            this.onDetonate(hitPosition, trajectory, server);
            trajectory.setSpent(true);
        }
    }

    protected Vec3 hitPosition(Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return null;
        }
        Vector3d from = trajectory.getLastPosition();
        Vector3d to = trajectory.getPosition();
        AtomicReference solidLocation = new AtomicReference();
        Util.traverseSupercover(from, to, blockPos -> {
            if (!level.m_46859_(new BlockPos((int)blockPos.x, (int)blockPos.y, (int)blockPos.z))) {
                solidLocation.set(new Vec3(blockPos.x, blockPos.y, blockPos.z));
                return true;
            }
            return false;
        });
        return (Vec3)solidLocation.get();
    }
}

