/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.block.AnnoyingJukeboxBlock;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.Blocks;

public class AnnoyingWarhead
extends WarheadType {
    @Override
    public float getMass() {
        return 7.5f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        BlockPos emptyBlock = Util.locateAir(hitPosition.m_82520_(0.0, 1.0, 0.0), level, 100);
        if (emptyBlock != null) {
            level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
            level.m_7731_(emptyBlock, ((AnnoyingJukeboxBlock)((Object)Blocks.ANNOYING_JUKEBOX.get())).m_49966_(), 3);
        } else {
            DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)((AnnoyingJukeboxBlock)((Object)Blocks.ANNOYING_JUKEBOX.get())).m_5456_().m_7968_(), (int)1, (Direction)Direction.UP, (Position)hitPosition.m_82520_(0.0, 1.0, 0.0));
        }
        level.m_247517_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.NEUTRAL);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_, 1, 0.0, 0.5, 0.5, 0.5);
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "annoying_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.annoying_warhead");
    }
}

