/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.Util;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.Items;

public class DirectHitWarhead
extends WarheadType {
    @Override
    public float getMass() {
        return 28.5f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        BlockPos dragonEgg = Util.locateNearestMatchingBlock(hitPosition, blockPos -> level.m_8055_(blockPos).m_60713_(Blocks.f_50260_), 20);
        if (dragonEgg != null) {
            level.m_46961_(dragonEgg, false);
            DefaultDispenseItemBehavior.m_123378_((Level)level, (ItemStack)new ItemStack((ItemLike)Items.DRAGON_EGG_SHELL.get(), 3), (int)1, (Direction)Direction.UP, (Position)dragonEgg.m_252807_());
        }
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
        level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11669_, SoundSource.HOSTILE, 10.0f, 1.0f);
        ExplosionHandler.get().createExplosion(new Explosion((Level)level, hitPosition, 150.0, 30.0));
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "direct_hit_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.direct_hit_warhead");
    }
}

