/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.Items;

public class TeleportationWarhead
extends WarheadType {
    @Override
    public CompoundTag saveTo(Container container, CompoundTag data) {
        for (int i = this.getStartSlot(); i < this.getEndSlot(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (!stack.m_150930_((Item)Items.BOUND_ENDER_PEARL.get())) continue;
            CompoundTag tag = stack.m_41783_();
            if (tag != null && tag.m_128403_("PlayerUUID")) {
                data.m_128362_("PlayerUUID", tag.m_128342_("PlayerUUID"));
            }
            return data;
        }
        return data;
    }

    @Override
    public float getMass() {
        return 15.0f;
    }

    @Override
    public void onDetonate(Vec3 hitPosition, Trajectory trajectory, MinecraftServer server) {
        ServerPlayer serverPlayer;
        ServerLevel level = server.m_129880_(trajectory.getLevelKey());
        if (level == null) {
            return;
        }
        Vec3 impactPos = hitPosition.m_82520_(0.0, 1.0, 0.0);
        CompoundTag data = trajectory.getWarheadData();
        if (data != null && !data.m_128456_() && (serverPlayer = (ServerPlayer)level.m_46003_(data.m_128342_("PlayerUUID"))) != null && serverPlayer.f_8906_.m_6198_()) {
            if (serverPlayer.m_20159_()) {
                serverPlayer.m_142098_(impactPos.m_7096_(), impactPos.m_7098_(), impactPos.m_7094_());
            } else {
                serverPlayer.m_6021_(impactPos.m_7096_(), impactPos.m_7098_(), impactPos.m_7094_());
            }
            level.m_5594_(null, BlockPos.m_274446_((Position)hitPosition), SoundEvents.f_11913_, SoundSource.HOSTILE, 10.0f, 1.0f);
            level.m_6263_(null, impactPos.m_7096_(), impactPos.m_7098_(), impactPos.m_7094_(), SoundEvents.f_11852_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            serverPlayer.m_183634_();
            serverPlayer.m_6469_(serverPlayer.m_269291_().m_268989_(), 5.0f);
        }
    }

    @Override
    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("createmissiles", "teleportation_warhead");
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)"warheads.createmissiles.teleportation_warhead");
    }
}

