/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.trajectories;

import java.util.ArrayList;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaterniond;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import oshi.util.tuples.Pair;

public class BallisticTrajectory
extends Trajectory {
    public final Vector3d gravity = new Vector3d(0.0, -9.81, 0.0);
    public final int turnTicks = 10;
    public final double tickSpeed = 20.0;
    protected Vector3d velocity;
    protected Vector3d rotation;
    private double thrust;
    private double thrustDurationPercent;
    private double mass;
    private Vector3d launchDirection;
    protected Double upperLaunchAngle;
    protected Double upperDistanceToTarget;
    protected Double lowerLaunchAngle;
    protected Double lowerDistanceToTarget;
    protected boolean stopRefiningAngle = false;

    @Override
    public void tick() {
        super.tick();
        double tickLength = 0.05;
        double elapsedTime = (double)this.tick * tickLength;
        if (this.launchDirection == null) {
            this.launchDirection = new Vector3d(0.0, 0.0, 0.0);
        }
        double currentFlightAngle = Math.atan2(this.velocity.y, Math.sqrt(this.velocity.x * this.velocity.x + this.velocity.z * this.velocity.z));
        Vector3d acceleration = this.getAcceleration(currentFlightAngle, elapsedTime);
        this.velocity.add((Vector3dc)acceleration.mul(tickLength));
        this.lastPosition = new Vector3d((Vector3dc)this.position);
        this.position.add(this.velocity.x * tickLength, this.velocity.y * tickLength, this.velocity.z * tickLength);
        Vector3d direction = new Vector3d(this.velocity.x, this.velocity.y, this.velocity.z);
        direction.normalize();
        Vector3d forward = new Vector3d(0.0, 1.0, 0.0);
        Quaterniond q = new Quaterniond().rotateTo((Vector3dc)forward, (Vector3dc)direction);
        Vector3d euler = q.getEulerAnglesZYX(new Vector3d());
        this.rotation.set(euler.x, euler.y, euler.z);
    }

    private Vector3d getAcceleration(double currentFlightAngle, double elapsedTime) {
        double approximateForceDueToAirResistance = 0.03 * (this.velocity.x * this.velocity.x + this.velocity.y * this.velocity.y + this.velocity.z * this.velocity.z);
        double horizontalForceDueToAirResistance = Math.cos(currentFlightAngle) * approximateForceDueToAirResistance;
        double verticalForceDueToAirResistance = (double)(-this.getSign(this.velocity.y)) * Math.sin(currentFlightAngle) * approximateForceDueToAirResistance;
        double launchAngle = (this.upperLaunchAngle + this.lowerLaunchAngle) / 2.0;
        double angle = Mth.m_14139_((double)((double)this.tick / 10.0), (double)90.0, (double)launchAngle);
        double forceHorizontal = this.thrust * Math.cos(Math.toRadians(angle)) / this.mass;
        if (elapsedTime >= this.thrustDurationPercent * (double)this.chassisType.getFuelCapacity() / (double)this.thrusterType.getBurnRate()) {
            return new Vector3d((double)(-this.getSign(this.velocity.x)) * horizontalForceDueToAirResistance * this.launchDirection.x / this.mass, verticalForceDueToAirResistance / this.mass + this.gravity.y, (double)(-this.getSign(this.velocity.z)) * horizontalForceDueToAirResistance * this.launchDirection.z / this.mass);
        }
        return new Vector3d((double)(-this.getSign(this.velocity.x)) * horizontalForceDueToAirResistance * this.launchDirection.x / this.mass + this.launchDirection.x * forceHorizontal, verticalForceDueToAirResistance / this.mass + this.thrust * Math.sin(Math.toRadians(angle)) / this.mass + this.gravity.y, (double)(-this.getSign(this.velocity.z)) * horizontalForceDueToAirResistance * this.launchDirection.z / this.mass + this.launchDirection.z * forceHorizontal);
    }

    public BallisticTrajectory(@Nullable Level level, Vector3d start, Vector3d target, WarheadType warheadType, ChassisType chassisType, ThrusterType thrusterType, @Nullable Container container, double thrustDurationPercent) {
        super((ResourceKey<Level>)(level != null ? level.m_46472_() : null), start, target, warheadType, chassisType, thrusterType, container);
        this.velocity = new Vector3d(0.0, 0.0, 0.0);
        this.rotation = new Vector3d(0.0, 0.0, 0.0);
        this.thrust = thrusterType.getThrust();
        this.thrustDurationPercent = thrustDurationPercent;
        this.mass = thrusterType.getMass() + chassisType.getMass() + warheadType.getMass();
        this.launchDirection = new Vector3d(target.x - start.x, 0.0, target.z - start.z).normalize();
        this.upperLaunchAngle = 90.0;
        this.lowerLaunchAngle = 0.0;
    }

    public BallisticTrajectory(Vector3d start, Vector3d target, WarheadType warheadType, ChassisType chassisType, ThrusterType thrusterType, double launchAngle, double thrustDurationPercent) {
        this(null, start, target, warheadType, chassisType, thrusterType, null, thrustDurationPercent);
        this.upperLaunchAngle = launchAngle;
        this.lowerLaunchAngle = launchAngle;
    }

    public BallisticTrajectory(CompoundTag data, MinecraftServer server) {
        super(data, server);
        this.velocity = new Vector3d(data.m_128459_("VelocityX"), data.m_128459_("VelocityY"), data.m_128459_("VelocityZ"));
        this.rotation = new Vector3d(data.m_128459_("RotationX"), data.m_128459_("RotationY"), data.m_128459_("RotationZ"));
        this.thrust = data.m_128459_("Thrust");
        this.thrustDurationPercent = data.m_128459_("ThrustDurationPercent");
        this.mass = data.m_128459_("Mass");
        this.launchDirection = new Vector3d(data.m_128459_("LaunchDirectionX"), data.m_128459_("LaunchDirectionY"), data.m_128459_("LaunchDirectionZ"));
        this.upperLaunchAngle = data.m_128459_("UpperLaunchAngle");
        this.lowerLaunchAngle = data.m_128459_("LowerLaunchAngle");
        this.upperDistanceToTarget = data.m_128441_("UpperDistanceToTarget") ? Double.valueOf(data.m_128459_("UpperDistanceToTarget")) : null;
        this.lowerDistanceToTarget = data.m_128441_("LowerDistanceToTarget") ? Double.valueOf(data.m_128459_("LowerDistanceToTarget")) : null;
        this.stopRefiningAngle = data.m_128471_("StopRefiningAngle");
    }

    @Override
    public CompoundTag saveTo(CompoundTag data) {
        CompoundTag superData = super.saveTo(data);
        superData.m_128347_("VelocityX", this.velocity.x);
        superData.m_128347_("VelocityY", this.velocity.y);
        superData.m_128347_("VelocityZ", this.velocity.z);
        superData.m_128347_("RotationX", this.rotation.x);
        superData.m_128347_("RotationY", this.rotation.y);
        superData.m_128347_("RotationZ", this.rotation.z);
        superData.m_128347_("Thrust", this.thrust);
        superData.m_128347_("ThrustDurationPercent", this.thrustDurationPercent);
        superData.m_128347_("Mass", this.mass);
        superData.m_128347_("LaunchDirectionX", this.launchDirection.x);
        superData.m_128347_("LaunchDirectionY", this.launchDirection.y);
        superData.m_128347_("LaunchDirectionZ", this.launchDirection.z);
        superData.m_128347_("UpperLaunchAngle", this.upperLaunchAngle.doubleValue());
        superData.m_128347_("LowerLaunchAngle", this.lowerLaunchAngle.doubleValue());
        if (this.upperDistanceToTarget != null) {
            superData.m_128347_("UpperDistanceToTarget", this.upperDistanceToTarget.doubleValue());
        }
        if (this.lowerDistanceToTarget != null) {
            superData.m_128347_("LowerDistanceToTarget", this.lowerDistanceToTarget.doubleValue());
        }
        superData.m_128379_("StopRefiningAngle", this.stopRefiningAngle);
        return superData;
    }

    public void refineLaunchAngleOnce() {
        int angles = 100;
        if (this.stopRefiningAngle) {
            return;
        }
        if (this.upperDistanceToTarget == null) {
            this.upperDistanceToTarget = this.getDistanceToTarget(this.upperLaunchAngle);
        }
        if (this.lowerDistanceToTarget == null) {
            this.lowerDistanceToTarget = this.getDistanceToTarget(this.lowerLaunchAngle);
        }
        ArrayList<Pair> distances = new ArrayList<Pair>();
        double angleStep = (this.upperLaunchAngle - this.lowerLaunchAngle) / (double)(angles + 1);
        distances.add(new Pair((Object)this.upperLaunchAngle, (Object)this.upperDistanceToTarget));
        for (int i = angles - 1; i >= 0; --i) {
            distances.add(new Pair((Object)(this.lowerLaunchAngle + angleStep * (double)(i + 1)), null));
        }
        distances.add(new Pair((Object)this.lowerLaunchAngle, (Object)this.lowerDistanceToTarget));
        Double bestUpperDistance = Double.POSITIVE_INFINITY;
        Double bestLowerDistance = Double.POSITIVE_INFINITY;
        Double bestUpperAngle = 0.0;
        Double bestLowerAngle = 0.0;
        for (int i = 0; i < distances.size() - 1; ++i) {
            Pair upper = (Pair)distances.get(i);
            Pair lower = (Pair)distances.get(i + 1);
            Double upperAngle = (Double)upper.getA();
            Double upperDistance = upper.getB() != null ? ((Double)upper.getB()).doubleValue() : this.getDistanceToTarget(upperAngle);
            Double lowerAngle = (Double)lower.getA();
            Double lowerDistance = lower.getB() != null ? ((Double)lower.getB()).doubleValue() : this.getDistanceToTarget(lowerAngle);
            distances.set(i + 1, new Pair((Object)lowerAngle, (Object)lowerDistance));
            double averageDistance = (upperDistance + lowerDistance) / 2.0;
            if (!(averageDistance < (bestUpperDistance + bestLowerDistance) / 2.0)) break;
            bestUpperDistance = upperDistance;
            bestLowerDistance = lowerDistance;
            bestUpperAngle = upperAngle;
            bestLowerAngle = lowerAngle;
        }
        if ((this.lowerDistanceToTarget + this.upperDistanceToTarget) / 2.0 - (bestUpperDistance + bestLowerDistance) / 2.0 < 0.01) {
            this.stopRefiningAngle = true;
        }
        this.upperDistanceToTarget = bestUpperDistance;
        this.lowerDistanceToTarget = bestLowerDistance;
        this.upperLaunchAngle = bestUpperAngle;
        this.lowerLaunchAngle = bestLowerAngle;
    }

    private double getDistanceToTarget(double angle) {
        BallisticTrajectory simulatedTrajectory = new BallisticTrajectory(new Vector3d((Vector3dc)this.initialPosition), new Vector3d((Vector3dc)this.targetPosition), this.warheadType, this.chassisType, this.thrusterType, angle, this.thrustDurationPercent);
        double minDistance = Double.POSITIVE_INFINITY;
        double previousDistance = Double.POSITIVE_INFINITY;
        while (true) {
            boolean descending;
            Vector3d currentPosition = new Vector3d((Vector3dc)simulatedTrajectory.getPosition());
            double currentDistance = this.targetPosition.distanceSquared((Vector3dc)currentPosition);
            boolean bl = descending = simulatedTrajectory.velocity.y < 0.0;
            if (descending) {
                minDistance = Math.min(minDistance, currentDistance);
            }
            if (descending && (currentDistance > previousDistance || currentPosition.y < this.targetPosition.y)) break;
            previousDistance = currentDistance;
            simulatedTrajectory.tick();
        }
        return minDistance;
    }

    @Override
    public void updateEntityModel(MissileEntity entity) {
        super.updateEntityModel(entity);
        if (entity == null) {
            return;
        }
        entity.setRotation(new Rotations((float)this.rotation.x, (float)this.rotation.y, (float)this.rotation.z));
    }

    public Double getUpperDistanceToTarget() {
        return this.upperDistanceToTarget;
    }

    public Double getLowerDistanceToTarget() {
        return this.lowerDistanceToTarget;
    }

    public Double getUpperLaunchAngle() {
        return this.upperLaunchAngle;
    }

    public Double getLowerLaunchAngle() {
        return this.lowerLaunchAngle;
    }

    public Vector3d getVelocity() {
        return new Vector3d((Vector3dc)this.velocity);
    }

    public void setUpperLaunchAngle(Double upperLaunchAngle) {
        this.upperLaunchAngle = upperLaunchAngle;
    }

    public void setLowerLaunchAngle(Double lowerLaunchAngle) {
        this.lowerLaunchAngle = lowerLaunchAngle;
    }

    private int getSign(double val) {
        return val >= 0.0 ? 1 : -1;
    }
}

