/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record MissileIngredient(int count, ItemStack[] items, TagKey<Item>[] tags) {
    public static final MissileIngredient EMPTY = new MissileIngredient(0, new ItemStack[0], new TagKey[0]);

    public boolean isEmpty() {
        return this.items.length == 0 && this.tags.length == 0 || this.count == 0;
    }

    public boolean test(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return itemStack.m_41619_();
        }
        for (ItemStack itemStack2 : this.items) {
            if (!itemStack2.m_150930_(itemStack.m_41720_())) continue;
            return true;
        }
        for (ItemStack itemStack3 : this.tags) {
            if (!itemStack.m_204117_((TagKey)itemStack3)) continue;
            return true;
        }
        return false;
    }

    public void toNetwork(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_236828_(Arrays.asList(this.items()), FriendlyByteBuf::m_130055_);
        friendlyByteBuf.m_236828_(Arrays.asList(this.tags()), (a, b) -> a.m_130085_(b.f_203868_()));
        friendlyByteBuf.writeInt(this.count);
    }

    public List<ItemStack> getAllValidItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.stream(this.items()).toList());
        for (TagKey<Item> tag : this.tags()) {
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(tag)) {
                items.add(new ItemStack(holder));
            }
        }
        return items;
    }

    public static MissileIngredient fromJson(JsonElement rawJson, boolean b) {
        if (rawJson != null && !rawJson.isJsonNull()) {
            if (rawJson.isJsonObject()) {
                JsonObject ingredient = rawJson.getAsJsonObject();
                int count = GsonHelper.m_13927_((JsonObject)ingredient, (String)"count");
                ItemStack[] items = new ItemStack[]{};
                if (ingredient.has("items")) {
                    JsonArray ingredientArray = GsonHelper.m_13933_((JsonObject)ingredient, (String)"items");
                    items = StreamSupport.stream(ingredientArray.spliterator(), false).map(MissileIngredient::itemStackFromJson).toList().toArray(new ItemStack[0]);
                }
                TagKey[] tags = new TagKey[]{};
                if (ingredient.has("tags")) {
                    JsonArray tagArray = GsonHelper.m_13933_((JsonObject)ingredient, (String)"tags");
                    tags = StreamSupport.stream(tagArray.spliterator(), false).map(MissileIngredient::tagFromJson).toList().toArray(new TagKey[0]);
                }
                return new MissileIngredient(count, items, tags);
            }
            throw new JsonSyntaxException("Value of key 'ingredients' must be an object");
        }
        throw new JsonSyntaxException("Value of key 'ingredients' cannot be null");
    }

    public static MissileIngredient fromNetwork(FriendlyByteBuf friendlyByteBuf) {
        ItemStack[] items = friendlyByteBuf.m_236845_(FriendlyByteBuf::m_130267_).toArray(new ItemStack[0]);
        TagKey[] tags = friendlyByteBuf.m_236845_(buf -> TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)buf.m_130281_())).toArray(new TagKey[0]);
        int count = friendlyByteBuf.readInt();
        return new MissileIngredient(count, items, tags);
    }

    private static ItemStack itemStackFromJson(JsonElement json) {
        ResourceLocation resourceLocation = new ResourceLocation(json.getAsString());
        return new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(resourceLocation));
    }

    private static TagKey<Item> tagFromJson(JsonElement json) {
        ResourceLocation resourceLocation = new ResourceLocation(json.getAsString());
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)resourceLocation);
    }
}

