/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.controlpanel;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.woukie.createmissiles.MultiblockHelper;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlock;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlockEntity;
import net.woukie.createmissiles.block.controlpanel.ControlPanelInstanceTracker;
import net.woukie.createmissiles.block.controlpanel.messages.TriggerBuildParticles;
import net.woukie.createmissiles.block.entity.AbstractBasicBlockEntity;
import net.woukie.createmissiles.block.launchpad.LaunchPadBlock;
import net.woukie.createmissiles.block.launchpad.LaunchPadBlockEntity;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelBlockEntity;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.inventory.ControlPanelMenu;
import net.woukie.createmissiles.missiles.Trajectories;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.MissilePartType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.trajectories.BallisticTrajectory;
import net.woukie.createmissiles.recipe.MissileIngredient;
import net.woukie.createmissiles.recipe.MissilePartRecipe;
import net.woukie.createmissiles.registry.BlockEntities;
import net.woukie.createmissiles.registry.Blocks;
import net.woukie.createmissiles.registry.EntityTypes;
import net.woukie.createmissiles.registry.Packets;
import net.woukie.createmissiles.registry.PartTypes;
import net.woukie.createmissiles.registry.RecipeTypes;
import net.woukie.createmissiles.registry.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ControlPanelBlockEntity
extends AbstractBasicBlockEntity {
    public static final double speedRequired = 64.0;
    private boolean initialized;
    private UUID entityId = null;
    private final class_3913 dataAccess;
    private boolean launching = false;
    private AssemblyPanelBlockEntity assemblyPanel;
    private class_2338 cornerLaunchPadPos;
    private int warheadBuildPercent;
    private int chassisBuildPercent;
    private int thrusterBuildPercent;

    public ControlPanelBlockEntity(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.items = class_2371.method_10213((int)96, (Object)class_1799.field_8037);
        this.dataAccess = new class_3913(){

            public int method_17390(int i) {
                return switch (i) {
                    case 0 -> ControlPanelBlockEntity.this.method_11016().method_10263();
                    case 1 -> ControlPanelBlockEntity.this.method_11016().method_10264();
                    case 2 -> ControlPanelBlockEntity.this.method_11016().method_10260();
                    case 3 -> {
                        if (ControlPanelBlockEntity.this.cornerLaunchPadPos == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 4 -> {
                        if (ControlPanelBlockEntity.this.assemblyPanel == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 5 -> {
                        if (MultiblockHelper.findEdgeBlock((class_2586)ControlPanelBlockEntity.this, ControlPanelBlockEntity.this.method_10997(), (class_2591)BlockEntities.NAVIGATION_PANEL.get()) == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 6 -> (int)ControlPanelBlockEntity.this.getSpeed();
                    default -> 0;
                };
            }

            public void method_17391(int i, int j) {
            }

            public int method_17389() {
                return 7;
            }
        };
    }

    public float getSpeed() {
        class_2586 blockEntity;
        class_2350 launchPadDirection = ((class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177)).method_10153();
        class_2338 launchPad = this.method_11016().method_10079(launchPadDirection, 1);
        class_1937 level = this.method_10997();
        if (level != null && (blockEntity = level.method_8321(launchPad)) instanceof LaunchPadBlockEntity) {
            LaunchPadBlockEntity launchPadBlockEntity = (LaunchPadBlockEntity)blockEntity;
            return launchPadBlockEntity.getSpeed();
        }
        return 0.0f;
    }

    public void giveItem(@NotNull class_1799 itemStack) {
        MissilePartRecipe recipe = this.findAcceptingRecipe(itemStack);
        if (recipe == null) {
            return;
        }
        MissilePartType partType = PartTypes.get(recipe.getAssembly());
        this.addItemToPartOfInventory(itemStack, partType.getStartSlot(), partType.getEndSlot());
    }

    private void addItemToPartOfInventory(class_1799 itemStack, int fromIndex, int toIndex) {
        class_1799 stack;
        int i;
        for (i = fromIndex; i < toIndex; ++i) {
            stack = this.method_5438(i);
            if (!class_1799.method_31577((class_1799)stack, (class_1799)itemStack)) continue;
            itemStack.method_7939(0);
            stack.method_7933(1);
            return;
        }
        for (i = fromIndex; i < toIndex; ++i) {
            stack = this.method_5438(i);
            if (!stack.method_7960()) continue;
            this.method_5447(i, itemStack.method_51164());
            return;
        }
    }

    public MissilePartRecipe findAcceptingRecipe(class_1799 itemStack) {
        if (this.field_11863 == null || itemStack.method_7947() != 1) {
            return null;
        }
        if (this.assemblyPanel == null) {
            return null;
        }
        MissilePartType warheadType = PartTypes.get(this.assemblyPanel.method_5438(0));
        MissilePartType chassisType = PartTypes.get(this.assemblyPanel.method_5438(1));
        MissilePartType thrusterType = PartTypes.get(this.assemblyPanel.method_5438(2));
        List missilePartRecipes = this.field_11863.method_8433().method_30027((class_3956)RecipeTypes.MISSILE_PART.get());
        for (MissilePartRecipe recipe : missilePartRecipes) {
            class_2960 assembly = recipe.getAssembly();
            if (!(warheadType != null && assembly.equals((Object)warheadType.getResourceLocation()) || chassisType != null && assembly.equals((Object)chassisType.getResourceLocation())) && (thrusterType == null || !assembly.equals((Object)thrusterType.getResourceLocation())) || !recipe.itemComplements(itemStack, (class_1263)this)) continue;
            return recipe;
        }
        return null;
    }

    public void tick() {
        class_2350 facing = ((class_2350)this.method_11010().method_11654((class_2769)AssemblyPanelBlock.field_11177)).method_10153();
        this.cornerLaunchPadPos = MultiblockHelper.findCorner(this.method_11016(), facing, this.field_11863);
        this.assemblyPanel = (AssemblyPanelBlockEntity)MultiblockHelper.findEdgeBlock(this.cornerLaunchPadPos, facing, this.method_10997(), (class_2591)BlockEntities.ASSEMBLY_PANEL.get());
        int oldWarheadBuildPercent = this.warheadBuildPercent;
        int oldChassisBuildPercent = this.chassisBuildPercent;
        int oldThrusterBuildPercent = this.thrusterBuildPercent;
        int oldBuildTotal = oldWarheadBuildPercent + oldChassisBuildPercent + oldThrusterBuildPercent;
        this.warheadBuildPercent = 0;
        this.chassisBuildPercent = 0;
        this.thrusterBuildPercent = 0;
        if (this.assemblyPanel == null) {
            return;
        }
        MissilePartType warheadType = PartTypes.get(this.assemblyPanel.method_5438(0));
        MissilePartType chassisType = PartTypes.get(this.assemblyPanel.method_5438(1));
        MissilePartType thrusterType = PartTypes.get(this.assemblyPanel.method_5438(2));
        this.warheadBuildPercent = MissilePartRecipe.getBuildPercentage(warheadType, this.field_11863, (List<class_1799>)this.items);
        this.chassisBuildPercent = MissilePartRecipe.getBuildPercentage(chassisType, this.field_11863, (List<class_1799>)this.items);
        this.thrusterBuildPercent = MissilePartRecipe.getBuildPercentage(thrusterType, this.field_11863, (List<class_1799>)this.items);
        if (this.field_11863 != null) {
            class_2338 soundOrigin = this.cornerLaunchPadPos.method_10093(facing).method_10093(facing.method_10170());
            int newBuildTotal = this.warheadBuildPercent + this.chassisBuildPercent + this.thrusterBuildPercent;
            if (oldBuildTotal < newBuildTotal) {
                class_243 p = soundOrigin.method_46558();
                if (!this.field_11863.field_9236) {
                    ((class_3218)this.field_11863).method_14199((class_2394)new class_2388(class_2398.field_11217, ((LaunchPadBlock)((Object)Blocks.LAUNCH_PAD.get())).method_9564()), p.field_1352, p.field_1351 + 0.5, p.field_1350, 10, 0.5, 0.0, 0.5, 45.0);
                    ((class_3218)this.field_11863).method_14199((class_2394)class_2398.field_11237, p.field_1352, p.field_1351 + 0.5, p.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    boolean partComplete = oldWarheadBuildPercent != 100 && this.warheadBuildPercent == 100 || oldChassisBuildPercent != 100 && this.chassisBuildPercent == 100 || oldThrusterBuildPercent != 100 && this.thrusterBuildPercent == 100;
                    float pitch = (float)newBuildTotal / 1200.0f + 0.75f;
                    pitch += (float)(Math.random() / 5.0) - 0.1f;
                    if (newBuildTotal == 300) {
                        this.field_11863.method_45447(null, soundOrigin, (class_3414)SoundEvents.DING.get(), class_3419.field_15245);
                    } else if (partComplete) {
                        this.field_11863.method_8396(null, soundOrigin, (class_3414)SoundEvents.BUILD_SPECIAL.get(), class_3419.field_15245, 1.0f, pitch);
                    } else {
                        this.field_11863.method_8396(null, soundOrigin, (class_3414)SoundEvents.BUILD.get(), class_3419.field_15245, 1.0f, pitch);
                    }
                    Packets.TRIGGER_BUILD_PARTICLES.sendToPlayers((Iterable)((class_3218)this.field_11863).method_18766(serverPlayer -> serverPlayer.method_19538().method_1022(p) < 128.0), (Object)new TriggerBuildParticles(p.method_46409(), warheadType == null ? new class_2960("") : warheadType.getResourceLocation(), chassisType == null ? new class_2960("") : chassisType.getResourceLocation(), thrusterType == null ? new class_2960("") : thrusterType.getResourceLocation(), this.warheadBuildPercent, this.chassisBuildPercent, this.thrusterBuildPercent));
                }
            }
        }
    }

    public void serverTick() {
        class_3218 level;
        if (!this.initialized && this.method_11002()) {
            this.initialized = true;
            ControlPanelInstanceTracker.add(this);
        }
        if ((level = (class_3218)this.method_10997()) == null) {
            return;
        }
        if (this.launching) {
            this.launch();
        }
        class_2338 entityPosition = this.method_11016();
        if (this.cornerLaunchPadPos != null) {
            class_2350 forward = ((class_2350)this.method_11010().method_11654((class_2769)AssemblyPanelBlock.field_11177)).method_10153();
            entityPosition = new class_2338((class_2382)this.cornerLaunchPadPos).method_10093(forward).method_10093(forward.method_10170());
        }
        class_1297 entity = level.method_14190(this.entityId);
        if (this.entityId == null) {
            entity = new MissileEntity((class_1299)EntityTypes.MISSILE.get(), (class_1937)level);
            entity.method_5814((double)entityPosition.method_10263() + 0.5, (double)entityPosition.method_10264() + 0.5, (double)entityPosition.method_10260() + 0.5);
            level.method_8649(entity);
            this.entityId = entity.method_5667();
            this.method_5431();
        }
        if (entity != null && entity.method_5864().equals(EntityTypes.MISSILE.get())) {
            MissileEntity missileEntity = (MissileEntity)entity;
            if (this.cornerLaunchPadPos == null) {
                this.ejectNotNeededItems(null, 0, 96);
                missileEntity.setWarheadBuildPercent(0);
                missileEntity.setChassisBuildPercent(0);
                missileEntity.setThrusterBuildPercent(0);
            }
            if (this.assemblyPanel != null) {
                class_1799 warheadItem = this.assemblyPanel.method_5438(0);
                class_1799 chassisItem = this.assemblyPanel.method_5438(1);
                class_1799 thrusterItem = this.assemblyPanel.method_5438(2);
                MissilePartType warheadType = PartTypes.get(warheadItem);
                MissilePartType chassisType = PartTypes.get(chassisItem);
                MissilePartType thrusterType = PartTypes.get(thrusterItem);
                missileEntity.setWarheadBuildPercent(this.warheadBuildPercent);
                missileEntity.setWarheadType(warheadType == null ? null : warheadType.getResourceLocation());
                missileEntity.setChassisBuildPercent(this.chassisBuildPercent);
                missileEntity.setChassisType(chassisType == null ? null : chassisType.getResourceLocation());
                missileEntity.setThrusterBuildPercent(this.thrusterBuildPercent);
                missileEntity.setThrusterType(thrusterType == null ? null : thrusterType.getResourceLocation());
                this.ejectNotNeededItems(warheadType, 0, 32);
                this.ejectNotNeededItems(chassisType, 32, 64);
                this.ejectNotNeededItems(thrusterType, 64, 96);
            } else {
                this.ejectNotNeededItems(null, 0, 96);
                missileEntity.setWarheadBuildPercent(0);
                missileEntity.setChassisBuildPercent(0);
                missileEntity.setThrusterBuildPercent(0);
            }
            missileEntity.method_33574(entityPosition.method_46558());
        }
    }

    private void ejectNotNeededItems(@Nullable MissilePartType partType, int backupStartSlot, int backupEndSlot) {
        if (this.field_11863 == null) {
            return;
        }
        Optional<MissilePartRecipe> recipe = MissilePartRecipe.fromResourceLocation(this.field_11863, partType == null ? null : partType.getResourceLocation());
        Map ingredientStatus = recipe.map(a -> a.getMissileIngredients().stream().collect(Collectors.toMap(b -> b, MissileIngredient::count))).orElseGet(Map::of);
        int start = partType != null ? partType.getStartSlot() : backupStartSlot;
        int end = partType != null ? partType.getEndSlot() : backupEndSlot;
        for (int i = start; i < end; ++i) {
            class_1799 item = this.method_5438(i);
            if (item.method_7960()) continue;
            Optional<MissileIngredient> matchingIngredient = ingredientStatus.keySet().stream().filter(a -> a.test(item)).findFirst();
            if (matchingIngredient.isPresent()) {
                int requiredCount;
                int itemCount = item.method_7947();
                if (itemCount < (requiredCount = ((Integer)ingredientStatus.get(matchingIngredient.get())).intValue())) {
                    ingredientStatus.put(matchingIngredient.get(), requiredCount - itemCount);
                    continue;
                }
                if (itemCount != requiredCount) {
                    class_1799 ejected = item.method_7971(requiredCount - itemCount);
                    class_2347.method_10134((class_1937)this.field_11863, (class_1799)ejected, (int)1, (class_2350)class_2350.field_11036, (class_2374)this.method_11016().method_46558());
                }
                ingredientStatus.remove(matchingIngredient.get());
                continue;
            }
            class_2347.method_10134((class_1937)this.field_11863, (class_1799)item.method_51164(), (int)1, (class_2350)class_2350.field_11036, (class_2374)this.method_11016().method_46558());
        }
    }

    public void launch() {
        if (this.method_10997() == null || this.method_10997().method_8503() == null || Thread.currentThread() != this.method_10997().method_8503().method_3777()) {
            this.launching = true;
            return;
        }
        this.launching = false;
        if (this.cornerLaunchPadPos == null) {
            return;
        }
        if (this.assemblyPanel == null) {
            return;
        }
        NavigationPanelBlockEntity navigationPanel = (NavigationPanelBlockEntity)MultiblockHelper.findEdgeBlock((class_2586)this, this.method_10997(), (class_2591)BlockEntities.NAVIGATION_PANEL.get());
        if (navigationPanel == null) {
            return;
        }
        if ((double)Math.abs(this.getSpeed()) < 64.0) {
            return;
        }
        MissilePartRecipe warheadRecipe = null;
        MissilePartRecipe chassisRecipe = null;
        MissilePartRecipe thrusterRecipe = null;
        WarheadType warheadType = (WarheadType)PartTypes.get(this.assemblyPanel.method_5438(0));
        ChassisType chassisType = (ChassisType)PartTypes.get(this.assemblyPanel.method_5438(1));
        ThrusterType thrusterType = (ThrusterType)PartTypes.get(this.assemblyPanel.method_5438(2));
        if (warheadType == null || chassisType == null || thrusterType == null) {
            return;
        }
        List missilePartRecipes = this.method_10997().method_8433().method_30027((class_3956)RecipeTypes.MISSILE_PART.get());
        for (MissilePartRecipe recipe : missilePartRecipes) {
            if (warheadRecipe != null && chassisRecipe != null && thrusterRecipe != null) break;
            class_2960 assembly = recipe.getAssembly();
            if (assembly.equals((Object)warheadType.getResourceLocation())) {
                warheadRecipe = recipe;
                continue;
            }
            if (assembly.equals((Object)chassisType.getResourceLocation())) {
                chassisRecipe = recipe;
                continue;
            }
            if (!assembly.equals((Object)thrusterType.getResourceLocation())) continue;
            thrusterRecipe = recipe;
        }
        if (warheadRecipe == null || chassisRecipe == null || thrusterRecipe == null) {
            return;
        }
        if (!warheadRecipe.method_8115((class_1263)this, this.method_10997())) {
            return;
        }
        if (!chassisRecipe.method_8115((class_1263)this, this.method_10997())) {
            return;
        }
        if (!thrusterRecipe.method_8115((class_1263)this, this.method_10997())) {
            return;
        }
        class_2350 launchPadDirection = ((class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177)).method_10153();
        class_2338 targetBlock = navigationPanel.getTarget();
        if (targetBlock == null) {
            return;
        }
        Vector3f target = targetBlock.method_46558().method_46409();
        class_2338 sourceBlockPos = this.cornerLaunchPadPos.method_10079(launchPadDirection, 1).method_10093(launchPadDirection.method_10170());
        Vector3f source = sourceBlockPos.method_46558().method_46409();
        this.method_10997().method_45447(null, sourceBlockPos, (class_3414)SoundEvents.BUTTON.get(), class_3419.field_15245);
        Trajectory trajectory = thrusterType.createTrajectory(this.field_11863, new Vector3d((Vector3fc)source), new Vector3d((Vector3fc)target), warheadType, chassisType, thrusterType, (class_1263)this, navigationPanel);
        if (trajectory instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)trajectory;
            ballisticTrajectory.setLowerLaunchAngle(navigationPanel.getLowerLaunchAngle());
            ballisticTrajectory.setUpperLaunchAngle(navigationPanel.getUpperLaunchAngle());
        }
        Trajectories trajectories = Trajectories.get();
        trajectories.launch(trajectory);
        warheadType.onLaunch(trajectory, (class_3218)this.field_11863);
        chassisType.onLaunch(trajectory, (class_3218)this.field_11863);
        thrusterType.onLaunch(trajectory, (class_3218)this.field_11863);
        trajectories.method_80();
        this.method_5448();
    }

    public int method_5444() {
        return Integer.MAX_VALUE;
    }

    public void method_11012() {
        class_3218 level;
        class_1297 entity;
        super.method_11012();
        ControlPanelInstanceTracker.remove(this);
        if (this.method_10997() != null && !this.method_10997().field_9236 && (entity = (level = (class_3218)this.method_10997()).method_14190(this.entityId)) != null && entity.method_5864().equals(EntityTypes.MISSILE.get())) {
            entity.method_5650(class_1297.class_5529.field_26998);
        }
    }

    public void method_11014(@NotNull class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, (class_2371)this.items);
        if (compoundTag.method_10545("EntityID")) {
            this.entityId = compoundTag.method_25926("EntityID");
        }
    }

    protected void method_11007(@NotNull class_2487 compoundTag) {
        super.method_11007(compoundTag);
        class_1262.method_5426((class_2487)compoundTag, (class_2371)this.items);
        if (this.entityId != null) {
            compoundTag.method_25927("EntityID", this.entityId);
        }
    }

    public void method_38240(@NotNull class_1799 itemStack) {
        class_2487 data = this.method_38244();
        data.method_10551("EntityID");
        data.method_10551("Items");
        class_1747.method_38073((class_1799)itemStack, (class_2591)this.method_11017(), (class_2487)data);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.createmissiles.control_panel");
    }

    @NotNull
    protected class_1703 method_5465(int id, @NotNull class_1661 playerInventory) {
        class_2350 facing = ((class_2350)this.method_11010().method_11654((class_2769)class_2383.field_11177)).method_10153();
        class_2586 navigationPanel = MultiblockHelper.findEdgeBlock(this.cornerLaunchPadPos, facing, this.method_10997(), (class_2591)BlockEntities.NAVIGATION_PANEL.get());
        return new ControlPanelMenu(id, playerInventory, (class_1263)this, this.dataAccess, (class_1263)(this.assemblyPanel == null ? new class_1277(3) : this.assemblyPanel), (class_1263)(navigationPanel == null ? new class_1277(1) : (class_1263)navigationPanel));
    }

    @Override
    public boolean method_5492(int i, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        return false;
    }

    @Override
    public boolean method_5493(int i, @NotNull class_1799 itemStack, @NotNull class_2350 direction) {
        return false;
    }
}

