/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.block.navigationpanel;

import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3913;
import net.woukie.createmissiles.MultiblockHelper;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlock;
import net.woukie.createmissiles.block.assemblypanel.AssemblyPanelBlockEntity;
import net.woukie.createmissiles.block.entity.AbstractBasicBlockEntity;
import net.woukie.createmissiles.block.navigationpanel.NavigationPanelInstanceTracker;
import net.woukie.createmissiles.block.navigationpanel.messages.UpdateMapDataMessage;
import net.woukie.createmissiles.inventory.NavigationPanelMenu;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.missiles.trajectories.BallisticTrajectory;
import net.woukie.createmissiles.registry.BlockEntities;
import net.woukie.createmissiles.registry.Packets;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class NavigationPanelBlockEntity
extends AbstractBasicBlockEntity {
    public static final int SLOT_MAP = 0;
    private double mapCrosshairX;
    private double mapCrosshairZ;
    private float thrustDurationPercent;
    private boolean initialized;
    private class_2338 target;
    private final class_3913 dataAccess;
    private Trajectory simulatedTrajectory;

    public NavigationPanelBlockEntity(class_2591<?> blockEntityType, final class_2338 blockPos, final class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
        this.items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);
        this.mapCrosshairX = 64.0;
        this.mapCrosshairZ = 64.0;
        this.thrustDurationPercent = 0.5f;
        this.dataAccess = new class_3913(){

            public int method_17390(int i) {
                return switch (i) {
                    case 0 -> (int)NavigationPanelBlockEntity.this.mapCrosshairX;
                    case 1 -> (int)NavigationPanelBlockEntity.this.mapCrosshairZ;
                    case 2 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 3 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield NavigationPanelBlockEntity.this.target.method_10263();
                    }
                    case 4 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield NavigationPanelBlockEntity.this.target.method_10264();
                    }
                    case 5 -> {
                        if (NavigationPanelBlockEntity.this.target == null) {
                            yield 0;
                        }
                        yield NavigationPanelBlockEntity.this.target.method_10260();
                    }
                    case 6 -> NavigationPanelBlockEntity.this.method_11016().method_10263();
                    case 7 -> NavigationPanelBlockEntity.this.method_11016().method_10264();
                    case 8 -> NavigationPanelBlockEntity.this.method_11016().method_10260();
                    case 9 -> Float.floatToIntBits(NavigationPanelBlockEntity.this.thrustDurationPercent) >> 16;
                    case 10 -> Float.floatToIntBits(NavigationPanelBlockEntity.this.thrustDurationPercent) & 0xFFFF;
                    case 11 -> {
                        if (MultiblockHelper.findCorner(blockPos, ((class_2350)blockState.method_11654((class_2769)AssemblyPanelBlock.field_11177)).method_10153(), NavigationPanelBlockEntity.this.field_11863) == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 12 -> {
                        if (MultiblockHelper.findEdgeBlock((class_2586)NavigationPanelBlockEntity.this, NavigationPanelBlockEntity.this.method_10997(), (class_2591)BlockEntities.ASSEMBLY_PANEL.get()) == null) {
                            yield 0;
                        }
                        yield 1;
                    }
                    case 13 -> {
                        Trajectory var3_2 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_2 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_2;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getUpperLaunchAngle().doubleValue()) >> 16;
                        }
                        yield 90;
                    }
                    case 14 -> {
                        Trajectory var3_3 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_3 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_3;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getUpperLaunchAngle().doubleValue()) & 0xFFFF;
                        }
                        yield 90;
                    }
                    case 15 -> {
                        Trajectory var3_4 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_4 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_4;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getLowerLaunchAngle().doubleValue()) >> 16;
                        }
                        yield 0;
                    }
                    case 16 -> {
                        Trajectory var3_5 = NavigationPanelBlockEntity.this.simulatedTrajectory;
                        if (var3_5 instanceof BallisticTrajectory) {
                            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)var3_5;
                            yield Float.floatToIntBits((float)ballisticTrajectory.getLowerLaunchAngle().doubleValue()) & 0xFFFF;
                        }
                        yield 0;
                    }
                    default -> 0;
                };
            }

            public void method_17391(int i, int j) {
            }

            public int method_17389() {
                return 17;
            }
        };
    }

    public void serverTick() {
        if (!this.initialized && this.method_11002()) {
            this.initialized = true;
            NavigationPanelInstanceTracker.add(this);
        }
        this.tickTarget();
        this.tickTrajectory();
    }

    public void fuelClicked(float fuelPercent) {
        this.thrustDurationPercent = fuelPercent;
        this.simulatedTrajectory = null;
    }

    public void mapClicked(double mapCrosshairX, double mapCrosshairZ) {
        this.mapCrosshairX = mapCrosshairX;
        this.mapCrosshairZ = mapCrosshairZ;
        this.target = null;
        this.simulatedTrajectory = null;
    }

    public class_2338 getTarget() {
        return this.target;
    }

    private void tickTarget() {
        int scan;
        class_1799 mapItem = this.method_5438(0);
        if (!mapItem.method_31574(class_1802.field_8204) || this.field_11863 == null) {
            this.target = null;
            this.simulatedTrajectory = null;
            return;
        }
        class_22 mapData = class_1806.method_8001((class_1799)mapItem, (class_1937)this.field_11863);
        if (mapData == null) {
            this.target = null;
            this.simulatedTrajectory = null;
            return;
        }
        int multiplier = 1 << mapData.field_119;
        int blockX = (int)((double)(mapData.field_116 - 64 * multiplier) + (double)multiplier * this.mapCrosshairX);
        int blockZ = (int)((double)(mapData.field_115 - 64 * multiplier) + (double)multiplier * this.mapCrosshairZ);
        class_1923 chunkPos = new class_1923(new class_2338(blockX, 0, blockZ));
        if (!this.field_11863.method_8477(new class_2338(blockX, 0, blockZ))) {
            ((class_3218)this.field_11863).method_17988(chunkPos.field_9181, chunkPos.field_9180, true);
            return;
        }
        class_2338 impactPos = new class_2338(blockX, scan, blockZ);
        for (scan = this.field_11863.method_31600(); scan >= this.field_11863.method_31607() && this.field_11863.method_8320(impactPos = new class_2338(blockX, scan, blockZ)).method_26215(); --scan) {
        }
        this.target = impactPos;
        ((class_3218)this.field_11863).method_17988(chunkPos.field_9181, chunkPos.field_9180, false);
    }

    private void tickTrajectory() {
        Object chassisType;
        if (this.target == null) {
            return;
        }
        class_2350 facing = ((class_2350)this.method_11010().method_11654((class_2769)AssemblyPanelBlock.field_11177)).method_10153();
        class_2338 corner = MultiblockHelper.findCorner(this.method_11016(), facing, this.field_11863);
        class_2586 blockEntity = MultiblockHelper.findEdgeBlock(corner, facing, this.method_10997(), (class_2591)BlockEntities.ASSEMBLY_PANEL.get());
        if (blockEntity == null) {
            return;
        }
        AssemblyPanelBlockEntity assemblyPanel = (AssemblyPanelBlockEntity)blockEntity;
        if (!assemblyPanel.hasAllAssemblies()) {
            return;
        }
        if (this.simulatedTrajectory == null) {
            WarheadType warheadType = (WarheadType)PartTypes.get(assemblyPanel.method_5438(0));
            chassisType = (ChassisType)PartTypes.get(assemblyPanel.method_5438(1));
            ThrusterType thrusterType = (ThrusterType)PartTypes.get(assemblyPanel.method_5438(2));
            Vector3d start = new Vector3d((double)this.method_11016().method_10263(), (double)this.method_11016().method_10264(), (double)this.method_11016().method_10260()).add(0.5, 0.5, 0.5);
            Vector3d end = new Vector3d((double)this.target.method_10263(), (double)this.target.method_10264(), (double)this.target.method_10260()).add(0.5, 0.5, 0.5);
            this.simulatedTrajectory = thrusterType.createTrajectory(this.field_11863, start, end, warheadType, (ChassisType)chassisType, thrusterType, null, this);
        }
        if ((chassisType = this.simulatedTrajectory) instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)chassisType;
            Double low = ballisticTrajectory.getLowerDistanceToTarget();
            Double up = ballisticTrajectory.getUpperDistanceToTarget();
            if (low == null || up == null || low + up > 0.5) {
                ballisticTrajectory.refineLaunchAngleOnce();
            }
        }
    }

    public void method_11012() {
        super.method_11012();
        NavigationPanelInstanceTracker.remove(this);
    }

    public void method_11014(@NotNull class_2487 compoundTag) {
        super.method_11014(compoundTag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, (class_2371)this.items);
        this.mapCrosshairX = compoundTag.method_10574("MapCrosshairX");
        this.mapCrosshairZ = compoundTag.method_10574("MapCrosshairZ");
        this.thrustDurationPercent = compoundTag.method_10583("FuelPercent");
    }

    protected void method_11007(@NotNull class_2487 compoundTag) {
        super.method_11007(compoundTag);
        compoundTag.method_10549("MapCrosshairX", this.mapCrosshairX);
        compoundTag.method_10549("MapCrosshairZ", this.mapCrosshairZ);
        compoundTag.method_10548("FuelPercent", this.thrustDurationPercent);
        class_1262.method_5426((class_2487)compoundTag, (class_2371)this.items);
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.createmissiles.navigation_panel");
    }

    @NotNull
    protected class_1703 method_5465(int id, @NotNull class_1661 playerInventory) {
        class_1799 itemStack;
        class_2350 facing = ((class_2350)this.method_11010().method_11654((class_2769)AssemblyPanelBlock.field_11177)).method_10153();
        class_2338 corner = MultiblockHelper.findCorner(this.method_11016(), facing, this.field_11863);
        class_2586 assemblyPanel = MultiblockHelper.findEdgeBlock(corner, facing, this.method_10997(), (class_2591)BlockEntities.ASSEMBLY_PANEL.get());
        if (this.field_11863 != null && !this.field_11863.field_9236 && (itemStack = this.method_5438(0)).method_31574(class_1802.field_8204) && !itemStack.method_7960()) {
            class_22 data = class_1806.method_8001((class_1799)itemStack, (class_1937)this.field_11863);
            Integer mapId = class_1806.method_8003((class_1799)itemStack);
            if (data != null && mapId != null) {
                Packets.UPDATE_MAP_DATA.sendToPlayer((class_3222)playerInventory.field_7546, (Object)new UpdateMapDataMessage(mapId, data.method_75(new class_2487())));
            }
        }
        return new NavigationPanelMenu(id, playerInventory, (class_1263)this, this.dataAccess, (class_1263)(assemblyPanel == null ? new class_1277(3) : (AssemblyPanelBlockEntity)assemblyPanel));
    }

    public boolean method_5437(int i, @NotNull class_1799 itemStack) {
        return i == 0 && itemStack.method_31574(class_1802.field_8204);
    }

    public double getUpperLaunchAngle() {
        Trajectory trajectory = this.simulatedTrajectory;
        if (trajectory instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)trajectory;
            return ballisticTrajectory.getUpperLaunchAngle();
        }
        return 0.0;
    }

    public double getLowerLaunchAngle() {
        Trajectory trajectory = this.simulatedTrajectory;
        if (trajectory instanceof BallisticTrajectory) {
            BallisticTrajectory ballisticTrajectory = (BallisticTrajectory)trajectory;
            return ballisticTrajectory.getLowerLaunchAngle();
        }
        return 0.0;
    }

    public float getThrustDurationPercent() {
        return this.thrustDurationPercent;
    }
}

