/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.client;

import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2379;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5607;
import net.minecraft.class_5617;
import net.minecraft.class_630;
import net.minecraft.class_897;
import net.woukie.createmissiles.client.MissilePartModel;
import net.woukie.createmissiles.entity.MissileEntity;
import net.woukie.createmissiles.missiles.parts.ChassisType;
import net.woukie.createmissiles.missiles.parts.ThrusterType;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import net.woukie.createmissiles.registry.PartModels;
import net.woukie.createmissiles.registry.PartTypes;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MissileRenderer
extends class_897<MissileEntity> {
    public MissileRenderer(class_5617.class_5618 context) {
        super(context);
    }

    public void render(@NotNull MissileEntity entity, float f, float g, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int i) {
        WarheadType warheadType = (WarheadType)PartTypes.get(entity.getWarheadType());
        ChassisType chassisType = (ChassisType)PartTypes.get(entity.getChassisType());
        ThrusterType thrusterType = (ThrusterType)PartTypes.get(entity.getThrusterType());
        poseStack.method_22903();
        Vector3f offset = new Vector3f(0.0f, 4.0f, 0.0f);
        if (thrusterType != null) {
            MissileRenderer.renderPart(entity, poseStack, multiBufferSource, i, PartModels.getModel(thrusterType.getResourceLocation()), entity.getThrusterBuildPercent(), offset);
        }
        if (chassisType != null) {
            MissileRenderer.renderPart(entity, poseStack, multiBufferSource, i, PartModels.getModel(chassisType.getResourceLocation()), entity.getChassisBuildPercent(), offset);
        }
        if (warheadType != null) {
            MissileRenderer.renderPart(entity, poseStack, multiBufferSource, i, PartModels.getModel(warheadType.getResourceLocation()), entity.getWarheadBuildPercent(), offset);
        }
        super.method_3936((class_1297)entity, f, g, poseStack, multiBufferSource, i);
        poseStack.method_22909();
    }

    private static void renderPart(@NotNull MissileEntity entity, @NotNull class_4587 poseStack, @NotNull class_4597 multiBufferSource, int i, MissilePartModel model, int buildPercent, Vector3f offset) {
        int stage = model.getStage(buildPercent);
        Map<String, Vector3f> attachments = model.getAttachements(stage);
        offset.add((Vector3fc)attachments.get("bottom"));
        class_5607 warheadModelLayerDefinition = model.getLayerDefinition(stage);
        class_630 part = warheadModelLayerDefinition.method_32109();
        class_2379 rotation = entity.getRotation();
        part.method_41922(new Vector3f(rotation.method_10256(), rotation.method_10257(), rotation.method_10258()));
        Vector3f vec = new Vector3f((Vector3fc)offset);
        part.method_41920(vec.rotateX(rotation.method_10256()).rotateY(rotation.method_10257()).rotateZ(rotation.method_10258()));
        class_4588 warheadVertexConsumer = multiBufferSource.getBuffer(class_1921.method_23580((class_2960)model.getTexture(stage)));
        part.method_22699(poseStack, warheadVertexConsumer, i, class_4608.field_21444, 1.0f, 1.0f, 1.0f, 1.0f);
        if (attachments.containsKey("top")) {
            offset.add((Vector3fc)attachments.get("top"));
        }
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull MissileEntity entity) {
        return new class_2960("createmissiles", "textures/entity/gunpowder_thruster.png");
    }
}

