/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.entity.drone;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3620;
import net.minecraft.class_4076;

public class MapUtils {
    private static final Set<SpawnMap> spawnMaps = new HashSet<SpawnMap>();

    public static void spawnMapAt(class_3218 level, class_243 position, class_2338 target) {
        spawnMaps.add(new SpawnMap(level, position, target));
    }

    public static void serverTick() {
        spawnMaps.removeIf(spawnMap -> {
            class_2338 target = spawnMap.target;
            class_3218 level = spawnMap.level;
            List<class_1923> affectedChunks = MapUtils.getChunksForTarget(target);
            for (class_1923 pos : affectedChunks) {
                if (level.method_8477(new class_2338((pos.field_9181 << 4) + 8, 0, (pos.field_9180 << 4) + 8))) continue;
                level.method_17988(pos.field_9181, pos.field_9180, true);
                return false;
            }
            class_1799 stack = MapUtils.createAndFillMap((class_1937)level, target.method_10263(), target.method_10260(), 1);
            class_2347.method_10134((class_1937)level, (class_1799)stack, (int)1, (class_2350)class_2350.field_11036, (class_2374)spawnMap.position);
            level.method_43128(null, spawnMap.position.field_1352, spawnMap.position.field_1351, spawnMap.position.field_1350, (class_3414)class_3417.field_14725.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            affectedChunks.forEach(chunkPos -> level.method_17988(chunkPos.field_9181, chunkPos.field_9180, false));
            return true;
        });
    }

    public static List<class_1923> getChunksForTarget(class_2338 target) {
        ArrayList<class_1923> chunks = new ArrayList<class_1923>();
        int radius = 128;
        int minChunkX = target.method_10263() - radius >> 4;
        int maxChunkX = target.method_10263() + radius >> 4;
        int minChunkZ = target.method_10260() - radius >> 4;
        int maxChunkZ = target.method_10260() + radius >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int closestX = Math.max(chunkX << 4, Math.min(target.method_10263(), (chunkX << 4) + 15));
                int closestZ = Math.max(chunkZ << 4, Math.min(target.method_10260(), (chunkZ << 4) + 15));
                double distanceSquared = Math.pow(target.method_10263() - closestX, 2.0) + Math.pow(target.method_10260() - closestZ, 2.0);
                if (!(distanceSquared <= (double)(radius * radius))) continue;
                chunks.add(new class_1923(chunkX, chunkZ));
            }
        }
        return chunks;
    }

    public static class_1799 createAndFillMap(class_1937 level, int centerX, int centerZ, int scale) {
        class_1799 map = class_1806.method_8005((class_1937)level, (int)centerX, (int)centerZ, (byte)((byte)scale), (boolean)true, (boolean)true);
        class_22 mapData = class_1806.method_8001((class_1799)map, (class_1937)level);
        if (mapData == null) {
            return map;
        }
        MapUtils.fillMapData(level, centerX, centerZ, Objects.requireNonNull(class_1806.method_8001((class_1799)map, (class_1937)level)));
        return map;
    }

    private static class_2680 getCorrectStateForFluidBlock(class_1937 level, class_2680 blockState, class_2338 blockPos) {
        class_3610 fluidState = blockState.method_26227();
        return !fluidState.method_15769() && !blockState.method_26206((class_1922)level, blockPos, class_2350.field_11036) ? fluidState.method_15759() : blockState;
    }

    public static void fillMapData(class_1937 level, double X, double Z, class_22 mapItemSavedData) {
        if (level.method_27983() == mapItemSavedData.field_118) {
            int i = 1 << mapItemSavedData.field_119;
            int j = mapItemSavedData.field_116;
            int k = mapItemSavedData.field_115;
            int l = class_3532.method_15357((double)(X - (double)j)) / i + 64;
            int m = class_3532.method_15357((double)(Z - (double)k)) / i + 64;
            int n = 128 / i;
            if (level.method_8597().comp_643()) {
                n /= 2;
            }
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            class_2338.class_2339 mutableBlockPos2 = new class_2338.class_2339();
            boolean bl = false;
            for (int o = l - n + 1; o < l + n; ++o) {
                bl = false;
                double d = 0.0;
                for (int p = m - n - 1; p < m + n; ++p) {
                    double f;
                    if (o < 0 || p < -1 || o >= 128 || p >= 128) continue;
                    int q = class_3532.method_34954((int)(o - l)) + class_3532.method_34954((int)(p - m));
                    boolean bl2 = q > (n - 2) * (n - 2);
                    int r = (j / i + o - 64) * i;
                    int s = (k / i + p - 64) * i;
                    LinkedHashMultiset multiset = LinkedHashMultiset.create();
                    class_2818 levelChunk = level.method_8497(class_4076.method_18675((int)r), class_4076.method_18675((int)s));
                    if (levelChunk.method_12223()) continue;
                    int t = 0;
                    double e = 0.0;
                    if (level.method_8597().comp_643()) {
                        u = r + s * 231871;
                        if (((u = u * u * 31287121 + u * 11) >> 20 & 1) == 0) {
                            multiset.add((Object)class_2246.field_10566.method_9564().method_26205((class_1922)level, class_2338.field_10980), 10);
                        } else {
                            multiset.add((Object)class_2246.field_10340.method_9564().method_26205((class_1922)level, class_2338.field_10980), 100);
                        }
                        e = 100.0;
                    } else {
                        for (u = 0; u < i; ++u) {
                            for (int v = 0; v < i; ++v) {
                                class_2680 blockState;
                                mutableBlockPos.method_10103(r + u, 0, s + v);
                                int w = levelChunk.method_12005(class_2902.class_2903.field_13202, mutableBlockPos.method_10263(), mutableBlockPos.method_10260()) + 1;
                                if (w <= level.method_31607() + 1) {
                                    blockState = class_2246.field_9987.method_9564();
                                } else {
                                    do {
                                        mutableBlockPos.method_33098(--w);
                                    } while ((blockState = levelChunk.method_8320((class_2338)mutableBlockPos)).method_26205((class_1922)level, (class_2338)mutableBlockPos) == class_3620.field_16008 && w > level.method_31607());
                                    if (w > level.method_31607() && !blockState.method_26227().method_15769()) {
                                        class_2680 blockState2;
                                        int x = w - 1;
                                        mutableBlockPos2.method_10101((class_2382)mutableBlockPos);
                                        do {
                                            mutableBlockPos2.method_33098(x--);
                                            blockState2 = levelChunk.method_8320((class_2338)mutableBlockPos2);
                                            ++t;
                                        } while (x > level.method_31607() && !blockState2.method_26227().method_15769());
                                        blockState = MapUtils.getCorrectStateForFluidBlock(level, blockState, (class_2338)mutableBlockPos);
                                    }
                                }
                                mapItemSavedData.method_109((class_1922)level, mutableBlockPos.method_10263(), mutableBlockPos.method_10260());
                                e += (double)w / (double)(i * i);
                                multiset.add((Object)blockState.method_26205((class_1922)level, (class_2338)mutableBlockPos));
                            }
                        }
                    }
                    class_3620 mapColor = (class_3620)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)multiset), (Object)class_3620.field_16008);
                    class_3620.class_6594 brightness = mapColor == class_3620.field_16019 ? ((f = (double)(t /= i * i) * 0.1 + (double)(o + p & 1) * 0.2) < 0.5 ? class_3620.class_6594.field_34761 : (f > 0.9 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760)) : ((f = (e - d) * 4.0 / (double)(i + 4) + ((double)(o + p & 1) - 0.5) * 0.4) > 0.6 ? class_3620.class_6594.field_34761 : (f < -0.6 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760));
                    d = e;
                    if (p < 0 || q >= n * n || bl2 && (o + p & 1) == 0) continue;
                    bl |= mapItemSavedData.method_32365(o, p, mapColor.method_38481(brightness));
                }
            }
        }
    }

    static class SpawnMap {
        private class_3218 level;
        private class_243 position;
        private class_2338 target;

        public SpawnMap(class_3218 level, class_243 position, class_2338 target) {
            this.level = level;
            this.position = position;
            this.target = target;
        }
    }
}

