/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.asyncexplosionhandler;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.woukie.createmissiles.ExplosionResistanceOverrides;
import net.woukie.createmissiles.Util;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ExplodingAreaWorker
implements Runnable {
    private final class_2338 start;
    private final class_2338 end;
    private final Vector3d origin;
    private final class_1937 level;
    private final Double power;
    private final Double decay;
    private final ConcurrentHashMap<class_2338, Float> hardnessMap;
    private final double maxDistance;
    private PriorityBlockingQueue<class_2338> removeBlocks;
    private PriorityBlockingQueue<class_2338> brokenBlocks;
    private boolean calculatedBlocks = false;
    private boolean doneX = false;
    private boolean doneY = false;
    private boolean doneZ = false;
    private int countX = 0;
    private int countY = 0;
    private int countZ = 0;
    private int deadRayCount = 0;
    private boolean endEarly = false;
    public static final double HARDNESS_MULTIPLIER = 0.3;
    public static final double HARDNESS_OFFSET = 0.315;

    public ExplodingAreaWorker(class_2338 start, class_2338 end, class_2338 originBlock, class_1937 level, Double power, ConcurrentHashMap<class_2338, Float> hardnessMap, Double decay) {
        this.start = start;
        this.end = end;
        this.origin = new Vector3d((double)originBlock.method_10263() + 0.5, (double)originBlock.method_10264() + 0.5, (double)originBlock.method_10260() + 0.5);
        this.level = level;
        this.power = power;
        this.decay = decay;
        this.hardnessMap = hardnessMap;
        this.maxDistance = (this.power - this.decay - 0.315) / 0.315;
        this.brokenBlocks = new PriorityBlockingQueue();
        this.removeBlocks = new PriorityBlockingQueue();
    }

    @Override
    public void run() {
        boolean includeUpperZ;
        boolean includeLowerX = this.origin.x - (double)this.start.method_10263() - 0.5 >= (double)((int)this.maxDistance);
        boolean includeUpperX = (double)this.end.method_10263() + 0.5 - this.origin.x >= (double)((int)this.maxDistance - 1);
        boolean includeLowerY = this.origin.y - (double)this.start.method_10264() - 0.5 >= (double)((int)this.maxDistance);
        boolean includeUpperY = (double)this.end.method_10264() + 0.5 - this.origin.y >= (double)((int)this.maxDistance - 1);
        boolean includeLowerZ = this.origin.z - (double)this.start.method_10260() - 0.5 >= (double)((int)this.maxDistance);
        boolean bl = includeUpperZ = (double)this.end.method_10260() + 0.5 - this.origin.z >= (double)((int)this.maxDistance - 1);
        while (!(this.doneX && this.doneY && this.doneZ)) {
            if (this.endEarly) {
                return;
            }
            if (this.deadRayCount > 20) {
                this.doneX = true;
                this.doneY = true;
                this.doneZ = true;
                break;
            }
            this.processX(includeLowerX, includeUpperX);
            this.processY(includeLowerY, includeUpperY);
            this.processZ(includeLowerZ, includeUpperZ);
        }
        this.calculatedBlocks = true;
    }

    private void processX(boolean includeLowerX, boolean includeUpperX) {
        if (this.doneX) {
            return;
        }
        if (includeLowerX || includeUpperX) {
            if ((double)this.countX >= this.maxDistance * this.maxDistance) {
                this.doneX = true;
            }
            ++this.countX;
            int z = (int)(Math.random() * (double)(this.end.method_10260() - this.start.method_10260())) + this.start.method_10260();
            int y = (int)(Math.random() * (double)(this.end.method_10264() - this.start.method_10264())) + this.start.method_10264();
            if (includeLowerX) {
                this.traverseBlock(new class_2338(this.start.method_10263(), y, z));
            }
            if (includeUpperX) {
                this.traverseBlock(new class_2338(this.end.method_10263(), y, z));
            }
            return;
        }
        this.doneX = true;
    }

    private void processY(boolean includeLowerY, boolean includeUpperY) {
        if (this.doneY) {
            return;
        }
        if (includeLowerY || includeUpperY) {
            if ((double)this.countY >= this.maxDistance * this.maxDistance) {
                this.doneY = true;
            }
            ++this.countY;
            int x = (int)(Math.random() * (double)(this.end.method_10263() - this.start.method_10263())) + this.start.method_10263();
            int z = (int)(Math.random() * (double)(this.end.method_10260() - this.start.method_10260())) + this.start.method_10260();
            if (includeLowerY) {
                this.traverseBlock(new class_2338(x, this.start.method_10264(), z));
            }
            if (includeUpperY) {
                this.traverseBlock(new class_2338(x, this.end.method_10264(), z));
            }
            return;
        }
        this.doneY = true;
    }

    private void processZ(boolean includeLowerZ, boolean includeUpperZ) {
        if (this.doneZ) {
            return;
        }
        if (includeLowerZ || includeUpperZ) {
            if ((double)this.countZ >= this.maxDistance * this.maxDistance) {
                this.doneZ = true;
            }
            ++this.countZ;
            int x = (int)(Math.random() * (double)(this.end.method_10263() - this.start.method_10263())) + this.start.method_10263();
            int y = (int)(Math.random() * (double)(this.end.method_10264() - this.start.method_10264())) + this.start.method_10264();
            if (includeLowerZ) {
                this.traverseBlock(new class_2338(x, y, this.start.method_10260()));
            }
            if (includeUpperZ) {
                this.traverseBlock(new class_2338(x, y, this.end.method_10260()));
            }
            return;
        }
        this.doneZ = true;
    }

    private void traverseBlock(class_2338 blockPos) {
        if (this.endEarly) {
            return;
        }
        double startPower = (0.8 + Math.random() * 0.2) * this.power;
        AtomicReference<Float> totalHardness = new AtomicReference<Float>(Float.valueOf(0.0f));
        AtomicReference<Integer> passedCount = new AtomicReference<Integer>(0);
        ++this.deadRayCount;
        AtomicInteger blocksRemoved = new AtomicInteger();
        Util.traverseSupercover(this.origin, new Vector3d((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5), traversedPos -> {
            if (this.endEarly) {
                return true;
            }
            double distance = traversedPos.distance((Vector3dc)this.origin);
            if (distance > this.maxDistance) {
                return true;
            }
            class_2338 traversedBlockPos = class_2338.method_49637((double)traversedPos.x, (double)traversedPos.y, (double)traversedPos.z);
            boolean alreadyCalculated = this.hardnessMap.containsKey(traversedBlockPos);
            float hardness = this.hardnessMap.computeIfAbsent(traversedBlockPos, p -> Float.valueOf(ExplosionResistanceOverrides.getResistance(this.level.method_8320(p).method_26204()))).floatValue();
            totalHardness.updateAndGet(current -> Float.valueOf(current.floatValue() + hardness));
            passedCount.updateAndGet(a -> {
                a = a + 1;
                return a;
            });
            if (!alreadyCalculated) {
                int passedBlocks = Math.max((Integer)passedCount.get(), 1);
                double averageHardness = (double)((Float)totalHardness.get()).floatValue() / (double)passedBlocks;
                double powerLeft = startPower - (0.3 * averageHardness + 0.315 + this.decay) * (distance + 0.3);
                if (powerLeft > 0.0) {
                    blocksRemoved.getAndIncrement();
                    if (Math.random() > 1.0 / startPower) {
                        this.removeBlocks.offer(traversedBlockPos);
                    } else {
                        this.brokenBlocks.offer(traversedBlockPos);
                    }
                } else {
                    return true;
                }
            }
            return false;
        });
        if ((double)blocksRemoved.get() / (double)passedCount.get().intValue() != 0.0) {
            this.deadRayCount = 0;
        }
    }

    public boolean isComplete() {
        return this.calculatedBlocks && this.brokenBlocks.isEmpty() && this.removeBlocks.isEmpty();
    }

    public boolean processBlock(class_1937 level) {
        if (this.endEarly) {
            return false;
        }
        class_2338 blockPos = this.removeBlocks.poll();
        boolean dropBlock = false;
        if (blockPos == null) {
            blockPos = this.brokenBlocks.poll();
            dropBlock = true;
        }
        if (blockPos == null) {
            return false;
        }
        if (level.method_8320(blockPos).method_27852(class_2246.field_10081)) {
            return true;
        }
        if (!dropBlock) {
            level.method_8650(blockPos, true);
            return true;
        }
        class_2680 state = level.method_8320(blockPos);
        if (state.method_26215()) {
            return true;
        }
        class_2586 blockEntity = state.method_31709() ? level.method_8321(blockPos) : null;
        class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)blockPos, (class_2586)blockEntity, null, (class_1799)class_1799.field_8037);
        level.method_8652(blockPos, class_2246.field_10124.method_9564(), 2);
        return true;
    }

    public void endEarly() {
        this.endEarly = true;
    }

    public class_2487 save() {
        class_2487 data = new class_2487();
        data.method_10569("CountX", this.countX);
        data.method_10569("CountY", this.countY);
        data.method_10569("CountZ", this.countZ);
        data.method_10538("BrokenBlocks", this.brokenBlocks.stream().map(class_2338::method_10063).toList());
        data.method_10538("RemoveBlocks", this.removeBlocks.stream().map(class_2338::method_10063).toList());
        return data;
    }

    public void load(class_2487 data) {
        this.countX = data.method_10550("CountX");
        this.countY = data.method_10550("CountY");
        this.countZ = data.method_10550("CountZ");
        this.brokenBlocks = new PriorityBlockingQueue<class_2338>(Arrays.stream(data.method_10565("BrokenBlocks")).mapToObj(class_2338::method_10092).toList());
        this.removeBlocks = new PriorityBlockingQueue<class_2338>(Arrays.stream(data.method_10565("RemoveBlocks")).mapToObj(class_2338::method_10092).toList());
    }
}

