/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.missiles.parts.warheads;

import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;
import net.woukie.createmissiles.missiles.Trajectory;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.Explosion;
import net.woukie.createmissiles.missiles.asyncexplosionhandler.ExplosionHandler;
import net.woukie.createmissiles.missiles.parts.WarheadType;
import org.joml.Vector3d;

public class ExcavatorWarhead
extends WarheadType {
    @Override
    public float getMass() {
        return 22.5f;
    }

    @Override
    public class_2487 saveTo(class_1263 container, class_2487 data) {
        data.method_10569("Charges", this.getInitialCharges());
        data.method_10549("DetonationGap", 0.0);
        return data;
    }

    @Override
    public class_2960 getResourceLocation() {
        return new class_2960("createmissiles", "excavator_warhead");
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"warheads.createmissiles.excavator_warhead");
    }

    @Override
    public void onTick(Trajectory trajectory, MinecraftServer server) {
        class_3218 level = server.method_3847(trajectory.getLevelKey());
        if (level == null || trajectory.getTick() <= 20) {
            return;
        }
        Vector3d end = trajectory.getPosition();
        if (trajectory.getWarheadData().method_10550("Charges") != this.getInitialCharges()) {
            Vector3d start = trajectory.getLastPosition();
            this.detonateLine(new class_243(start.x, start.y, start.z), new class_243(end.x, end.y, end.z), level, trajectory);
        } else {
            class_243 hitPosition = this.hitPosition(trajectory, server);
            if (trajectory.getPosition().y < (double)level.method_31607()) {
                hitPosition = new class_243(trajectory.getPosition().x, trajectory.getPosition().y, trajectory.getPosition().z);
            }
            if (hitPosition != null) {
                this.detonateLine(hitPosition, new class_243(end.x, end.y, end.z), level, trajectory);
            }
        }
        if (trajectory.getWarheadData().method_10550("Charges") <= 0) {
            trajectory.setSpent(true);
        }
    }

    private void detonateLine(class_243 start, class_243 end, class_3218 level, Trajectory trajectory) {
        int charges = trajectory.getWarheadData().method_10550("Charges");
        double detonationGap = trajectory.getWarheadData().method_10574("DetonationGap");
        class_243 totalDistance = end.method_1020(start);
        class_243 stepOffset = totalDistance.method_1029().method_1021((double)this.getStepSize());
        class_243 currentDistance = stepOffset.method_1029().method_1021(detonationGap);
        while (currentDistance.method_1033() < totalDistance.method_1033() && charges > 0) {
            class_243 globalPosition = currentDistance.method_1019(start);
            level.method_8396(null, class_2338.method_49638((class_2374)globalPosition), class_3417.field_15152, class_3419.field_15251, 10.0f, 1.0f);
            ExplosionHandler.get().createExplosion(new Explosion((class_1937)level, globalPosition, this.getExplosionPower()));
            trajectory.getWarheadData().method_10569("Charges", --charges);
            currentDistance = currentDistance.method_1019(stepOffset);
        }
        detonationGap = totalDistance.method_1020(currentDistance).method_1033();
        trajectory.getWarheadData().method_10549("DetonationGap", detonationGap);
    }

    protected int getInitialCharges() {
        return 30;
    }

    protected float getStepSize() {
        return 1.5f;
    }

    protected double getExplosionPower() {
        return 5.0;
    }
}

