/*
 * Decompiled with CFR 0.152.
 */
package net.woukie.createmissiles.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Optional;
import java.util.ServiceLoader;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.woukie.createmissiles.CreateMissiles;
import net.woukie.createmissiles.entity.drone.Drone;
import net.woukie.createmissiles.entity.drone.ReinforcedDrone;
import net.woukie.createmissiles.item.BiomeVialItem;
import net.woukie.createmissiles.item.BoundEnderPearlItem;
import net.woukie.createmissiles.item.DroneBoxItem;
import net.woukie.createmissiles.registry.EntityTypes;

public abstract class Items {
    public static final DeferredRegister<class_1792> ITEMS = DeferredRegister.create((String)"createmissiles", (class_5321)class_7924.field_41197);
    public static final RegistrySupplier<class_1792> WARHEAD_ASSEMBLY;
    public static final RegistrySupplier<class_1792> CHASSIS_ASSEMBLY;
    public static final RegistrySupplier<class_1792> THRUSTER_ASSEMBLY;
    public static final RegistrySupplier<class_1792> BOUND_ENDER_PEARL;
    public static final RegistrySupplier<class_1792> DRONE_BOX_ITEM;
    public static final RegistrySupplier<class_1792> REINFORCED_DRONE_BOX;
    public static final RegistrySupplier<class_1792> DRAGON_EGG_SHELL;
    public static final RegistrySupplier<BiomeVialItem> BIOME_VIAL;
    public static final RegistrySupplier<class_1792> REINFORCED_DRAGON_EGG_SHELL;
    public static final RegistrySupplier<class_1792> INCOMPLETE_BASIC_DRONE_BOX;
    public static final RegistrySupplier<class_1792> INCOMPLETE_REINFORCED_DRONE_BOX;
    public static final RegistrySupplier<class_1792> FIREWORK_UPGRADE_CORE;
    public static final RegistrySupplier<class_1792> FLAMING_UPGRADE_CORE;
    public static final RegistrySupplier<class_1792> EXCAVATOR_UPGRADE_CORE;
    public static final RegistrySupplier<class_1792> FROST_UPGRADE_CORE;

    protected abstract RegistrySupplier<class_1792> getWarheadAssembly();

    protected abstract RegistrySupplier<class_1792> getChassisAssembly();

    protected abstract RegistrySupplier<class_1792> getThrusterAssembly();

    public static void init() {
        CreateMissiles.LOGGER.info("Registering items for Create Missiles");
        ITEMS.register();
    }

    static {
        BOUND_ENDER_PEARL = ITEMS.register("bound_ender_pearl", () -> new BoundEnderPearlItem(new class_1792.class_1793()));
        DRONE_BOX_ITEM = ITEMS.register("basic_drone_box", () -> new DroneBoxItem(new class_1792.class_1793(), level -> new Drone((class_1299<? extends Drone>)((class_1299)EntityTypes.BASIC_DRONE.get()), (class_1937)level)));
        REINFORCED_DRONE_BOX = ITEMS.register("reinforced_drone_box", () -> new DroneBoxItem(new class_1792.class_1793(), level -> new ReinforcedDrone((class_1299<? extends Drone>)((class_1299)EntityTypes.REINFORCED_DRONE.get()), (class_1937)level)));
        DRAGON_EGG_SHELL = ITEMS.register("dragon_egg_shell", () -> new class_1792(new class_1792.class_1793()));
        BIOME_VIAL = ITEMS.register("biome_vial", () -> new BiomeVialItem(new class_1792.class_1793()));
        REINFORCED_DRAGON_EGG_SHELL = ITEMS.register("reinforced_dragon_egg_shell", () -> new class_1792(new class_1792.class_1793()));
        INCOMPLETE_BASIC_DRONE_BOX = ITEMS.register("incomplete_basic_drone_box", () -> new class_1792(new class_1792.class_1793()));
        INCOMPLETE_REINFORCED_DRONE_BOX = ITEMS.register("incomplete_reinforced_drone_box", () -> new class_1792(new class_1792.class_1793()));
        FIREWORK_UPGRADE_CORE = ITEMS.register("firework_upgrade_core", () -> new class_1792(new class_1792.class_1793()));
        FLAMING_UPGRADE_CORE = ITEMS.register("flaming_upgrade_core", () -> new class_1792(new class_1792.class_1793()));
        EXCAVATOR_UPGRADE_CORE = ITEMS.register("excavator_upgrade_core", () -> new class_1792(new class_1792.class_1793()));
        FROST_UPGRADE_CORE = ITEMS.register("frost_upgrade_core", () -> new class_1792(new class_1792.class_1793()));
        Optional<Items> items = ServiceLoader.load(Items.class).findFirst();
        if (items.isPresent()) {
            WARHEAD_ASSEMBLY = items.get().getWarheadAssembly();
            CHASSIS_ASSEMBLY = items.get().getChassisAssembly();
            THRUSTER_ASSEMBLY = items.get().getThrusterAssembly();
        } else {
            WARHEAD_ASSEMBLY = null;
            CHASSIS_ASSEMBLY = null;
            THRUSTER_ASSEMBLY = null;
        }
    }
}

