/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.DirectStaticAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MirrorAnimation
extends StaticAnimation {
    public DirectStaticAnimation original;
    public DirectStaticAnimation mirror;

    public MirrorAnimation(float transitionTime, boolean repeatPlay, AnimationManager.AnimationAccessor<? extends MirrorAnimation> accessor, String path1, String path2, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, false, accessor, armature);
        this.original = new DirectStaticAnimation(transitionTime, repeatPlay, ResourceLocation.fromNamespaceAndPath((String)accessor.registryName().m_135827_(), (String)path1), armature);
        this.mirror = new DirectStaticAnimation(transitionTime, repeatPlay, ResourceLocation.fromNamespaceAndPath((String)accessor.registryName().m_135827_(), (String)path2), armature);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (entitypatch.isLogicalClient()) {
            DirectStaticAnimation animation = this.checkHandAndReturnAnimation(((LivingEntity)entitypatch.getOriginal()).m_7655_());
            entitypatch.getClientAnimator().playAnimation(animation, 0.0f);
        }
    }

    @Override
    public List<AssetAccessor<? extends StaticAnimation>> getSubAnimations() {
        return List.of(this.original, this.mirror);
    }

    @Override
    public boolean isMetaAnimation() {
        return true;
    }

    @Override
    public boolean isClientAnimation() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.Priority getPriority() {
        return this.original.getProperty(ClientAnimationProperties.PRIORITY).orElse(Layer.Priority.LOWEST);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Layer.LayerType getLayerType() {
        return this.original.getProperty(ClientAnimationProperties.LAYER_TYPE).orElse(Layer.LayerType.BASE_LAYER);
    }

    private DirectStaticAnimation checkHandAndReturnAnimation(InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return this.mirror;
        }
        return this.original;
    }
}

