/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.gui.datapack.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.datapack.EditorAnimation;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.screen.MessageScreen;
import yesman.epicfight.client.gui.datapack.widgets.ComboBox;
import yesman.epicfight.client.gui.datapack.widgets.Grid;
import yesman.epicfight.client.gui.datapack.widgets.InputComponentList;
import yesman.epicfight.client.gui.datapack.widgets.ModelPreviewer;
import yesman.epicfight.client.gui.datapack.widgets.ResizableComponent;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.client.gui.datapack.widgets.Static;

@OnlyIn(value=Dist.CLIENT)
public class AttackAnimationPropertyScreen
extends Screen {
    private final Screen parentScreen;
    private final EditorAnimation animation;
    private final Grid trailGrid;
    private final InputComponentList<JsonObject> inputComponentsList;
    private final ResizableEditBox startTime;
    private final ResizableEditBox endTime;
    private final ComboBox<Joint> joint;
    private final ComboBox<InteractionHand> hand;
    private final ResizableEditBox interpolations;
    private final ResizableEditBox lifetime;
    private final ModelPreviewer modelPlayer;
    private JsonArray trailList = new JsonArray();

    protected AttackAnimationPropertyScreen(Screen parentScreen, EditorAnimation animation, List<Joint> joints, ModelPreviewer modelPlayer) {
        super((Component)Component.m_237115_((String)"datapack_edit.import_animation.client_data"));
        this.parentScreen = parentScreen;
        this.f_96541_ = parentScreen.getMinecraft();
        this.f_96547_ = parentScreen.getMinecraft().f_91062_;
        this.animation = animation;
        this.modelPlayer = modelPlayer;
        this.inputComponentsList = new InputComponentList<JsonObject>((Screen)this, 0, 0, 0, 0, 30){

            @Override
            public void importTag(JsonObject tag) {
                this.setComponentsActive(true);
                this.setDataBindingComponenets(new Object[]{ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(tag.get("start_time"), JsonElement::getAsString)), ParseUtil.valueOfOmittingType(ParseUtil.nullOrToString(tag.get("end_time"), JsonElement::getAsString)), ParseUtil.nullOrApply(tag.get("joint"), jsonElement -> AttackAnimationPropertyScreen.this.modelPlayer.getArmature().get().searchJointByName(jsonElement.getAsString())), ParseUtil.nullOrApply(tag.get("item_skin_hand"), jsonElement -> InteractionHand.valueOf((String)jsonElement.getAsString().toUpperCase(Locale.ROOT))), ParseUtil.nullParam(ParseUtil.nullOrToString(tag.get("interpolations"), JsonElement::getAsString)), ParseUtil.nullParam(ParseUtil.nullOrToString(tag.get("lifetime"), JsonElement::getAsString))});
            }
        };
        ScreenRectangle screenRect = this.m_264198_();
        this.trailGrid = Grid.builder(parentScreen, parentScreen.getMinecraft()).xy1(15, 48).xy2(100, 50).verticalSizing(ResizableComponent.VerticalSizing.TOP_BOTTOM).rowHeight(26).rowEditable(Grid.GridBuilder.RowEditButton.ADD_REMOVE).transparentBackground(false).rowpositionChanged((rowposition, values) -> this.inputComponentsList.importTag(this.trailList.get(rowposition.intValue()).getAsJsonObject())).addColumn(Grid.editbox("trail").editable(false).width(200)).pressAdd((grid, button) -> {
            this.trailList.add((JsonElement)new JsonObject());
            int rowposition = grid.addRowWithDefaultValues("trail", String.format("Trail%d", grid.m_6702_().size()));
            grid.setGridFocus(rowposition, "trail");
        }).pressRemove((grid, button) -> grid.removeRow(removedRow -> this.trailList.remove(removedRow))).build();
        this.startTime = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.client_data.start_time"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
        this.endTime = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.import_animation.client_data.end_time"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
        this.interpolations = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.item_capability.interpolations"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
        this.lifetime = new ResizableEditBox(this.f_96547_, 0, 35, 0, 15, (Component)Component.m_237115_((String)"datapack_edit.item_capability.lifetime"), ResizableComponent.HorizontalSizing.LEFT_WIDTH, null);
        this.joint = new ComboBox<Joint>(this, this.f_96547_, 0, 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.m_237115_((String)"datapack_edit.import_animation.joint"), joints, Joint::getName, joint -> {
            JsonObject trailObj = this.trailList.get(this.trailGrid.getRowposition()).getAsJsonObject();
            if (joint != null) {
                trailObj.addProperty("joint", joint.getName());
            } else {
                trailObj.remove("joint");
            }
        });
        this.hand = new ComboBox<InteractionHand>(this, this.f_96547_, 0, 124, 100, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, 8, (Component)Component.m_237115_((String)"datapack_edit.import_animation.hand"), List.of(InteractionHand.MAIN_HAND, InteractionHand.OFF_HAND), ParseUtil::snakeToSpacedCamel, hand -> {
            JsonObject trailObj = this.trailList.get(this.trailGrid.getRowposition()).getAsJsonObject();
            if (hand != null) {
                trailObj.addProperty("item_skin_hand", hand.toString().toLowerCase(Locale.ROOT));
            } else {
                trailObj.remove("item_skin_hand");
            }
        });
        this.startTime.m_94151_(value -> {
            JsonObject trailObj = this.trailList.get(this.trailGrid.getRowposition()).getAsJsonObject();
            if (!StringUtil.isNullOrEmpty((String)value)) {
                trailObj.addProperty("start_time", (Number)Float.valueOf(Float.parseFloat(value)));
            } else {
                trailObj.remove("start_time");
            }
        });
        this.endTime.m_94151_(value -> {
            JsonObject trailObj = this.trailList.get(this.trailGrid.getRowposition()).getAsJsonObject();
            if (!StringUtil.isNullOrEmpty((String)value)) {
                trailObj.addProperty("end_time", (Number)Float.valueOf(Float.parseFloat(value)));
            } else {
                trailObj.remove("end_time");
            }
        });
        this.interpolations.m_94151_(value -> {
            JsonObject trailObj = this.trailList.get(this.trailGrid.getRowposition()).getAsJsonObject();
            if (!StringUtil.isNullOrEmpty((String)value)) {
                trailObj.addProperty("interpolations", (Number)Integer.parseInt(value));
            } else {
                trailObj.remove("interpolations");
            }
        });
        this.lifetime.m_94151_(value -> {
            JsonObject trailObj = this.trailList.get(this.trailGrid.getRowposition()).getAsJsonObject();
            if (!StringUtil.isNullOrEmpty((String)value)) {
                trailObj.addProperty("lifetime", (Number)Integer.parseInt(value));
            } else {
                trailObj.remove("lifetime");
            }
        });
        this.startTime.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
        this.endTime.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Float::parseFloat));
        this.interpolations.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
        this.lifetime.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable(context, Integer::parseInt));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(4), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.model_player.trail"));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(12), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.client_data.start_time"));
        this.inputComponentsList.addComponentCurrentRow(this.startTime.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(12), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.client_data.end_time"));
        this.inputComponentsList.addComponentCurrentRow(this.endTime.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(12), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.client_data.joint"));
        this.inputComponentsList.addComponentCurrentRow(this.joint.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(12), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.import_animation.hand"));
        this.inputComponentsList.addComponentCurrentRow(this.hand.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(12), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.interpolations"));
        this.inputComponentsList.addComponentCurrentRow(this.interpolations.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
        this.inputComponentsList.newRow();
        this.inputComponentsList.addComponentCurrentRow(new Static((Screen)this, this.inputComponentsList.nextStart(12), 80, 60, 15, ResizableComponent.HorizontalSizing.LEFT_WIDTH, null, "datapack_edit.item_capability.lifetime"));
        this.inputComponentsList.addComponentCurrentRow(this.lifetime.relocateX(screenRect, this.inputComponentsList.nextStart(5)));
        this.inputComponentsList.setComponentsActive(false);
        if (animation.getPropertiesJson().has("trail_effects")) {
            JsonArray array;
            this.trailList = array = animation.getPropertiesJson().get("trail_effects").getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                this.trailGrid.addRowWithDefaultValues("trail", String.format("Trail%d", i));
            }
        }
    }

    protected void m_7856_() {
        ScreenRectangle screenRect = this.m_264198_();
        this.inputComponentsList.m_93437_(screenRect.f_263770_() - 125, screenRect.f_263800_() - 68, screenRect.m_274449_() + 32, screenRect.m_274349_() - 48);
        this.inputComponentsList.m_93507_(125);
        this.trailGrid.resize(screenRect);
        this.m_142416_(this.trailGrid);
        this.m_142416_((GuiEventListener)this.inputComponentsList);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_286989_, button -> {
            try {
                this.save();
                this.m_7379_();
            }
            catch (IllegalStateException e) {
                this.f_96541_.m_91152_(new MessageScreen("Failed to save", e.getMessage(), this, button3 -> this.f_96541_.m_91152_((Screen)this), 300, 70).autoCalculateHeight());
            }
        }).m_252794_(this.f_96543_ / 2 - 162, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, button -> this.f_96541_.m_91152_(new MessageScreen("", "Do you want to quit without saving changes?", this, button2 -> this.m_7379_(), button2 -> this.f_96541_.m_91152_((Screen)this), 180, 70))).m_252794_(this.f_96543_ / 2 + 2, this.f_96544_ - 28).m_253046_(160, 21).m_253136_());
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.parentScreen);
    }

    public void save() throws IllegalStateException {
        int i = 0;
        JsonArray jsonArr = new JsonArray();
        TrailInfo[] trailArr = new TrailInfo[this.trailList.size()];
        for (JsonElement element : this.trailList) {
            JsonObject trailObj = element.getAsJsonObject();
            if (!trailObj.has("start_time")) {
                throw new IllegalStateException(String.format("Row %d: Start time undefined!", i + 1));
            }
            if (!trailObj.has("end_time")) {
                throw new IllegalStateException(String.format("Row %d: End time undefined!", i + 1));
            }
            if (!trailObj.has("joint")) {
                throw new IllegalStateException(String.format("Row %d: Joint undefined!", i + 1));
            }
            if (this.modelPlayer.getArmature().get().searchJointByName(trailObj.get("joint").getAsString()) == null) {
                throw new IllegalStateException(String.format("Row %d: No joint named %s in %s!", i + 1, trailObj.get("joint").getAsString(), this.modelPlayer.getArmature()));
            }
            if (!trailObj.has("item_skin_hand")) {
                throw new IllegalStateException(String.format("Row %d: Hand undefined!", i + 1));
            }
            TrailInfo.Builder builder = TrailInfo.builder().time(trailObj.get("start_time").getAsFloat(), trailObj.get("end_time").getAsFloat()).joint(trailObj.get("joint").getAsString()).itemSkinHand(InteractionHand.valueOf((String)trailObj.get("item_skin_hand").getAsString().toUpperCase(Locale.ROOT)));
            if (trailObj.has("lifetime")) {
                builder.lifetime(trailObj.get("lifetime").getAsInt());
            }
            if (trailObj.has("interpolations")) {
                builder.interpolations(trailObj.get("interpolations").getAsInt());
            }
            trailArr[i] = TrailInfo.PREVIEWER_DEFAULT_TRAIL.overwrite(builder.create());
            jsonArr.add(element);
            ++i;
        }
        this.animation.getPropertiesJson().asMap().clear();
        this.animation.getPropertiesJson().add("trail_effects", (JsonElement)jsonArr);
        this.modelPlayer.setTrailInfo(trailArr);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dx, double dy) {
        if (this.inputComponentsList.m_7979_(mouseX, mouseY, button, dx, dy)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dx, dy);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280039_(guiGraphics);
        int yBegin = 32;
        int yEnd = this.f_96544_ - 45;
        guiGraphics.m_280430_(this.f_96547_, this.f_96539_, 20, 16, 0xFFFFFF);
        guiGraphics.m_280246_(0.125f, 0.125f, 0.125f, 1.0f);
        guiGraphics.m_280163_(Screen.f_279548_, 0, yBegin, (float)this.f_96543_, (float)yEnd - (float)yBegin, this.f_96543_, yEnd, 32, 32);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.m_280163_(Screen.f_279548_, 0, 0, 0.0f, 0.0f, this.f_96543_, yBegin, 32, 32);
        guiGraphics.m_280163_(Screen.f_279548_, 0, yEnd, 0.0f, (float)yEnd - (float)yBegin, this.f_96543_, yEnd, 32, 32);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_285978_(RenderType.m_286086_(), 0, yBegin, this.f_96543_, yBegin + 4, -16777216, 0, 0);
        guiGraphics.m_285978_(RenderType.m_286086_(), 0, yEnd, this.f_96543_, yEnd + 1, 0, -16777216, 0);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum LayerOptions {
        BASE_LAYER,
        COMPOSITE_LAYER,
        MULTILAYER;

    }
}

