/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.renderer.shader.compute;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL46C;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.client.model.VertexBuilder;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.client.renderer.shader.compute.backend.buffers.IArrayBufferProxy;
import yesman.epicfight.client.renderer.shader.compute.loader.ComputeShaderProvider;

@OnlyIn(value=Dist.CLIENT)
public interface ComputeShaderSetup {
    public static final int WORK_GROUP_SIZE = 128;
    public static final OpenMatrix4f[] TOTAL_POSES = OpenMatrix4f.allocateMatrixArray(1000);
    public static final OpenMatrix4f[] TOTAL_NORMALS = OpenMatrix4f.allocateMatrixArray(1000);
    public static final IArrayBufferProxy POSE_BO = ComputeShaderProvider.createDynamicBuffer(TOTAL_POSES, 16, OpenMatrix4f::store);

    public static void setShaderDefaultUniforms(ShaderInstance shader, VertexFormat.Mode mode, Window window) {
        for (int i = 0; i < 12; ++i) {
            int j = RenderSystem.getShaderTexture((int)i);
            shader.m_173350_("Sampler" + i, (Object)j);
        }
        if (shader.f_173308_ != null) {
            shader.f_173308_.m_5679_(RenderSystem.getModelViewMatrix());
        }
        if (shader.f_173309_ != null) {
            shader.f_173309_.m_5679_(RenderSystem.getProjectionMatrix());
        }
        if (shader.f_200956_ != null) {
            shader.f_200956_.m_200759_(RenderSystem.getInverseViewRotationMatrix());
        }
        if (shader.f_173312_ != null) {
            shader.f_173312_.m_5941_(RenderSystem.getShaderColor());
        }
        if (shader.f_267422_ != null) {
            shader.f_267422_.m_5985_(RenderSystem.getShaderGlintAlpha());
        }
        if (shader.f_173315_ != null) {
            shader.f_173315_.m_5985_(RenderSystem.getShaderFogStart());
        }
        if (shader.f_173316_ != null) {
            shader.f_173316_.m_5985_(RenderSystem.getShaderFogEnd());
        }
        if (shader.f_173317_ != null) {
            shader.f_173317_.m_5941_(RenderSystem.getShaderFogColor());
        }
        if (shader.f_202432_ != null) {
            shader.f_202432_.m_142617_(RenderSystem.getShaderFogShape().m_202324_());
        }
        if (shader.f_173310_ != null) {
            shader.f_173310_.m_5679_(RenderSystem.getTextureMatrix());
        }
        if (shader.f_173319_ != null) {
            shader.f_173319_.m_5985_(RenderSystem.getShaderGameTime());
        }
        if (shader.f_173311_ != null) {
            shader.f_173311_.m_7971_((float)window.m_85441_(), (float)window.m_85442_());
        }
        if (shader.f_173318_ != null && (mode == VertexFormat.Mode.LINES || mode == VertexFormat.Mode.LINE_STRIP)) {
            shader.f_173318_.m_5985_(RenderSystem.getShaderLineWidth());
        }
        RenderSystem.setupShaderLights((ShaderInstance)shader);
    }

    public static void bindAttrPointer(int vao, int size, int bindingPos, int glType) {
        GL46C.glBindBuffer((int)34962, (int)vao);
        GL46C.glVertexAttribPointer((int)bindingPos, (int)size, (int)glType, (boolean)false, (int)0, (long)0L);
        GL46C.glEnableVertexAttribArray((int)bindingPos);
    }

    public static void bindAttrPointer(int vao, int size, int bindingPos, int glType, int stride) {
        GL46C.glBindBuffer((int)34962, (int)vao);
        GL46C.glVertexAttribPointer((int)bindingPos, (int)size, (int)glType, (boolean)false, (int)stride, (long)0L);
        GL46C.glEnableVertexAttribArray((int)bindingPos);
    }

    public static void bindIntAttrPointer(int vao, int size, int bindingPos, int glType, int stride) {
        GL46C.glBindBuffer((int)34962, (int)vao);
        GL46C.glVertexAttribIPointer((int)bindingPos, (int)size, (int)glType, (int)stride, (long)0L);
        GL46C.glEnableVertexAttribArray((int)bindingPos);
    }

    public static void clearBufferState(VertexFormat vertexFormat) {
        vertexFormat.m_86024_();
    }

    public void bindBufferFormat(VertexFormat var1, int ... var2);

    public void applyComputeShader(PoseStack var1, OpenMatrix4f var2, float var3, float var4, float var5, float var6, int var7, int var8, int var9);

    public void drawWithShader(SkinnedMesh var1, PoseStack var2, MultiBufferSource var3, RenderType var4, int var5, float var6, float var7, float var8, float var9, int var10, @Nullable Armature var11, OpenMatrix4f[] var12);

    public int vaoId();

    public int vertexCount();

    public void destroyBuffers();

    @OnlyIn(value=Dist.CLIENT)
    public static class PartBuffer
    implements MeshPartBuffer {
        private final int partIdx;

        public PartBuffer(List<VertexBuilder> vertexBuilders, Map<VertexBuilder, Integer> vertexBuilderMap, float[] uvs, List<Float> uvList, List<ElemInfo> elements, int partIdx) {
            this.partIdx = partIdx;
            for (VertexBuilder vb : vertexBuilders) {
                if (!vertexBuilderMap.containsKey(vb)) {
                    int next = vertexBuilderMap.size();
                    vertexBuilderMap.put(vb, next);
                    uvList.add(Float.valueOf(uvs[vb.uv * 2]));
                    uvList.add(Float.valueOf(uvs[vb.uv * 2 + 1]));
                }
                int vertexPoolIndex = vertexBuilderMap.get(vb);
                elements.add(new ElemInfo(vertexPoolIndex, partIdx));
            }
        }

        @Override
        public int vboId() {
            return -1;
        }

        @Override
        public int partIdx() {
            return this.partIdx;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record ElemInfo(int poolId, int partId) implements BufferUploadable
    {
        @Override
        public void store(FloatBuffer buffer) {
            buffer.put(Float.intBitsToFloat(this.poolId));
            buffer.put(Float.intBitsToFloat(this.partId));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public record VertexObj(float px, float py, float pz, float nx, float ny, float nz, int jts, int jte) implements BufferUploadable
    {
        @Override
        public void store(FloatBuffer floatBuffer) {
            floatBuffer.put(this.px);
            floatBuffer.put(this.py);
            floatBuffer.put(this.pz);
            floatBuffer.put(this.nx);
            floatBuffer.put(this.ny);
            floatBuffer.put(this.nz);
            floatBuffer.put(Float.intBitsToFloat(this.jts));
            floatBuffer.put(Float.intBitsToFloat(this.jte));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface MeshPartBuffer {
        public int vboId();

        public int partIdx();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface BufferUploadable {
        public void store(FloatBuffer var1);
    }
}

