/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.compat;

import java.lang.reflect.Constructor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingException;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import yesman.epicfight.main.EpicFightMod;

public interface ICompatModule {
    public static void loadCompatModule(FMLJavaModLoadingContext context, Class<? extends ICompatModule> compatModule) {
        try {
            Constructor<? extends ICompatModule> constructor = compatModule.getConstructor(new Class[0]);
            ICompatModule compatModuleInstance = constructor.newInstance(new Object[0]);
            compatModuleInstance.onModEventBus(context.getModEventBus());
            compatModuleInstance.onForgeEventBus(MinecraftForge.EVENT_BUS);
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                compatModuleInstance.onModEventBusClient(context.getModEventBus());
                compatModuleInstance.onForgeEventBusClient(MinecraftForge.EVENT_BUS);
            });
            EpicFightMod.LOGGER.info("Loaded mod compat: " + compatModule.getSimpleName());
        }
        catch (ModLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            EpicFightMod.LOGGER.error("Failed to load mod compat: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void onModEventBus(IEventBus var1);

    public void onForgeEventBus(IEventBus var1);

    @OnlyIn(value=Dist.CLIENT)
    public void onModEventBusClient(IEventBus var1);

    @OnlyIn(value=Dist.CLIENT)
    public void onForgeEventBusClient(IEventBus var1);
}

