/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.guard;

import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataKeys;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class ParryingSkill
extends GuardSkill {
    private int PARRY_WINDOW;

    public static GuardSkill.Builder createActiveGuardBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion(CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> itemCap.getStyle((LivingEntityPatch<?>)playerpatch) == CapabilityItem.Styles.ONE_HAND ? List.of(Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2) : List.of(Animations.SWORD_GUARD_ACTIVE_HIT2, Animations.SWORD_GUARD_ACTIVE_HIT3)).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> List.of(Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2)).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> List.of(Animations.SWORD_GUARD_ACTIVE_HIT1, Animations.SWORD_GUARD_ACTIVE_HIT2)).addAdvancedGuardMotion(CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> List.of(Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2));
    }

    public ParryingSkill(GuardSkill.Builder builder) {
        super(builder);
    }

    @Override
    public void startHolding(SkillContainer container) {
        super.startHolding(container);
        if (container.getExecutor().isLogicalClient()) {
            return;
        }
        int lastActive = (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.LAST_ACTIVE.get());
        if (((ServerPlayer)container.getServerExecutor().getOriginal()).f_19797_ - lastActive > this.PARRY_WINDOW * 2) {
            container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.LAST_ACTIVE.get(), ((ServerPlayer)container.getServerExecutor().getOriginal()).f_19797_);
        }
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
    }

    @Override
    public void guard(SkillContainer container, CapabilityItem itemCapability, TakeDamageEvent.Attack event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable((PlayerPatch<?>)event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && this.isBlockableSource(damageSource = event.getDamageSource(), true)) {
            ServerPlayer serverPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            boolean successParrying = serverPlayer.f_19797_ - (Integer)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.LAST_ACTIVE.get()) < this.PARRY_WINDOW;
            float penalty = ((Float)container.getDataManager().getDataValue((SkillDataKey)SkillDataKeys.PENALTY.get())).floatValue();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ((HitParticleType)((Object)EpicFightParticles.HIT_BLUNT.get())).spawnParticleWithArgument(serverPlayer.m_284548_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serverPlayer, damageSource.m_7640_());
            if (successParrying) {
                event.setParried(true);
                penalty = 0.1f;
                knockback *= 0.4f;
                container.getDataManager().setData((SkillDataKey)SkillDataKeys.LAST_ACTIVE.get(), 0);
            } else {
                container.getDataManager().setDataSync((SkillDataKey)SkillDataKeys.PENALTY.get(), Float.valueOf(penalty += this.getPenalizer(itemCapability)));
            }
            Entity entity = damageSource.m_7640_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)livingentity) * 0.1f;
            }
            assert (damageSource.m_7640_() != null);
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            float consumeAmount = penalty * impact;
            boolean canAfford = ((ServerPlayerPatch)event.getPlayerPatch()).consumeForSkill((Skill)this, Skill.Resource.STAMINA, consumeAmount);
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (canAfford ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = this.getGuardMotion(container, (PlayerPatch<?>)event.getPlayerPatch(), itemCapability, blockType);
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, 0.0f);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent((PlayerPatch<?>)event.getPlayerPatch(), event, advanced);
            return;
        }
        super.guard(container, itemCapability, event, knockback, impact, false);
    }

    @Override
    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.m_269533_(DamageTypeTags.f_268524_) && advanced || super.isBlockableSource(damageSource, false);
    }

    @Override
    @Nullable
    protected AnimationManager.AnimationAccessor<? extends StaticAnimation> getGuardMotion(SkillContainer container, PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        List motions;
        AnimationManager.AnimationAccessor<? extends StaticAnimation> animation = itemCapability.getGuardMotion(this, blockType, playerpatch);
        if (animation != null) {
            return animation;
        }
        if (blockType == GuardSkill.BlockType.ADVANCED_GUARD && (motions = (List)this.getGuardMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch)) != null) {
            SkillDataManager dataManager = container.getDataManager();
            int motionCounter = (Integer)dataManager.getDataValue((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get());
            dataManager.setDataF((SkillDataKey)SkillDataKeys.PARRY_MOTION_COUNTER.get(), v -> v + 1);
            return (AnimationManager.AnimationAccessor)motions.get(motionCounter %= motions.size());
        }
        return super.getGuardMotion(container, playerpatch, itemCapability, blockType);
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.PARRY_WINDOW = parameters.m_128451_("parry_window");
        if (this.PARRY_WINDOW <= 0) {
            this.PARRY_WINDOW = 8;
        }
    }

    @Override
    public Skill getPriorSkill() {
        return EpicFightSkills.GUARD;
    }

    @Override
    protected boolean isAdvancedGuard() {
        return true;
    }

    @Override
    public Set<WeaponCategory> getAvailableWeaponCategories() {
        return this.advancedGuardMotions.keySet();
    }
}

