/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.player;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPAddLearnedSkill;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPModifyPlayerData;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.modules.HoldableSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.skill.CapabilitySkill;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.eventlistener.DodgeSuccessEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SetTargetEvent;
import yesman.epicfight.world.entity.eventlistener.TakeDamageEvent;

public class ServerPlayerPatch
extends PlayerPatch<ServerPlayer> {
    private LivingEntity attackTarget;
    private boolean updatedMotionCurrentTick;

    @Override
    public void onJoinWorld(ServerPlayer player, EntityJoinLevelEvent event) {
        super.onJoinWorld(player, event);
        CapabilitySkill skillCapability = this.getSkillCapability();
        EpicFightNetworkManager.PayloadBundleBuilder payloadBundleBuilder = EpicFightNetworkManager.PayloadBundleBuilder.create();
        skillCapability.listSkillContainers().filter(skillContainer -> !skillContainer.isEmpty() && skillContainer.getSkill().getCategory().shouldSynchronize()).forEach(skillContainer -> payloadBundleBuilder.and(skillContainer.createSyncPacketToLocalPlayer()));
        this.eventListeners.addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, PLAYER_EVENT_UUID, playerevent -> {
            if (playerevent.getDamageSource().isBasicAttack()) {
                float value;
                SkillContainer container = this.getSkill(SkillSlots.WEAPON_INNATE);
                ItemStack mainHandItem = ((ServerPlayer)this.getOriginal()).m_21205_();
                if (!container.isFull() && !container.isActivated() && container.hasSkill(EpicFightCapabilities.getItemStackCapability(mainHandItem).getInnateSkill(this, mainHandItem)) && (value = container.getResource() + playerevent.getAttackDamage()) > 0.0f) {
                    container.getSkill().setConsumptionSynchronize(container, value);
                }
            }
        }, 10);
        payloadBundleBuilder.and(new SPAddLearnedSkill(skillCapability.listAcquiredSkills().map(skill -> skill.getRegistryName().toString()).toList().toArray(new String[0])));
        payloadBundleBuilder.and(SPModifyPlayerData.setPlayerMode(((ServerPlayer)this.getOriginal()).m_19879_(), this.playerMode));
        payloadBundleBuilder.send((start, others) -> EpicFightNetworkManager.sendToPlayer(start, (ServerPlayer)this.original, others));
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        EpicFightNetworkManager.PayloadBundleBuilder payloadBundleBuilder = EpicFightNetworkManager.PayloadBundleBuilder.create();
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.getOriginal()).m_19879_());
        msg.putEntries(((Animator)this.getAnimator()).getLivingAnimations().entrySet());
        payloadBundleBuilder.and(msg);
        this.getSkillCapability().listSkillContainers().filter(skillContainer -> !skillContainer.isEmpty() && skillContainer.getSkill().getCategory().shouldSynchronize()).forEach(skillContainer -> {
            payloadBundleBuilder.and(skillContainer.createSyncPacketToRemotePlayer());
            skillContainer.getDataManager().onTracked(payloadBundleBuilder);
            skillContainer.getSkill().onTracked((SkillContainer)skillContainer, payloadBundleBuilder);
        });
        payloadBundleBuilder.and(SPModifyPlayerData.setPlayerMode(((ServerPlayer)this.getOriginal()).m_19879_(), this.playerMode));
        payloadBundleBuilder.send((first, others) -> EpicFightNetworkManager.sendToPlayer(first, trackingPlayer, others));
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        this.updatedMotionCurrentTick = false;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
    }

    @Override
    public void updateHeldItem(CapabilityItem fromCap, CapabilityItem toCap, ItemStack from, ItemStack to, InteractionHand hand) {
        if (this.isHoldingAny()) {
            this.getSkillContainerFor(this.holdingSkill.asSkill()).ifPresent(container -> {
                container.getSkill().cancelOnServer((SkillContainer)container, null);
                EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.expired(container.getSlotId()), (ServerPlayer)this.original, new Object[0]);
            });
            this.resetHolding();
        }
        if (this.isHoldingAny()) {
            this.resetHolding();
        }
        CapabilityItem mainHandCap = hand == InteractionHand.MAIN_HAND ? toCap : this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        mainHandCap.changeWeaponInnateSkill(this, hand == InteractionHand.MAIN_HAND ? to : ((ServerPlayer)this.original).m_21205_());
        if (hand == InteractionHand.OFF_HAND) {
            Multimap<Attribute, AttributeModifier> modifiers;
            if (!from.m_41619_()) {
                modifiers = from.m_41638_(EquipmentSlot.MAINHAND);
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!fromCap.isEmpty()) {
                modifiers = fromCap.getAllAttributeModifiers(EquipmentSlot.MAINHAND);
                modifiers.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22130_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22130_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22130_(arg_0));
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22130_(arg_0));
            }
            if (!to.m_41619_()) {
                modifiers = to.m_41638_(EquipmentSlot.MAINHAND);
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
            if (!toCap.isEmpty()) {
                modifiers = toCap.getAttributeModifiers(EquipmentSlot.MAINHAND, this);
                modifiers.get((Object)((Attribute)EpicFightAttributes.ARMOR_NEGATION.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get())).m_22118_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.IMPACT.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get())).m_22118_(arg_0));
                modifiers.get((Object)((Attribute)EpicFightAttributes.MAX_STRIKES.get())).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get())).m_22118_(arg_0));
                modifiers.get((Object)Attributes.f_22283_).forEach(arg_0 -> ((AttributeInstance)((ServerPlayer)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get())).m_22118_(arg_0));
            }
        }
        this.modifyLivingMotionByCurrentItem(true);
        super.updateHeldItem(fromCap, toCap, from, to, hand);
    }

    public void modifyLivingMotionByCurrentItem() {
        this.modifyLivingMotionByCurrentItem(false);
    }

    public void modifyLivingMotionByCurrentItem(boolean checkOldAnimations) {
        if (this.updatedMotionCurrentTick && checkOldAnimations) {
            return;
        }
        Map<LivingMotion, AssetAccessor<? extends StaticAnimation>> oldLivingAnimations = ((Animator)this.getAnimator()).getLivingAnimations();
        HashMap newLivingAnimations = Maps.newHashMap();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> livingMotionModifiers = new HashMap<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>(mainhandCap.getLivingMotionModifier(this, InteractionHand.MAIN_HAND));
        livingMotionModifiers.putAll(offhandCap.getLivingMotionModifier(this, InteractionHand.OFF_HAND));
        for (Map.Entry entry : livingMotionModifiers.entrySet()) {
            AssetAccessor aniamtion = (AssetAccessor)entry.getValue();
            if (!oldLivingAnimations.containsKey(entry.getKey())) {
                this.updatedMotionCurrentTick = true;
            } else if (oldLivingAnimations.get(entry.getKey()) != aniamtion) {
                this.updatedMotionCurrentTick = true;
            }
            newLivingAnimations.put((LivingMotion)entry.getKey(), aniamtion);
        }
        for (LivingMotion oldLivingMotion : oldLivingAnimations.keySet()) {
            if (newLivingAnimations.containsKey(oldLivingMotion)) continue;
            this.updatedMotionCurrentTick = true;
            break;
        }
        if (this.updatedMotionCurrentTick || !checkOldAnimations) {
            ((Animator)this.getAnimator()).resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> this.getAnimator().addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((ServerPlayer)this.original).m_19879_());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, (ServerPlayer)this.original, new Object[0]);
        }
    }

    @Override
    public void sendToAllPlayersTrackingMe(Object packet) {
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(packet, (ServerPlayer)this.original, new Object[0]);
    }

    @Override
    public void setModelYRot(float amount, boolean sendPacket) {
        super.setModelYRot(amount, sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.setPlayerYRot(((ServerPlayer)this.original).m_19879_(), this.modelYRot), (ServerPlayer)this.original, new Object[0]);
        }
    }

    @Override
    public void disableModelYRot(boolean sendPacket) {
        super.disableModelYRot(sendPacket);
        if (sendPacket) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.disablePlayerYRot(((ServerPlayer)this.original).m_19879_()), (ServerPlayer)this.original, new Object[0]);
        }
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (((ServerPlayer)this.getOriginal()).m_150110_().f_35934_ && !damageSource.m_269533_(DamageTypeTags.f_268738_)) {
            return AttackResult.missed(amount);
        }
        TakeDamageEvent.Attack hurtEvent = new TakeDamageEvent.Attack(this, damageSource, amount);
        if (this.getEventListener().triggerEvents(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, hurtEvent)) {
            return new AttackResult(hurtEvent.getResult(), hurtEvent.getDamage());
        }
        return super.tryHurt(damageSource, amount);
    }

    @Override
    public void onDodgeSuccess(DamageSource damageSource, Vec3 location) {
        super.onDodgeSuccess(damageSource, location);
        DodgeSuccessEvent dodgeSuccessEvent = new DodgeSuccessEvent(this, damageSource, location);
        this.getEventListener().triggerEvents(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, dodgeSuccessEvent);
    }

    @Override
    public void toVanillaMode(boolean synchronize) {
        super.toVanillaMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.setPlayerMode(((ServerPlayer)this.original).m_19879_(), PlayerPatch.PlayerMode.VANILLA), (ServerPlayer)this.original, new Object[0]);
        }
    }

    @Override
    public void toEpicFightMode(boolean synchronize) {
        super.toEpicFightMode(synchronize);
        if (synchronize) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(SPModifyPlayerData.setPlayerMode(((ServerPlayer)this.original).m_19879_(), PlayerPatch.PlayerMode.EPICFIGHT), (ServerPlayer)this.original, new Object[0]);
        }
    }

    @Override
    public boolean isTargetInvulnerable(Entity target) {
        if (target instanceof Player && !((ServerPlayer)this.getOriginal()).f_8924_.m_129799_()) {
            return true;
        }
        return super.isTargetInvulnerable(target);
    }

    @Override
    public void setLastAttackSuccess(boolean setter) {
        if (setter) {
            EpicFightNetworkManager.sendToPlayer(SPModifyPlayerData.setLastAttackResult(((ServerPlayer)this.original).m_19879_(), true), (ServerPlayer)this.original, new Object[0]);
        }
        this.isLastAttackSuccess = setter;
    }

    public void setAttackTarget(LivingEntity entity) {
        SetTargetEvent setTargetEvent = new SetTargetEvent(this, entity);
        this.getEventListener().triggerEvents(PlayerEventListener.EventType.SET_TARGET_EVENT, setTargetEvent);
        this.attackTarget = setTargetEvent.getTarget();
    }

    @Override
    public boolean startSkillHolding(HoldableSkill chargingSkill) {
        if (super.startSkillHolding(chargingSkill)) {
            EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.held(this.getSkillContainerFor(chargingSkill.asSkill()).get().getSlotId()), (ServerPlayer)this.getOriginal(), new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public LivingEntity getTarget() {
        return this.attackTarget;
    }

    @Override
    public void setGrapplingTarget(LivingEntity grapplingTarget) {
        super.setGrapplingTarget(grapplingTarget);
        EpicFightNetworkManager.sendToPlayer(SPModifyPlayerData.setGrapplingTarget(((ServerPlayer)this.original).m_19879_(), (Entity)grapplingTarget), (ServerPlayer)this.original, new Object[0]);
    }
}

