/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.ShootGoal;
import com.github.mim1q.minecells.entity.interfaces.IShootEntity;
import com.github.mim1q.minecells.entity.nonliving.SimpleProjectileEntity;
import com.github.mim1q.minecells.entity.nonliving.projectile.MagicOrbEntity;
import com.github.mim1q.minecells.registry.MineCellsEntities;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.animation.AnimationProperty;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_5132;
import net.minecraft.class_5134;

public class InquisitorEntity
extends MineCellsEntity
implements IShootEntity {
    public final AnimationProperty armUpProgress = new AnimationProperty(0.0f);
    private static final class_2940<Integer> SHOOT_COOLDOWN = class_2945.method_12791(InquisitorEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SHOOT_CHARGING = class_2945.method_12791(InquisitorEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SHOOT_RELEASING = class_2945.method_12791(InquisitorEntity.class, (class_2941)class_2943.field_13323);

    public InquisitorEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5985 = true;
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SHOOT_COOLDOWN, (Object)0);
        builder.method_56912(SHOOT_CHARGING, (Object)false);
        builder.method_56912(SHOOT_RELEASING, (Object)false);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new InquisitorShootGoal(this, 10, 20));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            if (this.isShootCharging() || this.isShootReleasing()) {
                this.armUpProgress.setupTransitionTo(1.0f, 10.0f);
            } else {
                this.armUpProgress.setupTransitionTo(0.0f, 20.0f);
            }
        }
    }

    public int method_5850() {
        return 3;
    }

    @Override
    protected void decrementCooldowns() {
        this.decrementCooldown(SHOOT_COOLDOWN);
    }

    @Override
    public boolean isShootReleasing() {
        return (Boolean)this.field_6011.method_12789(SHOOT_RELEASING);
    }

    @Override
    public void setShootReleasing(boolean releasing) {
        this.field_6011.method_12778(SHOOT_RELEASING, (Object)releasing);
    }

    @Override
    public boolean isShootCharging() {
        return (Boolean)this.field_6011.method_12789(SHOOT_CHARGING);
    }

    @Override
    public void setShootCharging(boolean charging) {
        this.field_6011.method_12778(SHOOT_CHARGING, (Object)charging);
    }

    @Override
    public int getShootCooldown() {
        return (Integer)this.field_6011.method_12789(SHOOT_COOLDOWN);
    }

    @Override
    public void setShootCooldown(int ticks) {
        this.field_6011.method_12778(SHOOT_COOLDOWN, (Object)ticks);
    }

    @Override
    public int getShootMaxCooldown() {
        return 40 + this.field_5974.method_43048(40);
    }

    @Override
    public class_3414 getShootChargeSoundEvent() {
        return MineCellsSounds.INQUISITOR_CHARGE;
    }

    @Override
    public class_3414 getShootReleaseSoundEvent() {
        return MineCellsSounds.INQUISITOR_RELEASE;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("shootCooldown", this.getShootCooldown());
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setShootCooldown(nbt.method_10550("shootCooldown"));
    }

    public static class_5132.class_5133 createInquisitorAttributes() {
        return InquisitorEntity.method_26827().method_26868(class_5134.field_23719, 0.15).method_26868(class_5134.field_23717, 24.0).method_26868(class_5134.field_23716, 25.0).method_26868(class_5134.field_23724, 2.0);
    }

    public static class InquisitorShootGoal
    extends ShootGoal<InquisitorEntity> {
        public InquisitorShootGoal(InquisitorEntity entity, int actionTick, int lengthTicks) {
            super(entity, actionTick, lengthTicks, 0.3f);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        @Override
        public void method_6269() {
            super.method_6269();
            if (this.target != null) {
                ((InquisitorEntity)this.entity).method_5988().method_35111((class_1297)this.target);
            }
        }

        @Override
        public void method_6268() {
            super.method_6268();
            ((InquisitorEntity)this.entity).method_5962().method_6239(this.target.method_23317(), this.target.method_23318(), this.target.method_23321(), 0.0);
        }

        @Override
        public void shoot(class_1309 target) {
            class_243 targetPos = target.method_19538().method_1031(0.0, 1.3, 0.0);
            class_243 entityPos = ((InquisitorEntity)this.entity).method_19538().method_1031(0.0, 2.25, 0.0);
            class_243 vel = targetPos.method_1020(entityPos).method_1029().method_1021(1.0);
            MagicOrbEntity orb = new MagicOrbEntity((class_1299<? extends SimpleProjectileEntity>)MineCellsEntities.MAGIC_ORB, ((InquisitorEntity)this.entity).method_37908(), (class_1309)this.entity);
            orb.method_33574(entityPos);
            orb.method_18800(vel.method_10216(), vel.method_10214(), vel.method_10215());
            ((InquisitorEntity)this.entity).method_37908().method_8649((class_1297)orb);
        }
    }
}

