/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.entity;

import com.github.mim1q.minecells.entity.MineCellsEntity;
import com.github.mim1q.minecells.entity.ai.goal.TimedActionGoal;
import com.github.mim1q.minecells.entity.ai.goal.TimedDashGoal;
import com.github.mim1q.minecells.entity.ai.goal.WalkTowardsTargetGoal;
import com.github.mim1q.minecells.registry.MineCellsParticles;
import com.github.mim1q.minecells.registry.MineCellsSounds;
import com.github.mim1q.minecells.util.ParticleUtils;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.Nullable;

public class ShieldbearerEntity
extends MineCellsEntity {
    private int dashCooldown = 100;
    private static final class_2940<Boolean> DASH_CHARGING = class_2945.method_12791(ShieldbearerEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DASH_RELEASING = class_2945.method_12791(ShieldbearerEntity.class, (class_2941)class_2943.field_13323);

    public ShieldbearerEntity(class_1299<ShieldbearerEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5959() {
        TimedDashGoal<ShieldbearerEntity> dashGoal = new TimedDashGoal<ShieldbearerEntity>(this, s -> {
            s.cooldownSetter = cooldown -> {
                this.dashCooldown = cooldown;
            };
            s.cooldownGetter = () -> this.dashCooldown;
            s.stateSetter = this::switchDashState;
            s.chargeSound = MineCellsSounds.SHIELDBEARER_CHARGE;
            s.releaseSound = MineCellsSounds.SHIELDBEARER_RELEASE;
            s.speed = 0.65f;
            s.onGround = true;
            s.damage = 6.0f;
            s.defaultCooldown = 120;
            s.actionTick = 20;
            s.alignTick = 12;
            s.chance = 0.25f;
            s.length = 80;
            s.margin = 0.25;
            s.particle = MineCellsParticles.SPECKLE.get(0xFF0000);
        }, mob -> (double)mob.method_5739((class_1297)mob.method_5968()) < 8.0);
        super.method_5959();
        this.field_6201.method_6277(0, dashGoal);
        this.field_6201.method_6277(1, (class_1352)new WalkTowardsTargetGoal((class_1314)this, 1.0, true, 1.0));
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DASH_CHARGING, (Object)false);
        builder.method_56912(DASH_RELEASING, (Object)false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (((Boolean)this.field_6011.method_12789(DASH_CHARGING)).booleanValue() && this.method_37908().method_8608()) {
            for (int i = 0; i < 5; ++i) {
                ParticleUtils.addParticle(this.method_37908(), (class_2394)MineCellsParticles.CHARGE, this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.5, 0.0), class_243.field_1353);
            }
        }
        this.dashCooldown = Math.max(0, --this.dashCooldown);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);
        this.method_5937(false);
        this.method_6122(class_1268.field_5808, class_1802.field_8255.method_7854());
        return result;
    }

    @Override
    public boolean method_5679(class_1282 damageSource) {
        class_243 pos = damageSource.method_5510();
        if (pos != null) {
            class_243 diff = pos.method_1020(this.method_19538());
            float angle = (float)class_3532.method_15349((double)diff.field_1350, (double)diff.field_1352) * 57.295776f + 90.0f;
            if (class_3532.method_15356((float)this.field_6283, (float)angle) > 110.0f) {
                this.method_5783(class_3417.field_15150, 0.3f, 1.0f);
                return true;
            }
        }
        return super.method_5679(damageSource);
    }

    public boolean method_30949(class_1297 other) {
        return super.method_30949(other) && (Boolean)this.field_6011.method_12789(DASH_RELEASING) == false;
    }

    protected void switchDashState(TimedActionGoal.State state, boolean value) {
        switch (state) {
            case CHARGE: {
                this.field_6011.method_12778(DASH_CHARGING, (Object)value);
                break;
            }
            case RELEASE: {
                this.field_6011.method_12778(DASH_RELEASING, (Object)value);
            }
        }
    }

    public static class_5132.class_5133 createShieldbearerAttributes() {
        return ShieldbearerEntity.method_26918().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23724, 5.0).method_26868(class_5134.field_23719, 0.23).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23717, 16.0);
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("dashCooldown", this.dashCooldown);
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.dashCooldown = nbt.method_10550("dashCooldown");
    }
}

