/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item;

import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.util.LegacyUtil;
import com.github.mim1q.minecells.util.TextUtils;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5536;
import net.minecraft.class_5630;

public class CellHolderItem
extends class_1792 {
    private static final String EMPTY_KEY = "item.minecells.cell_holder.empty";
    private static final String CELL_COUNT_KEY = "item.minecells.cell_holder.cell_count";
    private static final String FULL_KEY = "item.minecells.cell_holder.full";

    public CellHolderItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
        int maxToDeposit;
        int n = maxToDeposit = clickType == class_5536.field_27013 ? 64 : 1;
        if (otherStack.method_31574(MineCellsItems.MONSTER_CELL)) {
            int count = Math.min(maxToDeposit, otherStack.method_7947());
            otherStack.method_7934(count);
            CellHolderItem.setCellCount(stack, CellHolderItem.getCellCount(stack) + count);
            return true;
        }
        if (otherStack.method_7960() && clickType == class_5536.field_27014) {
            int maxToWithdraw = Math.min(64, CellHolderItem.getCellCount(stack));
            if (maxToWithdraw == 0) {
                return false;
            }
            class_1799 newStack = new class_1799((class_1935)MineCellsItems.MONSTER_CELL, maxToWithdraw);
            CellHolderItem.setCellCount(stack, CellHolderItem.getCellCount(stack) - maxToWithdraw);
            cursorStackReference.method_32332(newStack);
            return true;
        }
        return super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
    }

    public boolean method_31565(class_1799 stack, class_1735 slot, class_5536 clickType, class_1657 player) {
        return super.method_31565(stack, slot, clickType, player);
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        int count = CellHolderItem.getCellCount(stack);
        if (count == 0) {
            TextUtils.addDescription(tooltip, EMPTY_KEY, new Object[0]);
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)CELL_COUNT_KEY, (Object[])new Object[]{count}));
            tooltip.add((class_2561)class_2561.method_43471((String)FULL_KEY));
        }
    }

    public static int getCellCount(class_1799 stack) {
        class_2487 nbt = LegacyUtil.getOrCreateNbt(stack);
        if (nbt == null) {
            return 0;
        }
        return nbt.method_10550("Cells");
    }

    public static void setCellCount(class_1799 stack, int count) {
        class_2487 nbt = LegacyUtil.getOrCreateNbt(stack);
        nbt.method_10569("Cells", count);
        LegacyUtil.writeNbt(stack, nbt);
    }
}

