/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.item.weapon.shield;

import com.github.mim1q.minecells.item.weapon.shield.CustomShieldType;
import com.github.mim1q.minecells.registry.MineCellsItems;
import com.github.mim1q.minecells.util.LegacyUtil;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorContext;
import dev.mim1q.gimm1q.valuecalculators.parameters.ValueCalculatorParameter;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5328;

public class CustomShieldItem
extends class_1831 {
    private static final int MAX_USE_DURATION = 72000;
    public final CustomShieldType shieldType;

    public CustomShieldItem(class_1792.class_1793 settings, CustomShieldType type) {
        super(MineCellsItems.CELL_INFUSED_STEEL_MATERIAL, settings);
        this.shieldType = type;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        super.method_7852(world, user, stack, remainingUseTicks);
        this.shieldType.onHold(new CustomShieldType.ShieldHoldContext((class_1657)user, 72000 - remainingUseTicks));
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        this.shieldType.onUse(new CustomShieldType.ShieldUseContext(user));
        return class_5328.method_29282((class_1937)world, (class_1657)user, (class_1268)hand);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        boolean parried = CustomShieldItem.hasParried(stack);
        ValueCalculatorContext ctx = ValueCalculatorContext.create().with(ValueCalculatorParameter.HOLDER, (Object)user).with(ValueCalculatorParameter.HOLDER_STACK, (Object)stack);
        int cooldown = this.shieldType.getCooldown(ctx, parried);
        ((class_1657)user).method_7357().method_7906((class_1792)this, cooldown);
        CustomShieldItem.setParried(stack, false);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return 72000;
    }

    public static Float getAngleDifference(class_1657 player, class_1282 source) {
        if (source.method_5510() == null) {
            return null;
        }
        class_243 damageDirection = source.method_5510().method_1020(player.method_19538());
        class_243 playerRotation = player.method_5720();
        double dotProduct = damageDirection.method_1026(playerRotation);
        double aMagnitude = damageDirection.method_1033();
        double bMagnitude = playerRotation.method_1033();
        return Float.valueOf((float)Math.toDegrees(Math.acos(dotProduct / (aMagnitude * bMagnitude))));
    }

    public static void setParried(class_1799 stack, boolean parried) {
        LegacyUtil.getOrCreateNbt(stack).method_10556("parried", parried);
    }

    public static boolean hasParried(class_1799 stack) {
        return LegacyUtil.getOrCreateNbt(stack).method_10577("parried");
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(MineCellsItems.CELL_INFUSED_STEEL);
    }
}

