/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.screen.doorway;

import com.github.mim1q.minecells.MineCells;
import com.github.mim1q.minecells.cc.MineCellsLevelCC;
import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.network.ServerPacketHandler;
import com.github.mim1q.minecells.network.c2s.UpdateDoorwayC2SPacket;
import com.github.mim1q.minecells.screen.doorway.DimensionButton;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoorwaySelectionScreen
extends BaseOwoScreen<FlowLayout> {
    private final class_2338 pos;
    private final class_2338 targetPos;
    @Nullable
    private MineCellsDimension selectedDimension;
    private final ArrayList<ButtonComponent> exitButtons = new ArrayList();
    private final ArrayList<ButtonComponent> dimensionButtons = new ArrayList();
    private final FlowLayout body;

    public DoorwaySelectionScreen(class_2338 blockEntityPos, class_2338 targetPos) {
        this.pos = blockEntityPos;
        this.targetPos = targetPos;
        this.body = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.fixed((int)150)).horizontalAlignment(HorizontalAlignment.CENTER);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, (w, h) -> (FlowLayout)Containers.verticalFlow((Sizing)w, (Sizing)h).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER));
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT);
        rootComponent.child((Component)Components.label((class_2561)class_2561.method_43470((String)"Select a dimension")).margins(Insets.bottom((int)16)));
        FlowLayout dimensions = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        dimensions.child((Component)this.createDimensionButton(MineCellsDimension.PRISONERS_QUARTERS));
        dimensions.child((Component)this.createDimensionButton(MineCellsDimension.PROMENADE_OF_THE_CONDEMNED));
        dimensions.child((Component)this.createDimensionButton(MineCellsDimension.RAMPARTS));
        dimensions.child((Component)this.createDimensionButton(MineCellsDimension.INSUFFERABLE_CRYPT));
        dimensions.child((Component)this.createDimensionButton(MineCellsDimension.BLACK_BRIDGE));
        rootComponent.child((Component)dimensions);
        rootComponent.child((Component)this.body);
        FlowLayout exitButtons = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        exitButtons.child((Component)this.createExitButton("apply_only_me", true));
        exitButtons.child((Component)this.createExitButton("apply_everyone", false));
        exitButtons.child((Component)this.createButton("close", b -> {}).active(true));
        rootComponent.child((Component)exitButtons);
    }

    private static String getFlagNameForDimension(MineCellsDimension dim) {
        return switch (dim) {
            case MineCellsDimension.PROMENADE_OF_THE_CONDEMNED -> "promenade_of_the_condemned";
            case MineCellsDimension.RAMPARTS -> "ramparts";
            case MineCellsDimension.BLACK_BRIDGE -> "black_bridge";
            case MineCellsDimension.INSUFFERABLE_CRYPT -> "insufferable_crypt";
            default -> "torn_kings_crest";
        };
    }

    private void updateBody() {
        this.body.clearChildren();
        if (this.selectedDimension == null) {
            return;
        }
        this.body.child(new FlagComponent(DoorwaySelectionScreen.getFlagNameForDimension(this.selectedDimension)).sizing(Sizing.fixed((int)48), Sizing.fixed((int)144)).margins(Insets.both((int)16, (int)8)));
        FlowLayout text = Containers.verticalFlow((Sizing)Sizing.fixed((int)200), (Sizing)Sizing.content());
        text.child((Component)Components.label((class_2561)class_2561.method_43471((String)this.selectedDimension.translationKey).method_27694(it -> it.method_10982(Boolean.valueOf(true)).method_36139(this.selectedDimension.getColor()))).shadow(true).horizontalTextAlignment(HorizontalAlignment.CENTER).margins(Insets.vertical((int)10)));
        class_5250 description = class_2561.method_43471((String)("book.minecells.entries.dimensions." + this.selectedDimension.key.method_29177().method_12832() + ".description"));
        text.child(Components.label((class_2561)class_2561.method_43470((String)description.getString().replace("<br><br>", " "))).shadow(true).horizontalSizing(Sizing.fill((int)100)));
        this.body.child((Component)text);
    }

    private ButtonComponent createDimensionButton(MineCellsDimension dim) {
        class_746 player = class_310.method_1551().field_1724;
        class_638 world = class_310.method_1551().field_1687;
        if (player == null || world == null) {
            return null;
        }
        Optional<MineCellsLevelCC.PortalData> data = MineCellsLevelCC.PortalsCC.findDataOfPosition((class_1937)world, this.targetPos);
        DimensionButton button = new DimensionButton(dim, b -> {
            this.selectedDimension = dim;
            this.exitButtons.forEach(it -> it.active(true));
            this.dimensionButtons.forEach(it -> {
                it.method_25365(false);
                ((DimensionButton)((Object)((Object)it))).setSelected(false);
            });
            b.method_25365(true);
            ((DimensionButton)((Object)b)).setSelected(true);
            this.updateBody();
        }, !dim.canEnter((class_1657)player, data.orElse(null)));
        this.dimensionButtons.add(button);
        return button;
    }

    private ButtonComponent createExitButton(String name, boolean onlyOwnerCanEnter) {
        ButtonComponent button = this.createButton(name, b -> {
            if (this.selectedDimension == null) {
                return;
            }
            ServerPacketHandler.CHANNEL.clientHandle().send((Record)new UpdateDoorwayC2SPacket(this.pos, this.selectedDimension.key.method_29177(), onlyOwnerCanEnter));
            this.method_25419();
        });
        this.exitButtons.add(button);
        return button;
    }

    private ButtonComponent createButton(String name, Consumer<ButtonComponent> consumer) {
        ButtonComponent button = Components.button((class_2561)class_2561.method_43473(), consumer).active(false).renderer((ButtonComponent.Renderer)new DimensionButton.Renderer(MineCells.createId("textures/gui/doorway_selection/" + name + ".png")));
        button.tooltip((class_2561)class_2561.method_43471((String)("gui.minecells.doorway_selection.buttons." + name)));
        button.sizing(Sizing.fixed((int)32), Sizing.fixed((int)32));
        button.cursorStyle(CursorStyle.POINTER);
        return button;
    }

    public boolean method_25421() {
        return false;
    }

    private static class FlagComponent
    extends BaseComponent {
        private final class_2960 texture;

        protected FlagComponent(String name) {
            this.texture = MineCells.createId("textures/blockentity/banner/" + name + ".png");
        }

        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)this.x, (float)this.y, 0.0f);
            float size = (float)this.width / 16.0f;
            matrices.method_22905(size, size, size);
            context.method_25290(this.texture, 0, 0, 2.0f, 2.0f, 16, 2, 64, 64);
            context.method_25290(this.texture, 0, 2, 0.0f, 16.0f, 16, 48, 64, 64);
            matrices.method_22909();
        }
    }
}

