/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid;

import com.github.mim1q.minecells.dimension.MineCellsDimension;
import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.util.MathUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3485;
import net.minecraft.class_3545;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_7138;

public class GridBasedStructureUtils {
    private static long prevSeed = 0L;
    private static final HashMap<class_3545<GridPiecesGenerator.RoomGridGenerator, class_2382>, List<GridPiecesGenerator.RoomGridGenerator.SpecialPoint>> SPECIAL_POINTS_CACHE = new HashMap();

    public static List<GridPiecesGenerator.RoomGridGenerator.SpecialPoint> getSpecialPoints(class_3218 world, class_2382 structureOrigin, GridPiecesGenerator.RoomGridGenerator generator) {
        long seed = world.method_8412();
        if (prevSeed != seed) {
            SPECIAL_POINTS_CACHE.clear();
            prevSeed = seed;
        }
        class_2382 pos = MathUtils.getClosestMultiplePosition(structureOrigin, 1024);
        return SPECIAL_POINTS_CACHE.computeIfAbsent((class_3545<GridPiecesGenerator.RoomGridGenerator, class_2382>)new class_3545((Object)generator, (Object)pos), it -> {
            class_5455 registryManager = world.method_30349();
            class_2794 chunkGenerator = world.method_14178().method_12129();
            class_7138 noiseConfig = world.method_14178().method_41248();
            class_3485 structureTemplateManager = world.method_14183();
            class_3195.class_7149 context = new class_3195.class_7149(registryManager, chunkGenerator, chunkGenerator.method_12098(), noiseConfig, structureTemplateManager, seed, new class_1923(new class_2338(structureOrigin)), (class_5539)world, registryEntry -> true);
            return generator.generateSpecialPoints(context);
        });
    }

    public static Optional<GridPiecesGenerator.RoomGridGenerator.SpecialPoint> getSpecialPoint(class_3218 world, class_2382 structureOrigin, GridPiecesGenerator.RoomGridGenerator generator, class_2960 id) {
        for (GridPiecesGenerator.RoomGridGenerator.SpecialPoint point : GridBasedStructureUtils.getSpecialPoints(world, structureOrigin, generator)) {
            if (!point.id().equals((Object)id)) continue;
            return Optional.of(point);
        }
        return Optional.empty();
    }

    public static Optional<GridPiecesGenerator.RoomGridGenerator.SpecialPoint> getSpecialPoint(class_3218 world, class_2382 structureOrigin, MineCellsDimension dimension, class_2960 id) {
        return GridBasedStructureUtils.getSpecialPoint(world, structureOrigin, dimension.baseGenerator, id);
    }

    public static Optional<GridPiecesGenerator.RoomGridGenerator.SpecialPoint> getSpecialPoint(class_3218 world, class_2382 structureOrigin, class_2960 id) {
        MineCellsDimension dimension = MineCellsDimension.of((class_1937)world);
        if (dimension == null) {
            return Optional.empty();
        }
        return GridBasedStructureUtils.getSpecialPoint(world, structureOrigin, dimension, id);
    }

    public static void clearSpecialPointsCache() {
        SPECIAL_POINTS_CACHE.clear();
    }
}

