/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.structure.grid.generator;

import com.github.mim1q.minecells.structure.grid.GridPiecesGenerator;
import com.github.mim1q.minecells.util.MathUtils;
import java.util.List;
import net.minecraft.class_2382;
import net.minecraft.class_3195;

public abstract class MultipartGridGenerator
extends GridPiecesGenerator.RoomGridGenerator {
    private final int xPart;
    private final int zPart;

    public MultipartGridGenerator(int xPart, int zPart) {
        this.xPart = xPart;
        this.zPart = zPart;
    }

    @Override
    public List<GridPiecesGenerator.RoomData> generate(class_3195.class_7149 context) {
        return super.generate(context);
    }

    @Override
    protected void addRoom(GridPiecesGenerator.RoomData data) {
        boolean outOfBounds;
        this.usedPositions.add(data.pos);
        int x = data.pos.method_10263() - 16 * this.xPart;
        int z = data.pos.method_10260() - 16 * this.zPart;
        int terrainSampleX = data.terrainSamplePos.method_10263() - 16 * this.xPart;
        int terrainSampleZ = data.terrainSamplePos.method_10260() - 16 * this.zPart;
        GridPiecesGenerator.RoomData newData = GridPiecesGenerator.RoomData.create(x - 8, data.pos.method_10264(), z - 8, data.poolId).rotation(data.rotation).offset(data.offset);
        boolean bl = outOfBounds = x < 0 || z < 0 || x >= 16 || z >= 16;
        if (data.specialPoint != null) {
            newData.specialPoint(data.specialPoint.id(), data.specialPoint.offset(), data.specialPoint.facing());
            this.specialPoints.add(new GridPiecesGenerator.RoomGridGenerator.SpecialPoint(newData.specialPoint.id(), newData.pos.method_34592(-24, 0, -24).method_35862(16).method_35853(MathUtils.getRotatedOffsetWithinChunk(newData.specialPoint.offset(), newData.rotation)), newData.specialPoint.facing().method_10501(newData.rotation)));
        }
        if (data.terrainFit) {
            newData.terrainFit();
            newData.terrainSamplePos = new class_2382(terrainSampleX - 8, data.terrainSamplePos.method_10264(), terrainSampleZ - 8);
        }
        if (outOfBounds) {
            return;
        }
        this.rooms.add(newData);
    }
}

