/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.minecells.world.processor;

import com.github.mim1q.minecells.registry.MineCellsStructureProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SwitchBlockStructureProcessor
extends class_3491 {
    public static final MapCodec<SwitchBlockStructureProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("default_namespace", (Object)"minecraft").forGetter(it -> it.defaultNamespace), (App)SwitchBlockRule.CODEC.listOf().fieldOf("rules").forGetter(it -> it.rules)).apply((Applicative)instance, SwitchBlockStructureProcessor::new));
    private final List<SwitchBlockRule> rules;
    private final String defaultNamespace;
    private final Map<class_2248, SwitchBlockRule> rulesByFromBlock;

    public SwitchBlockStructureProcessor(String defaultNamespace, List<SwitchBlockRule> rules) {
        this.rules = rules;
        this.rules.forEach(rule -> rule.setup(defaultNamespace));
        this.defaultNamespace = defaultNamespace == null ? "minecraft" : defaultNamespace;
        this.rulesByFromBlock = rules.stream().collect(Collectors.toMap(rule -> rule.fromBlock, rule -> rule));
    }

    @Nullable
    public class_3499.class_3501 method_15110(class_4538 world, class_2338 pos, class_2338 pivot, class_3499.class_3501 originalBlockInfo, class_3499.class_3501 currentBlockInfo, class_3492 data) {
        class_2680 oldState = currentBlockInfo.comp_1342();
        SwitchBlockRule rule = this.rulesByFromBlock.get(oldState.method_26204());
        if (rule == null) {
            return currentBlockInfo;
        }
        class_5819 rng = class_5819.method_43049((long)currentBlockInfo.comp_1341().hashCode());
        rng.method_43054();
        class_2680 newState = rule.selectRandomBlock(rng).method_9564();
        for (class_2769 property : newState.method_28501()) {
            newState = SwitchBlockStructureProcessor.copyProperty(oldState, newState, property);
        }
        return new class_3499.class_3501(currentBlockInfo.comp_1341(), newState, currentBlockInfo.comp_1343());
    }

    public static class_2680 copyAllProperties(class_2680 from, class_2680 to) {
        for (class_2769 property : from.method_28501()) {
            to = SwitchBlockStructureProcessor.copyProperty(from, to, property);
        }
        return to;
    }

    private static <T extends Comparable<T>> class_2680 copyProperty(class_2680 copyFrom, class_2680 copyTo, class_2769<T> property) {
        if (copyFrom.method_28498(property)) {
            return (class_2680)copyTo.method_11657(property, copyFrom.method_11654(property));
        }
        return copyTo;
    }

    protected class_3828<?> method_16772() {
        return MineCellsStructureProcessorTypes.SWITCH_BLOCK;
    }

    public static final class SwitchBlockRule {
        public static final Codec<SwitchBlockRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("from").forGetter(rule -> rule.fromBlockId), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("to").forGetter(rule -> rule.toBlocksIdsWithWeights)).apply((Applicative)instance, SwitchBlockRule::new));
        private final String fromBlockId;
        private final Map<String, Integer> toBlocksIdsWithWeights;
        private class_2248 fromBlock;
        private Map<class_2248, Integer> toBlocksWithWeights;
        private final int totalWeight;

        private SwitchBlockRule(String from, Map<String, Integer> to) {
            this.fromBlockId = from;
            this.toBlocksIdsWithWeights = to;
            this.totalWeight = this.toBlocksIdsWithWeights.values().stream().reduce(0, Integer::sum);
        }

        private class_2248 selectRandomBlock(class_5819 random) {
            int selected = random.method_43048(this.totalWeight) + 1;
            int current = 0;
            for (Map.Entry<class_2248, Integer> entry : this.toBlocksWithWeights.entrySet()) {
                if ((current += entry.getValue().intValue()) < selected) continue;
                return entry.getKey();
            }
            return this.fromBlock;
        }

        private void setup(String defaultNamespace) {
            class_2248 fromBlock = (class_2248)class_7923.field_41175.method_10223(SwitchBlockRule.getBlockId(this.fromBlockId, defaultNamespace));
            Map<class_2248, Integer> toBlocksWithWeights = this.toBlocksIdsWithWeights.entrySet().stream().collect(Collectors.toMap(entry -> (class_2248)class_7923.field_41175.method_10223(SwitchBlockRule.getBlockId((String)entry.getKey(), defaultNamespace)), Map.Entry::getValue));
            this.fromBlock = fromBlock;
            this.toBlocksWithWeights = toBlocksWithWeights;
        }

        private static class_2960 getBlockId(String id, String defaultNamespace) {
            return class_2960.method_60654((String)(id.contains(":") ? id : defaultNamespace + ":" + id));
        }
    }
}

