/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.models.entities;

import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.registries.EntityRegistry;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Crackiness;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class KoopaTroopaModel
extends GeoModel<KoopaTroopaEntity> {
    public RenderType getRenderType(KoopaTroopaEntity animatable, ResourceLocation texture) {
        return RenderType.entityCutout((ResourceLocation)this.getTextureResource(animatable));
    }

    public ResourceLocation getModelResource(KoopaTroopaEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"geo/entity/koopa_troopa/koopa_troopa.geo.json");
    }

    public ResourceLocation getTextureResource(KoopaTroopaEntity animatable) {
        if (animatable.getType() == EntityRegistry.GOLD_KOOPA_TROOPA.get()) {
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)("textures/entity/koopa_troopa/gold_koopa_troopa" + KoopaTroopaModel.getCrackiness(animatable)));
        }
        if (animatable.getType() == EntityRegistry.RED_KOOPA_TROOPA.get()) {
            return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)("textures/entity/koopa_troopa/red_koopa_troopa" + KoopaTroopaModel.getCrackiness(animatable)));
        }
        return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)("textures/entity/koopa_troopa/green_koopa_troopa" + KoopaTroopaModel.getCrackiness(animatable)));
    }

    @NotNull
    private static String getCrackiness(KoopaTroopaEntity animatable) {
        if (animatable.getCrackiness() == Crackiness.Level.LOW) {
            return "_crackiness_low.png";
        }
        if (animatable.getCrackiness() == Crackiness.Level.MEDIUM) {
            return "_crackiness_medium.png";
        }
        if (animatable.getCrackiness() == Crackiness.Level.HIGH) {
            return "_crackiness_high.png";
        }
        return ".png";
    }

    public ResourceLocation getAnimationResource(KoopaTroopaEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"marioverse", (String)"animations/entity/koopa_troopa/koopa_troopa.animation.json");
    }

    public void setCustomAnimations(KoopaTroopaEntity animatable, long instanceId, AnimationState<KoopaTroopaEntity> animationState) {
        GeoBone head = this.getAnimationProcessor().getBone("bipedHeadBaseRotater");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
    }
}

