/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.client.renderers.entities.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.wenxin2.marioverse.client.renderers.SuperStarRenderType;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class SuperStarGeoLayer<T extends LivingEntity>
extends GeoRenderLayer<T> {
    public SuperStarGeoLayer(GeoEntityRenderer<T> parent) {
        super(parent);
    }

    public void render(PoseStack poseStack, T entity, BakedGeoModel bakedModel, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTicks, int packedLight, int packedOverlay) {
        ShaderInstance shader = SuperStarRenderType.SUPER_STAR_SHADER;
        if (((Boolean)entity.getData(DataAttachmentRegistry.HAS_SUPER_STAR)).booleanValue()) {
            if (shader != null) {
                float time = ((float)entity.level().getGameTime() + partialTicks) * 0.2f;
                shader.safeGetUniform("Time").set(time);
            }
            ResourceLocation texture = this.getTextureResource((GeoAnimatable)entity);
            VertexConsumer consumer = bufferSource.getBuffer(SuperStarRenderType.superStar(texture));
            poseStack.pushPose();
            this.getRenderer().actuallyRender(poseStack, entity, bakedModel, renderType, bufferSource, consumer, true, partialTicks, 0xF000F0, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f), -1);
            poseStack.popPose();
        }
    }
}

