/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.datagen;

import com.wenxin2.marioverse.blocks.BrickPedestalBlock;
import com.wenxin2.marioverse.blocks.ClearWarpPipeBlock;
import com.wenxin2.marioverse.blocks.GoalPoleBlock;
import com.wenxin2.marioverse.blocks.InvisibleQuestionBlock;
import com.wenxin2.marioverse.blocks.QuestionBlock;
import com.wenxin2.marioverse.blocks.WarpPipeBlock;
import com.wenxin2.marioverse.blocks.WaterSpoutBlock;
import com.wenxin2.marioverse.blocks.states.ColumnBlockStates;
import com.wenxin2.marioverse.data.BlockFamilyExtended;
import com.wenxin2.marioverse.registries.BlockFamilyRegistry;
import com.wenxin2.marioverse.registries.BlockRegistry;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockStateGen
extends BlockStateProvider {
    public BlockStateGen(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "marioverse", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        String blockName;
        String classicCheckpointName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.CLASSIC_CHECKPOINT_FLAG.get())).getPath();
        String classicGoalPoleName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.CLASSIC_GOAL_POLE.get())).getPath();
        String ironSpikeName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.IRON_SPIKE.get())).getPath();
        String coinName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.COIN.get())).getPath();
        String deepFungalStoneName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.DEEP_FUNGAL_STONE.get())).getPath();
        String fungalStoneName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.FUNGAL_STONE.get())).getPath();
        String starCoinName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.STAR_COIN.get())).getPath();
        String waterSpoutName = BuiltInRegistries.BLOCK.getKey((Object)((Block)BlockRegistry.WATER_SPOUT.get())).getPath();
        this.emptyModel((Block)BlockRegistry.CLASSIC_CHECKPOINT_FLAG.get(), this.modLoc("item/" + classicCheckpointName));
        this.emptyModel((Block)BlockRegistry.COIN.get(), this.modLoc("block/" + coinName));
        this.emptyModel((Block)BlockRegistry.STAR_COIN.get(), this.modLoc("block/" + starCoinName));
        this.cubeAllModel((Block)BlockRegistry.DEEP_FUNGAL_STONE.get(), this.modLoc("block/" + deepFungalStoneName));
        this.cubeAllModel((Block)BlockRegistry.FUNGAL_STONE.get(), this.modLoc("block/" + fungalStoneName));
        this.goalPoleModel((Block)BlockRegistry.CLASSIC_GOAL_POLE.get(), classicGoalPoleName, this.modLoc("block/" + classicGoalPoleName));
        this.ironSpikeModel((Block)BlockRegistry.IRON_SPIKE.get(), this.modLoc("block/" + ironSpikeName));
        this.waterSpoutModel((Block)BlockRegistry.WATER_SPOUT.get(), this.modLoc("block/" + waterSpoutName + "_flow"), this.modLoc("block/" + waterSpoutName + "_still"), this.modLoc("block/" + waterSpoutName + "_splash"));
        this.pipeBubblesModel((Block)BlockRegistry.PIPE_BUBBLES.get());
        this.genButtons();
        this.genInvisibleQuestionBlocks();
        this.genPedestals();
        this.genPressurePlates();
        this.genQuestionBlocks();
        this.genSimpleBlockWithItem();
        this.genSlabs();
        this.genSmashableBlocks();
        this.genStairs();
        this.genStorageBricks();
        this.genWalls();
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.CHECKPOINT_FLAGS.entrySet()) {
            blockName = BuiltInRegistries.BLOCK.getKey((Object)((Block)entry.getValue().get())).getPath();
            ResourceLocation texture = this.modLoc("item/" + blockName);
            this.emptyModel((Block)entry.getValue().get(), texture);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.GOAL_POLES.entrySet()) {
            blockName = BuiltInRegistries.BLOCK.getKey((Object)((Block)entry.getValue().get())).getPath();
            String removeColorName = blockName.replace(String.valueOf(entry.getKey()) + "_", "");
            ResourceLocation texture = this.modLoc("block/" + removeColorName);
            this.goalPoleModel((Block)entry.getValue().get(), removeColorName, texture);
        }
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : BlockRegistry.WARP_PIPES.entrySet()) {
            blockName = BuiltInRegistries.BLOCK.getKey((Object)((Block)entry.getValue().get())).getPath();
            ResourceLocation entranceTexture = this.modLoc("block/" + blockName + "_entrance_side");
            ResourceLocation sideTexture = this.modLoc("block/" + blockName + "_side");
            ResourceLocation bottomTexture = this.modLoc("block/" + blockName + "_bottom");
            ResourceLocation topTexture = this.modLoc("block/" + blockName + "_top");
            ResourceLocation topClosedTexture = this.modLoc("block/" + blockName + "_top_closed");
            this.warpPipeModel((Block)entry.getValue().get(), entranceTexture, bottomTexture, sideTexture, topTexture, topClosedTexture);
        }
    }

    private void genButtons() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant button = BlockFamilyExtended.Variant.BUTTON;
            if (variant == button && block instanceof ButtonBlock) {
                ButtonBlock buttonBlock = (ButtonBlock)block;
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removeButtonName = blockName.replace("_button", "").replace("brick", "bricks");
                if (block == BlockFamilyRegistry.AMETHYST.get(button)) {
                    ResourceLocation texture = this.mcLoc("block/" + removeButtonName + "_block");
                    this.buttonBlock(buttonBlock, texture);
                    this.itemModels().buttonInventory(blockName, texture);
                } else {
                    ResourceLocation texture = this.modLoc("block/" + removeButtonName);
                    this.buttonBlock(buttonBlock, texture);
                    this.itemModels().buttonInventory(blockName, texture);
                }
            }
        }));
    }

    private void genSimpleBlockWithItem() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant bricks = BlockFamilyExtended.Variant.BRICKS;
            BlockFamilyExtended.Variant chiseled = BlockFamilyExtended.Variant.CHISELED;
            BlockFamilyExtended.Variant cracked = BlockFamilyExtended.Variant.CRACKED;
            BlockFamilyExtended.Variant polished = BlockFamilyExtended.Variant.POLISHED;
            if (variant == bricks || variant == chiseled || variant == cracked || variant == polished) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                ResourceLocation mainTexture = this.modLoc("block/" + blockName);
                ResourceLocation topTexture = this.modLoc("block/" + blockName + "_top");
                if (blockName.startsWith("chiseled_deep_fungal_bricks") || blockName.startsWith("chiseled_fungal_bricks")) {
                    this.cubeBottomTopModel((Block)block, topTexture, mainTexture, topTexture);
                } else {
                    this.cubeAllModel((Block)block, mainTexture);
                }
            }
        }));
    }

    private void genInvisibleQuestionBlocks() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant questionBlock = BlockFamilyExtended.Variant.INVISIBLE_QUESTION_BLOCK;
            if (variant == questionBlock) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                if (block == BlockFamilyRegistry.POLISHED_AMETHYST.get(questionBlock) || block == BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_STONE.get(questionBlock) || block == BlockFamilyRegistry.POLISHED_FUNGAL_STONE.get(questionBlock)) {
                    String removeInvisibleName = blockName.replace("invisible_", "");
                    ResourceLocation sideTexture = this.modLoc("block/" + removeInvisibleName + "_side");
                    ResourceLocation topTexture = this.modLoc("block/" + removeInvisibleName + "_top");
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + removeInvisibleName);
                    ResourceLocation invisibleTexture = this.modLoc("block/invisible_question_block");
                    this.invisibleQuestionBlockModel((Block)block, removeInvisibleName, sideTexture, topTexture, emptyTexture, invisibleTexture);
                } else if (block == BlockFamilyRegistry.CUT_RED_SANDSTONE.get(questionBlock) || block == BlockFamilyRegistry.CUT_SANDSTONE.get(questionBlock)) {
                    String removeInvisibleName = blockName.replace("invisible_", "");
                    String removeQuestionBlockName = removeInvisibleName.replace("_question_block", "");
                    ResourceLocation sideTexture = this.modLoc("block/" + removeInvisibleName + "_side");
                    ResourceLocation topTexture = this.mcLoc("block/" + removeQuestionBlockName + "_top");
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + removeInvisibleName);
                    ResourceLocation invisibleTexture = this.modLoc("block/invisible_question_block");
                    this.invisibleQuestionBlockSandstoneModel((Block)block, removeInvisibleName, sideTexture, topTexture, emptyTexture, invisibleTexture);
                } else if (blockName.startsWith("invisible_waxed_")) {
                    String removeInvisibleName = blockName.replace("invisible_", "");
                    String removeWaxedName = removeInvisibleName.replace("waxed_", "");
                    ResourceLocation mainTexture = this.modLoc("block/" + removeWaxedName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + removeWaxedName);
                    ResourceLocation invisibleTexture = this.modLoc("block/invisible_question_block");
                    this.invisibleQuestionBlockModel((Block)block, removeInvisibleName, mainTexture, emptyTexture, invisibleTexture);
                } else {
                    String removeInvisibleName = blockName.replace("invisible_", "");
                    ResourceLocation mainTexture = this.modLoc("block/" + removeInvisibleName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + removeInvisibleName);
                    ResourceLocation invisibleTexture = this.modLoc("block/invisible_question_block");
                    this.invisibleQuestionBlockModel((Block)block, removeInvisibleName, mainTexture, emptyTexture, invisibleTexture);
                }
            }
        }));
    }

    private void genPedestals() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant pedestal = BlockFamilyExtended.Variant.PEDESTAL;
            if (variant == pedestal) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removePedestalName = blockName.replace("_pedestal", "s");
                if (block == BlockFamilyRegistry.AMETHYST_BRICKS.get(pedestal) || block == BlockFamilyRegistry.DEEP_FUNGAL_BRICKS.get(pedestal) || block == BlockFamilyRegistry.FUNGAL_BRICKS.get(pedestal) || block == BlockFamilyRegistry.RED_SANDSTONE_BRICKS.get(pedestal) || block == BlockFamilyRegistry.SANDSTONE_BRICKS.get(pedestal)) {
                    ResourceLocation texture = this.modLoc("block/" + removePedestalName);
                    this.pedestalModel((Block)block, texture);
                } else if (block == BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_BRICKS.get(pedestal) || block == BlockFamilyRegistry.POLISHED_FUNGAL_BRICKS.get(pedestal)) {
                    ResourceLocation texture = this.modLoc("block/" + removePedestalName);
                    this.largeBrickPedestalModel((Block)block, texture);
                } else if (blockName.startsWith("waxed_")) {
                    String unWaxedName = blockName.replace("waxed_", "");
                    removePedestalName = unWaxedName.replace("_pedestal", "");
                    ResourceLocation texture = this.mcLoc("minecraft:block/" + removePedestalName);
                    this.pedestalModel((Block)block, texture);
                } else if (blockName.endsWith("_copper_pedestal") || blockName.endsWith("_block_pedestal") || blockName.endsWith("_prismarine_pedestal")) {
                    String unWaxedName = blockName.replace("waxed_", "");
                    removePedestalName = unWaxedName.replace("_pedestal", "");
                    ResourceLocation texture = this.mcLoc("minecraft:block/" + removePedestalName);
                    this.pedestalModel((Block)block, texture);
                } else if (blockName.startsWith("blackstone_")) {
                    String blackstoneName = blockName.replace("blackstone_", "polished_blackstone_");
                    removePedestalName = blackstoneName.replace("_pedestal", "s");
                    ResourceLocation texture = this.mcLoc("minecraft:block/" + removePedestalName);
                    this.pedestalModel((Block)block, texture);
                } else {
                    ResourceLocation texture = this.mcLoc("minecraft:block/" + removePedestalName);
                    this.pedestalModel((Block)block, texture);
                }
            }
        }));
    }

    private void genPressurePlates() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant pressurePlate = BlockFamilyExtended.Variant.PRESSURE_PLATE;
            if (variant == pressurePlate && block instanceof PressurePlateBlock) {
                PressurePlateBlock pressurePlateBlock = (PressurePlateBlock)block;
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removePressurePlateName = blockName.replace("_pressure_plate", "").replace("brick", "bricks");
                if (block == BlockFamilyRegistry.AMETHYST.get(pressurePlate)) {
                    ResourceLocation texture = this.mcLoc("block/" + removePressurePlateName + "_block");
                    this.pressurePlateBlock(pressurePlateBlock, texture);
                    this.itemModels().pressurePlate(blockName, texture);
                } else {
                    ResourceLocation texture = this.modLoc("block/" + removePressurePlateName);
                    this.pressurePlateBlock(pressurePlateBlock, texture);
                    this.itemModels().pressurePlate(blockName, texture);
                }
            }
        }));
    }

    private void genQuestionBlocks() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant questionBlock = BlockFamilyExtended.Variant.QUESTION_BLOCK;
            if (variant == questionBlock) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                if (block == BlockFamilyRegistry.POLISHED_AMETHYST.get(questionBlock) || block == BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_STONE.get(questionBlock) || block == BlockFamilyRegistry.POLISHED_FUNGAL_STONE.get(questionBlock)) {
                    ResourceLocation sideTexture = this.modLoc("block/" + blockName + "_side");
                    ResourceLocation topTexture = this.modLoc("block/" + blockName + "_top");
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + blockName);
                    this.questionBlockModel((Block)block, sideTexture, topTexture, emptyTexture);
                } else if (block == BlockFamilyRegistry.PRISMARINE_BRICKS.get(questionBlock)) {
                    ResourceLocation sideTexture = this.modLoc("block/" + blockName);
                    ResourceLocation topTexture = this.modLoc("block/" + blockName + "_top");
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + blockName);
                    this.questionBlockModel((Block)block, sideTexture, topTexture, emptyTexture);
                } else if (block == BlockFamilyRegistry.CUT_RED_SANDSTONE.get(questionBlock) || block == BlockFamilyRegistry.CUT_SANDSTONE.get(questionBlock)) {
                    String removeQuestionBlockName = blockName.replace("_question_block", "");
                    ResourceLocation sideTexture = this.modLoc("block/" + blockName + "_side");
                    ResourceLocation topTexture = this.mcLoc("block/" + removeQuestionBlockName + "_top");
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + blockName);
                    this.questionBlockSandstoneModel((Block)block, sideTexture, topTexture, emptyTexture);
                } else if (blockName.startsWith("waxed_")) {
                    String unWaxedName = blockName.replace("waxed_", "");
                    ResourceLocation mainTexture = this.modLoc("block/" + unWaxedName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + unWaxedName);
                    this.questionBlockModel((Block)block, mainTexture, emptyTexture);
                } else {
                    ResourceLocation mainTexture = this.modLoc("block/" + blockName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + blockName);
                    this.questionBlockModel((Block)block, mainTexture, emptyTexture);
                }
            }
        }));
    }

    private void genSlabs() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant slab = BlockFamilyExtended.Variant.SLAB;
            if (variant == slab && block instanceof SlabBlock) {
                SlabBlock slabBlock = (SlabBlock)block;
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removeSlabName = blockName.replace("_slab", "").replace("brick", "bricks");
                if (block == BlockFamilyRegistry.AMETHYST.get(slab)) {
                    ResourceLocation texture = this.mcLoc("block/" + removeSlabName + "_block");
                    this.slabBlock(slabBlock, texture, texture);
                    this.itemModels().slab(blockName, texture, texture, texture);
                } else if (block == BlockFamilyRegistry.POLISHED_AMETHYST.get(slab) || block == BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_BRICKS.get(slab) || block == BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_STONE.get(slab) || block == BlockFamilyRegistry.POLISHED_FUNGAL_BRICKS.get(slab) || block == BlockFamilyRegistry.POLISHED_FUNGAL_STONE.get(slab)) {
                    ResourceLocation texture = this.modLoc("block/" + blockName);
                    ResourceLocation topTexture = this.modLoc("block/" + removeSlabName);
                    this.slabDoubleBlock(slabBlock, texture, topTexture, topTexture);
                    this.itemModels().slab(blockName, texture, topTexture, topTexture);
                } else {
                    ResourceLocation texture = this.modLoc("block/" + removeSlabName);
                    this.slabBlock(slabBlock, texture, texture);
                    this.itemModels().slab(blockName, texture, texture, texture);
                }
            }
        }));
    }

    private void genSmashableBlocks() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant smashableBlock = BlockFamilyExtended.Variant.SMASHABLE_BLOCKS;
            if (variant == smashableBlock) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removeSmashableName = blockName.replace("smashable_", "");
                if (block == BlockFamilyRegistry.AMETHYST_BRICKS.get(smashableBlock) || block == BlockFamilyRegistry.DEEP_FUNGAL_BRICKS.get(smashableBlock) || block == BlockFamilyRegistry.FUNGAL_BRICKS.get(smashableBlock) || block == BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_BRICKS.get(smashableBlock) || block == BlockFamilyRegistry.POLISHED_FUNGAL_BRICKS.get(smashableBlock)) {
                    ResourceLocation mainTexture = this.modLoc("block/" + removeSmashableName);
                    ResourceLocation overlayTexture = this.modLoc("block/" + blockName + "_overlay");
                    this.cubeOverlayModel((Block)block, mainTexture, overlayTexture);
                } else if (removeSmashableName.startsWith("waxed_")) {
                    String unWaxedName = blockName.replace("waxed_", "");
                    removeSmashableName = unWaxedName.replace("smashable_", "");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + removeSmashableName);
                    ResourceLocation overlayTexture = this.modLoc("block/" + unWaxedName + "_overlay");
                    this.cubeOverlayModel((Block)block, mainTexture, overlayTexture);
                } else if (removeSmashableName.startsWith("blackstone_")) {
                    String crackedBlockName = removeSmashableName.replace("blackstone_", "cracked_polished_blackstone_");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + crackedBlockName);
                    this.cubeAllModel((Block)block, mainTexture);
                } else if (removeSmashableName.startsWith("deepslate_tiles")) {
                    String crackedBlockName = removeSmashableName.replace("deepslate_tiles", "cracked_deepslate_tiles");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + crackedBlockName);
                    this.cubeAllModel((Block)block, mainTexture);
                } else if (removeSmashableName.startsWith("nether_")) {
                    String crackedBlockName = removeSmashableName.replace("nether_", "cracked_nether_");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + crackedBlockName);
                    this.cubeAllModel((Block)block, mainTexture);
                } else if (removeSmashableName.startsWith("stone_")) {
                    String crackedBlockName = removeSmashableName.replace("stone_", "cracked_stone_");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + crackedBlockName);
                    this.cubeAllModel((Block)block, mainTexture);
                } else {
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + removeSmashableName);
                    ResourceLocation overlayTexture = this.modLoc("block/" + blockName + "_overlay");
                    this.cubeOverlayModel((Block)block, mainTexture, overlayTexture);
                }
            }
        }));
    }

    private void genStairs() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant stairs = BlockFamilyExtended.Variant.STAIRS;
            if (variant == stairs && block instanceof StairBlock) {
                StairBlock stairBlock = (StairBlock)block;
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removeStairName = blockName.replace("_stairs", "").replace("brick", "bricks");
                if (block == BlockFamilyRegistry.AMETHYST.get(stairs)) {
                    ResourceLocation texture = this.mcLoc("block/" + removeStairName + "_block");
                    this.stairsBlock(stairBlock, removeStairName, texture);
                    this.itemModels().stairs(blockName, texture, texture, texture);
                } else {
                    ResourceLocation texture = this.modLoc("block/" + removeStairName);
                    this.stairsBlock(stairBlock, removeStairName, texture);
                    this.itemModels().stairs(blockName, texture, texture, texture);
                }
            }
        }));
    }

    private void genStorageBricks() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant storageBrick = BlockFamilyExtended.Variant.STORAGE_BRICKS;
            if (variant == storageBrick) {
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removeStorageName = blockName.replace("storage_", "");
                String questionBlockName = removeStorageName.replace("block", "question_block").replace("sandstone_bricks", "sandstone_question_block").replace("bricks", "question_bricks").replace("cut_copper", "copper_question_block").replace("dark_prismarine", "dark_prismarine_question_block").replace("tiles", "question_tiles");
                if (block == BlockFamilyRegistry.AMETHYST_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.DEEP_FUNGAL_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.FUNGAL_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.POLISHED_DEEP_FUNGAL_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.POLISHED_FUNGAL_BRICKS.get(storageBrick)) {
                    questionBlockName = removeStorageName.replace("bricks", "question_block");
                    if (questionBlockName.contains("polished_")) {
                        questionBlockName = removeStorageName.replace("bricks", "question_block").replace("polished_", "");
                    }
                    ResourceLocation mainTexture = this.modLoc("block/" + removeStorageName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + questionBlockName);
                    this.storageBrickModel((Block)block, mainTexture, emptyTexture);
                } else if (block == BlockFamilyRegistry.RED_SANDSTONE_BRICKS.get(storageBrick) || block == BlockFamilyRegistry.SANDSTONE_BRICKS.get(storageBrick)) {
                    String removeBricksName = removeStorageName.replace("_bricks", "");
                    questionBlockName = removeStorageName.replace("bricks", "question_block");
                    ResourceLocation mainTexture = this.modLoc("block/" + removeStorageName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + questionBlockName);
                    ResourceLocation topTexture = this.mcLoc("block/" + removeBricksName + "_top");
                    this.storageBrickSandstoneModel((Block)block, mainTexture, topTexture, emptyTexture);
                } else if (removeStorageName.startsWith("waxed_")) {
                    String unWaxedName = blockName.replace("waxed_", "");
                    removeStorageName = unWaxedName.replace("storage_", "");
                    questionBlockName = removeStorageName.replace("cut_copper", "copper_question_block");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + removeStorageName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + questionBlockName);
                    this.storageBrickModel((Block)block, mainTexture, emptyTexture);
                } else if (questionBlockName.startsWith("blackstone_")) {
                    String crackedBlockName = removeStorageName.replace("blackstone_", "polished_blackstone_");
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + crackedBlockName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + questionBlockName);
                    this.storageBrickModel((Block)block, mainTexture, emptyTexture);
                } else {
                    ResourceLocation mainTexture = this.mcLoc("minecraft:block/" + removeStorageName);
                    ResourceLocation emptyTexture = this.modLoc("block/empty_" + questionBlockName);
                    this.storageBrickModel((Block)block, mainTexture, emptyTexture);
                }
            }
        }));
    }

    private void genWalls() {
        BlockFamilyRegistry.getAllExtendedFamilies().forEach(blockFamily -> blockFamily.getVariants().forEach((variant, block) -> {
            BlockFamilyExtended.Variant wall = BlockFamilyExtended.Variant.WALL;
            if (variant == wall && block instanceof WallBlock) {
                WallBlock wallBlock = (WallBlock)block;
                String blockName = BuiltInRegistries.BLOCK.getKey(block).getPath();
                String removeWallName = blockName.replace("_wall", "").replace("brick", "bricks");
                if (block == BlockFamilyRegistry.AMETHYST.get(wall)) {
                    ResourceLocation texture = this.mcLoc("block/" + removeWallName + "_block");
                    this.wallBlock(wallBlock, removeWallName, texture);
                    this.itemModels().wallInventory(blockName, texture);
                } else {
                    ResourceLocation texture = this.modLoc("block/" + removeWallName);
                    this.wallBlock(wallBlock, removeWallName, texture);
                    this.itemModels().wallInventory(blockName, texture);
                }
            }
        }));
    }

    private void cubeAllModel(Block block, ResourceLocation mainTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("minecraft:block/cube_all"))).texture("all", mainTexture);
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    private void cubeBottomTopModel(Block block, ResourceLocation bottomTexture, ResourceLocation sideTexture, ResourceLocation topTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("minecraft:block/cube_bottom_top"))).texture("bottom", bottomTexture)).texture("side", sideTexture)).texture("top", topTexture);
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    private void cubeOverlayModel(Block block, ResourceLocation mainTexture, ResourceLocation overlayTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/cube_all_overlay"))).texture("all", mainTexture)).texture("overlay", overlayTexture)).renderType("cutout_mipped");
        this.simpleBlockWithItem(block, (ModelFile)model);
    }

    private void emptyModel(Block block, ResourceLocation mainTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(modelName)).texture("particle", mainTexture)).renderType("cutout");
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void invisibleQuestionBlockModel(Block block, String modelName, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation emptyTexture, ResourceLocation invisibleTexture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", topTexture)).texture("side", sideTexture)).texture("top", topTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)this.models().withExistingParent("empty_invisible_" + modelName, this.mcLoc("block/cube_all"))).texture("all", emptyTexture);
        ModelBuilder modelInvisible = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("invisible_" + modelName, this.mcLoc("block/cube_all"))).texture("all", invisibleTexture)).renderType("translucent");
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelInvisible)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    private void invisibleQuestionBlockModel(Block block, String modelName, ResourceLocation mainTexture, ResourceLocation emptyTexture, ResourceLocation invisibleTexture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", emptyTexture)).texture("side", mainTexture)).texture("top", emptyTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)this.models().withExistingParent("empty_invisible_" + modelName, this.mcLoc("block/cube_all"))).texture("all", emptyTexture);
        ModelBuilder modelInvisible = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("invisible_" + modelName, this.mcLoc("block/cube_all"))).texture("all", invisibleTexture)).renderType("translucent");
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelInvisible)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    private void invisibleQuestionBlockSandstoneModel(Block block, String modelName, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation emptyTexture, ResourceLocation invisibleTexture) {
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", topTexture)).texture("side", sideTexture)).texture("top", topTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("empty_invisible_" + modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", topTexture)).texture("side", emptyTexture)).texture("top", topTexture);
        ModelBuilder modelInvisible = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("invisible_" + modelName, this.mcLoc("block/cube_all"))).texture("all", invisibleTexture)).renderType("translucent");
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelInvisible)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).with((Property)InvisibleQuestionBlock.INVISIBLE, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    private void goalPoleModel(Block block, String modelName, ResourceLocation mainTexture) {
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/template_goal_pole"))).texture("side", mainTexture);
        ModelBuilder modelNone = ((BlockModelBuilder)this.models().withExistingParent(modelName + "_none", this.modLoc("block/template_goal_pole_none"))).texture("side", String.valueOf(mainTexture) + "_none");
        ModelBuilder modelTop = ((BlockModelBuilder)this.models().withExistingParent(modelName + "_top", this.modLoc("block/template_goal_pole_top"))).texture("side", String.valueOf(mainTexture) + "_top");
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with(GoalPoleBlock.COLUMN, (Comparable)((Object)ColumnBlockStates.BOTTOM)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with(GoalPoleBlock.COLUMN, (Comparable)((Object)ColumnBlockStates.MIDDLE)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with(GoalPoleBlock.COLUMN, (Comparable)((Object)ColumnBlockStates.TOP)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelTop)});
        variantBuilder.partialState().with(GoalPoleBlock.COLUMN, (Comparable)((Object)ColumnBlockStates.NONE)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelNone)});
    }

    private void ironSpikeModel(Block block, ResourceLocation mainTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/template_spike"))).texture("spikes", mainTexture)).texture("center", String.valueOf(mainTexture) + "_center")).renderType("cutout_mipped");
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void pedestalModel(Block block, ResourceLocation mainTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder modelTop = ((BlockModelBuilder)this.models().withExistingParent(modelName + "_top", this.modLoc("block/template_brick_pedestal_top"))).texture("bricks", mainTexture);
        ModelBuilder modelBottom = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/template_brick_pedestal"))).texture("bricks", mainTexture);
        this.simpleBlockItem(block, (ModelFile)modelTop);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)BrickPedestalBlock.TOP, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelTop)});
        variantBuilder.partialState().with((Property)BrickPedestalBlock.TOP, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBottom)});
    }

    private void largeBrickPedestalModel(Block block, ResourceLocation mainTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder modelTop = ((BlockModelBuilder)this.models().withExistingParent(modelName + "_top", this.modLoc("block/template_large_brick_pedestal_top"))).texture("bricks", mainTexture);
        ModelBuilder modelBottom = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/template_brick_pedestal"))).texture("bricks", mainTexture);
        this.simpleBlockItem(block, (ModelFile)modelTop);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)BrickPedestalBlock.TOP, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelTop)});
        variantBuilder.partialState().with((Property)BrickPedestalBlock.TOP, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelBottom)});
    }

    private void pipeBubblesModel(Block block) {
        ModelFile.ExistingModelFile model = this.models().getExistingFile(ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"block/water"));
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
    }

    private void questionBlockModel(Block block, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation emptyTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", topTexture)).texture("side", sideTexture)).texture("top", topTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)this.models().withExistingParent("empty_" + modelName, this.mcLoc("block/cube_all"))).texture("all", emptyTexture);
        this.simpleBlockItem(block, (ModelFile)model);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    private void questionBlockModel(Block block, ResourceLocation mainTexture, ResourceLocation emptyTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", emptyTexture)).texture("side", mainTexture)).texture("top", emptyTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)this.models().withExistingParent("empty_" + modelName, this.mcLoc("block/cube_all"))).texture("all", emptyTexture);
        this.simpleBlockItem(block, (ModelFile)model);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    private void questionBlockSandstoneModel(Block block, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation emptyTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", topTexture)).texture("side", sideTexture)).texture("top", topTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("empty_" + modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", topTexture)).texture("side", emptyTexture)).texture("top", topTexture);
        this.simpleBlockItem(block, (ModelFile)model);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    public void slabDoubleBlock(SlabBlock block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        this.slabBlock(block, (ModelFile)this.models().slab(modelName, side, bottom, top), (ModelFile)this.models().slabTop(modelName + "_top", side, bottom, top), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName + "_double", this.mcLoc("block/cube_bottom_top"))).texture("side", side)).texture("bottom", bottom)).texture("top", top));
    }

    private void storageBrickModel(Block block, ResourceLocation mainTexture, ResourceLocation emptyTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_all"))).texture("all", mainTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)this.models().withExistingParent("empty_" + modelName, this.mcLoc("block/cube_all"))).texture("all", emptyTexture);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    private void storageBrickSandstoneModel(Block block, ResourceLocation mainTexture, ResourceLocation topTexture, ResourceLocation emptyTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("block/cube_all"))).texture("all", mainTexture);
        ModelBuilder modelEmpty = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("empty_" + modelName, this.mcLoc("block/cube_bottom_top"))).texture("bottom", topTexture)).texture("side", emptyTexture)).texture("top", topTexture);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)QuestionBlock.EMPTY, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelEmpty)});
    }

    private void waterSpoutModel(Block block, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation splashTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/template_water_spout"))).texture("side", sideTexture);
        ModelBuilder modelTop = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName + "_top", this.modLoc("block/template_water_spout_top"))).texture("splash", splashTexture)).texture("side", sideTexture)).texture("top", topTexture);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().with((Property)WaterSpoutBlock.TOP, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        variantBuilder.partialState().with((Property)WaterSpoutBlock.TOP, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)modelTop)});
    }

    private void warpPipeModel(Block block, ResourceLocation entranceTexture, ResourceLocation bottomTexture, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation topClosedTexture) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.mcLoc("minecraft:block/cube_bottom_top"))).texture("bottom", bottomTexture)).texture("side", sideTexture)).texture("top", bottomTexture);
        ModelBuilder modelEntrance = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName + "_entrance", this.mcLoc("minecraft:block/cube_bottom_top"))).texture("bottom", bottomTexture)).texture("side", entranceTexture)).texture("top", topTexture);
        ModelBuilder modelClosed = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName + "_entrance_closed", this.mcLoc("minecraft:block/cube_bottom_top"))).texture("bottom", bottomTexture)).texture("side", entranceTexture)).texture("top", topClosedTexture);
        this.simpleBlockItem(block, (ModelFile)modelEntrance);
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        for (Direction direction : Direction.values()) {
            int xRot = this.getXRotation(direction);
            int yRot = this.getYRotation(direction);
            for (boolean entrance : new boolean[]{false, true}) {
                for (boolean closed : new boolean[]{false, true}) {
                    for (boolean bubbles : new boolean[]{false, true}) {
                        for (boolean waterSpout : new boolean[]{false, true}) {
                            ModelFile selectedModel = this.getModelForState((ModelFile)model, (ModelFile)modelEntrance, (ModelFile)modelClosed, entrance, closed);
                            variantBuilder.partialState().with((Property)WarpPipeBlock.FACING, (Comparable)direction).with((Property)WarpPipeBlock.ENTRANCE, (Comparable)Boolean.valueOf(entrance)).with((Property)WarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(closed)).with((Property)WarpPipeBlock.BUBBLES, (Comparable)Boolean.valueOf(bubbles)).with((Property)WarpPipeBlock.WATER_SPOUT, (Comparable)Boolean.valueOf(waterSpout)).addModels(new ConfiguredModel[]{new ConfiguredModel(selectedModel, xRot, yRot, false)});
                        }
                    }
                }
            }
        }
    }

    private void clearWarpPipeModel(Block block) {
        String modelName = BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
        ModelBuilder baseModel = this.models().withExistingParent(modelName, this.modLoc("block/clear_warp_pipe/clear_warp_pipe"));
        ModelBuilder entranceModel = this.models().withExistingParent(modelName + "_entrance", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_entrance"));
        ModelBuilder closedModel = this.models().withExistingParent(modelName + "_closed", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_closed"));
        ModelBuilder entranceClosedModel = this.models().withExistingParent(modelName + "_entrance_closed", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_entrance_closed"));
        ModelBuilder northModel = this.models().withExistingParent(modelName + "_n", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_n"));
        ModelBuilder southModel = this.models().withExistingParent(modelName + "_s", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_s"));
        ModelBuilder eastModel = this.models().withExistingParent(modelName + "_e", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_e"));
        ModelBuilder westModel = this.models().withExistingParent(modelName + "_w", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_w"));
        ModelBuilder upModel = this.models().withExistingParent(modelName + "_u", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_u"));
        ModelBuilder downModel = this.models().withExistingParent(modelName + "_d", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_d"));
        ModelBuilder nsModel = this.models().withExistingParent(modelName + "_ns", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_ns"));
        ModelBuilder ewModel = this.models().withExistingParent(modelName + "_ew", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_ew"));
        ModelBuilder udModel = this.models().withExistingParent(modelName + "_ud", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_ud"));
        ModelBuilder nsewModel = this.models().withExistingParent(modelName + "_nsew", this.modLoc("block/clear_warp_pipe/clear_warp_pipe_nsew"));
        VariantBlockStateBuilder variantBuilder = this.getVariantBuilder(block);
        variantBuilder.partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)baseModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.ENTRANCE, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(false)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)entranceModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.ENTRANCE, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)entranceClosedModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.CLOSED, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)closedModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.NORTH, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)northModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.SOUTH, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)southModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.EAST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)eastModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.WEST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)westModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.UP, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)upModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.DOWN, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)downModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.NORTH, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.SOUTH, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)nsModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.EAST, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.WEST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)ewModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.UP, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.DOWN, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)udModel)});
        variantBuilder.partialState().with((Property)ClearWarpPipeBlock.NORTH, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.SOUTH, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.EAST, (Comparable)Boolean.valueOf(true)).with((Property)ClearWarpPipeBlock.WEST, (Comparable)Boolean.valueOf(true)).addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)nsewModel)});
    }

    private int getXRotation(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> 0;
            case Direction.DOWN -> 180;
            case Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST -> 90;
        };
    }

    private int getYRotation(Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> 0;
            case Direction.SOUTH -> 180;
            case Direction.EAST -> 90;
            case Direction.WEST -> 270;
            default -> 0;
        };
    }

    private ModelFile getModelForState(ModelFile model, ModelFile modelEntrance, ModelFile modelClosed, boolean entrance, boolean closed) {
        if (entrance) {
            return closed ? modelClosed : modelEntrance;
        }
        return model;
    }
}

