/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.marioverse.entities;

import com.google.common.base.MoreObjects;
import com.wenxin2.marioverse.entities.CrackableEntity;
import com.wenxin2.marioverse.entities.KoopaTroopaEntity;
import com.wenxin2.marioverse.entities.part_entities.PiranhaPlantPart;
import com.wenxin2.marioverse.items.OneUpMushroomItem;
import com.wenxin2.marioverse.registries.AttributesRegistry;
import com.wenxin2.marioverse.registries.ConfigRegistry;
import com.wenxin2.marioverse.registries.DamageSourceRegistry;
import com.wenxin2.marioverse.registries.DamageTypeRegistry;
import com.wenxin2.marioverse.registries.DataAttachmentRegistry;
import com.wenxin2.marioverse.registries.EntityRegistry;
import com.wenxin2.marioverse.registries.ItemRegistry;
import com.wenxin2.marioverse.registries.ParticleRegistry;
import com.wenxin2.marioverse.registries.SoundRegistry;
import com.wenxin2.marioverse.registries.TagRegistry;
import com.wenxin2.marioverse.utils.AbilitiesHandler;
import com.wenxin2.marioverse.utils.ServerParticleUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Crackiness;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.breeze.Breeze;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class KoopaShellEntity
extends Monster
implements CrackableEntity,
GeoEntity,
TraceableEntity {
    private static final EntityDataAccessor<Boolean> DATA_IS_SLIDING = SynchedEntityData.defineId(KoopaShellEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> DATA_IS_HIDING = SynchedEntityData.defineId(KoopaShellEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Integer> DATA_BOUNCE_COUNT = SynchedEntityData.defineId(KoopaShellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_KILL_COUNT = SynchedEntityData.defineId(KoopaShellEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final RawAnimation EMERGE = RawAnimation.begin().thenPlayAndHold("move.emerge");
    public static final RawAnimation FLIP = RawAnimation.begin().thenPlayAndHold("misc.flip");
    public static final RawAnimation IDLE = RawAnimation.begin().thenLoop("misc.idle");
    public static final RawAnimation SPIN = RawAnimation.begin().thenLoop("move.spin");
    public static final RawAnimation WALK = RawAnimation.begin().thenLoop("move.walk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final Set<UUID> entityCollided = new HashSet<UUID>();
    public Vec3 slidingMovement;
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private boolean leftOwner;
    private int hideTicks;
    public int emergeAnimationTicks;

    public KoopaShellEntity(EntityType<? extends KoopaShellEntity> type, Level world) {
        super(type, world);
        this.slidingMovement = new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
        this.hideTicks = -1;
        this.emergeAnimationTicks = -1;
    }

    protected int getBaseExperienceReward() {
        return 1 + this.level().random.nextInt(2);
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)SoundRegistry.KOOPA_SHELL_STOMP.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)SoundRegistry.KOOPA_SHELL_SHATTER.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    protected void registerGoals() {
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[]{KoopaTroopaEntity.class}));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(DefaultAnimations.genericIdleController((GeoAnimatable)this).transitionLength(0));
        controllers.add(new AnimationController((GeoAnimatable)this, "flip_controller", 5, state -> PlayState.CONTINUE).triggerableAnim("flip", FLIP));
        controllers.add(new AnimationController((GeoAnimatable)this, "spin", 5, this::walkAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "emerge_controller", 5, state -> PlayState.CONTINUE).triggerableAnim("emerge", EMERGE));
    }

    protected <E extends GeoAnimatable> PlayState walkAnimation(AnimationState<E> event) {
        if (this.isSliding()) {
            event.setAndContinue(SPIN);
            return PlayState.CONTINUE;
        }
        event.setAndContinue(IDLE);
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_BOUNCE_COUNT, (Object)0);
        builder.define(DATA_KILL_COUNT, (Object)0);
        builder.define(DATA_IS_HIDING, (Object)0);
        builder.define(DATA_IS_SLIDING, (Object)false);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putByte("HideFlags", ((Byte)this.entityData.get(DATA_IS_HIDING)).byteValue());
        tag.putInt("BounceCount", ((Integer)this.entityData.get(DATA_BOUNCE_COUNT)).intValue());
        tag.putInt("KillCount", ((Integer)this.entityData.get(DATA_KILL_COUNT)).intValue());
        tag.putInt("HideTicks", this.hideTicks);
        if (this.ownerUUID != null) {
            tag.putUUID("Owner", this.ownerUUID);
        }
        if (this.leftOwner) {
            tag.putBoolean("LeftOwner", true);
        }
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_BOUNCE_COUNT, (Object)tag.getInt("BounceCount"));
        this.entityData.set(DATA_KILL_COUNT, (Object)tag.getInt("KillCount"));
        this.entityData.set(DATA_IS_HIDING, (Object)tag.getByte("HideFlags"));
        this.leftOwner = tag.getBoolean("LeftOwner");
        this.hideTicks = tag.getInt("HideTicks");
        if (tag.hasUUID("Owner")) {
            this.ownerUUID = tag.getUUID("Owner");
            this.cachedOwner = null;
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        Entity entity = this.getOwner();
        return new ClientboundAddEntityPacket((Entity)this, serverEntity, entity == null ? 0 : entity.getId());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        Entity entity = this.level().getEntity(packet.getData());
        if (entity != null) {
            this.setOwner(entity);
        }
    }

    public void tick() {
        super.tick();
        Vec3 motion = this.getDeltaMovement();
        if (this.isSliding()) {
            this.spawnTrailParticles();
        }
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if ((float)this.getBounceCount() >= ((Integer)ConfigRegistry.MAX_KOOPA_SHELL_DAMAGE_POINTS.get()).floatValue()) {
            this.playDeathAnimation((Entity)this);
            this.discard();
        }
        if (this.hideTicks > 0 && motion.horizontalDistance() == 0.0) {
            --this.hideTicks;
        }
        if (this.emergeAnimationTicks > 0) {
            --this.emergeAnimationTicks;
        }
        if (!this.level().isClientSide && this.emergeAnimationTicks == 1) {
            this.spawnKoopaTroopa();
        }
        if (this.hideTicks == 0 && this.emergeAnimationTicks == 0 && this.getDeltaMovement().horizontalDistance() == 0.0 && (this.onGround() || this.isInWaterOrBubble())) {
            this.triggerAnim("emerge_controller", "emerge");
            this.emergeAnimationTicks = 60;
        }
        if (this.isAlive() && !this.isNoAi()) {
            this.collideWithWall(this.level());
            if (!this.level().isClientSide) {
                this.collideWithEntity();
            }
        }
        if (this.isSliding() && this.isAlive() && !this.isNoAi()) {
            BlockPos posBelow = this.blockPosition().below();
            BlockState stateBelow = this.level().getBlockState(posBelow);
            float friction = stateBelow.getFriction((LevelReader)this.level(), posBelow, (Entity)this);
            double slideFriction = (double)friction > 0.8 ? 0.4 + (double)friction / 1.5 : 1.0;
            Vec3 slideMotion = this.slidingMovement.scale(slideFriction);
            if (this.getLastDamageSource() != null && this.getDeltaMovement().horizontalDistance() > 0.0 && (this.getLastDamageSource().is(DamageTypeRegistry.STOMP) || this.getLastDamageSource().is(DamageTypeRegistry.PLAYER_STOMP))) {
                this.setDeltaMovement(Vec3.ZERO);
                this.slidingMovement = Vec3.ZERO;
            } else if (this.getLastDamageSource() != null && this.getLastDamageSource().getEntity() != null && this.getDeltaMovement().horizontalDistance() == 0.0 && (this.getLastDamageSource().is(DamageTypeRegistry.STOMP) || this.getLastDamageSource().is(DamageTypeRegistry.PLAYER_STOMP))) {
                Vec3 lookDir = this.getLastDamageSource().getEntity().getLookAngle().normalize();
                Vec3 horizontalDir = new Vec3(lookDir.x, 0.0, lookDir.z).normalize();
                Vec3 newSlideMotion = horizontalDir.scale(1.2);
                this.setDeltaMovement(newSlideMotion.x, this.getDeltaMovement().y, newSlideMotion.z);
                this.slidingMovement = new Vec3(newSlideMotion.x, this.getDeltaMovement().y, newSlideMotion.z);
                this.hasImpulse = true;
            } else if (this.onGround() && motion.horizontalDistance() > 1.0E-4) {
                this.setDeltaMovement(slideMotion.x, this.getDeltaMovement().y, slideMotion.z);
                this.slidingMovement = new Vec3(slideMotion.x, this.getDeltaMovement().y, slideMotion.z);
                this.hasImpulse = true;
            } else if (this.isInWaterOrBubble() && !this.isNoGravity()) {
                this.setDeltaMovement(slideMotion.x, this.getDeltaMovement().y - this.getAttributeValue(Attributes.GRAVITY), slideMotion.z);
            }
        }
        if (!this.isNoAi()) {
            if (motion.length() == 0.0) {
                this.setSliding(false);
            } else if (!this.isSliding() && this.isAlive() && motion.horizontalDistance() > 1.0E-4) {
                this.setSliding(true);
                this.setDeltaMovement(motion);
                this.slidingMovement = motion;
                this.hasImpulse = true;
            }
        }
        if (this.isDeadOrDying()) {
            this.setSliding(false);
            this.setDeltaMovement(Vec3.ZERO);
            this.slidingMovement = Vec3.ZERO;
        }
    }

    @NotNull
    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        SpawnEggItem spawnEggItem = SpawnEggItem.byId((EntityType)this.getType());
        if (this.getDeltaMovement().horizontalDistance() < 0.1 && spawnEggItem != null) {
            player.setItemInHand(hand, new ItemStack((ItemLike)spawnEggItem));
            player.level().playSound(player, player.blockPosition(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS);
            this.discard();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void push(Entity entity) {
        Vec3 lookDir = entity.getLookAngle().normalize();
        Vec3 horizontalDir = new Vec3(lookDir.x, 0.0, lookDir.z).normalize();
        Vec3 slideMotion = horizontalDir.scale(1.2);
        if (this.getOwner() == null) {
            this.setOwner(entity);
            this.leftOwner = false;
        }
        if (this.onGround() && entity.getDeltaMovement().horizontalDistance() > 0.0 && (this.getOwner() == null || this.getOwner() == entity)) {
            this.setDeltaMovement(slideMotion.x, this.getDeltaMovement().y, slideMotion.z);
            this.slidingMovement = new Vec3(slideMotion.x, this.getDeltaMovement().y, slideMotion.z);
            this.hasImpulse = true;
        }
        super.push(entity);
    }

    protected void doPush(Entity entity) {
        if (this.getOwner() == null) {
            this.setOwner(entity);
            this.leftOwner = false;
        }
        super.doPush(entity);
    }

    public boolean hurt(DamageSource source, float amount) {
        Level world = this.level();
        BlockPos posBelow = this.blockPosition().below();
        BlockState stateBelow = world.getBlockState(posBelow);
        if (source.is(TagRegistry.FLIPS_KOOPA_SHELL)) {
            this.triggerAnim("flip_controller", "flip");
        }
        if (source.is(TagRegistry.STOPS_KOOPA_SHELL) && this.slidingMovement != Vec3.ZERO) {
            this.setXxa(0.0f);
            this.setSpeed(0.0f);
            this.setDeltaMovement(0.0, this.getDeltaMovement().y, 0.0);
            this.slidingMovement = new Vec3(0.0, this.getDeltaMovement().y, 0.0);
            this.setSliding(false);
        }
        if (!source.is(TagRegistry.FLIPS_KOOPA_SHELL) && !source.is(TagRegistry.STOPS_KOOPA_SHELL) || this.slidingMovement == Vec3.ZERO) {
            float friction = stateBelow.getFriction((LevelReader)world, posBelow, (Entity)this);
            double slideSpeed = (double)friction > 0.6 ? 0.4 + (double)friction / 1.5 : 1.0;
            Vec3 slideDirection = new Vec3(this.getDeltaMovement().x, this.getDeltaMovement().y, this.getDeltaMovement().z);
            if (source.getEntity() != null) {
                Vec3 attackerPos = source.getEntity().position();
                Vec3 hitPos = this.position();
                Vec3 slideDirRaw = hitPos.subtract(attackerPos).normalize();
                slideDirection = new Vec3(slideDirRaw.x, this.getDeltaMovement().y, slideDirRaw.z).normalize();
            } else if (source.getDirectEntity() != null) {
                slideDirection = source.getDirectEntity().getDeltaMovement().normalize();
            }
            Vec3 movement = slideDirection.scale(slideSpeed);
            if (!this.isNoAi()) {
                this.setDeltaMovement(movement.x, this.getDeltaMovement().y, movement.z);
                this.slidingMovement = new Vec3(movement.x, this.getDeltaMovement().y, movement.z);
                this.setSliding(true);
                this.hasImpulse = true;
                this.setOwner(source.getEntity());
                this.leftOwner = false;
            }
        }
        return super.hurt(source, amount);
    }

    public void die(DamageSource source) {
        this.playDeathAnimation((Entity)this);
        super.die(source);
    }

    public void travel(Vec3 vec3) {
        if (this.isControlledByLocalInstance()) {
            double d9 = this.getY();
            double d0 = this.getGravity();
            boolean flag = this.getDeltaMovement().y <= 0.0;
            FluidState fluidstate = this.level().getFluidState(this.blockPosition());
            if (flag && this.hasEffect(MobEffects.SLOW_FALLING)) {
                d0 = Math.min(d0, 0.01);
            }
            if ((this.isInWaterOrBubble() || this.isInFluidType(fluidstate) && fluidstate.getFluidType() != NeoForgeMod.LAVA_TYPE.value()) && this.isAffectedByFluids() && !this.canStandOnFluid(fluidstate)) {
                if (this.isInWaterOrBubble() || this.isInFluidType(fluidstate) && !this.moveInFluid(fluidstate, vec3, d0)) {
                    float f4 = this.isSprinting() ? 0.9f : this.getWaterSlowDown();
                    float f5 = 0.02f;
                    float f6 = (float)this.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
                    if (!this.onGround()) {
                        f6 *= 1.0f;
                    }
                    if (f6 > 0.0f) {
                        f4 += (0.54600006f - f4) * f6;
                        f5 += (this.getSpeed() - f5) * f6;
                    }
                    if (this.hasEffect(MobEffects.DOLPHINS_GRACE)) {
                        f4 = 0.96f;
                    }
                    this.moveRelative(f5 *= (float)this.getAttributeValue(NeoForgeMod.SWIM_SPEED), vec3);
                    this.move(MoverType.SELF, this.getDeltaMovement());
                    Vec3 vec36 = this.getDeltaMovement();
                    if (this.horizontalCollision && this.onClimbable()) {
                        vec36 = new Vec3(vec36.x, 0.5, vec36.z);
                    }
                    this.setDeltaMovement(vec36.multiply((double)f4, (double)0.7f, (double)f4));
                    Vec3 vec32 = this.getFluidFallingAdjustedMovement(d0, flag, this.getDeltaMovement());
                    this.setDeltaMovement(vec32);
                    if (this.horizontalCollision && this.isFree(vec32.x, vec32.y + (double)0.6f - this.getY() + d9, vec32.z)) {
                        this.setDeltaMovement(vec32.x, 0.5, vec32.z);
                    }
                }
            } else {
                super.travel(vec3);
            }
        }
    }

    public static boolean checkKoopaSpawnRules(EntityType<? extends Monster> entityType, ServerLevelAccessor serverWorld, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return (MobSpawnType.ignoresLightRequirements((MobSpawnType)spawnType) || KoopaShellEntity.isDarkEnoughToSpawn((ServerLevelAccessor)serverWorld, (BlockPos)pos, (RandomSource)random)) && KoopaShellEntity.checkMobSpawnRules(entityType, (LevelAccessor)serverWorld, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        return false;
    }

    public boolean canBeLeashed() {
        return true;
    }

    @NotNull
    public AABB makeBoundingBox() {
        return super.makeBoundingBox();
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    @Override
    public Crackiness.Level getCrackiness() {
        return Crackiness.WOLF_ARMOR.byFraction(1.0f - (float)this.getBounceCount() / (float)ConfigRegistry.MAX_KOOPA_SHELL_DAMAGE_POINTS.getAsInt());
    }

    public void setSliding(boolean sliding) {
        this.entityData.set(DATA_IS_SLIDING, (Object)sliding);
    }

    public boolean isSliding() {
        return (Boolean)this.entityData.get(DATA_IS_SLIDING);
    }

    public void setBounceCount(int bounceCount) {
        this.entityData.set(DATA_BOUNCE_COUNT, (Object)bounceCount);
    }

    public int getBounceCount() {
        return (Integer)this.entityData.get(DATA_BOUNCE_COUNT);
    }

    public void setKillCount(int killCount) {
        this.entityData.set(DATA_KILL_COUNT, (Object)killCount);
    }

    public int getKillCount() {
        return (Integer)this.entityData.get(DATA_KILL_COUNT);
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.isRemoved()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.cachedOwner = serverWorld.getEntity(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Entity ownerEntity) {
        if (ownerEntity != null) {
            this.ownerUUID = ownerEntity.getUUID();
            this.cachedOwner = ownerEntity;
        }
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof KoopaShellEntity) {
            KoopaShellEntity shell = (KoopaShellEntity)entity;
            this.cachedOwner = shell.cachedOwner;
        }
    }

    @NotNull
    public SimpleParticleType getShatterParticle() {
        return (SimpleParticleType)ParticleRegistry.GREEN_KOOPA_SHELL_SHATTER.get();
    }

    @NotNull
    public KoopaTroopaEntity getKoopaTroopaEntity() {
        return new KoopaTroopaEntity((EntityType<? extends KoopaTroopaEntity>)((EntityType)EntityRegistry.GREEN_KOOPA_TROOPA.get()), this.level());
    }

    public TagKey<EntityType<?>> getInstaKillEntityTag() {
        return TagRegistry.GREEN_KOOPA_SHELL_CAN_INSTAKILL;
    }

    public float getShellDamage() {
        return ((Double)ConfigRegistry.GREEN_KOOPA_SHELL_DAMAGE.get()).floatValue();
    }

    protected boolean ownedBy(Entity entity) {
        return entity.getUUID().equals(this.ownerUUID);
    }

    public Entity getEffectSource() {
        return (Entity)MoreObjects.firstNonNull((Object)this.getOwner(), (Object)this);
    }

    private boolean checkLeftOwner() {
        Entity entity = this.getOwner();
        if (entity != null) {
            for (Entity entity1 : this.level().getEntities((Entity)this, this.getBoundingBox().expandTowards(this.getDeltaMovement()).inflate(1.0), mob -> !mob.isSpectator() && mob.isPickable())) {
                if (entity1.getRootVehicle() != entity.getRootVehicle()) continue;
                return false;
            }
        }
        return true;
    }

    public void deflect(@Nullable Entity entity, @Nullable Entity ownerEntity, boolean deflect) {
        this.setOwner(entity);
        this.leftOwner = false;
        this.onDeflection(entity, deflect);
    }

    protected void onDeflection(@Nullable Entity entity, boolean deflect) {
        Vec3 motion = this.slidingMovement;
        this.setDeltaMovement(new Vec3(-motion.x, motion.y, -motion.z));
        this.slidingMovement = new Vec3(-motion.x, motion.y, -motion.z);
        if (this.getBounceCount() != -1) {
            this.setBounceCount(this.getBounceCount() + 1);
        }
    }

    public void setHideTicks(int hideTicks) {
        this.hideTicks = hideTicks;
    }

    public void collideWithWall(Level world) {
        AABB bb = this.getBoundingBox();
        double maxStep = this.maxUpStep();
        double forwardDistance = 0.1;
        double stepIncrement = 0.1;
        block0: for (Direction dir : Direction.Plane.HORIZONTAL) {
            Vec3 forward = new Vec3((double)dir.getStepX() * forwardDistance, 0.0, (double)dir.getStepZ() * forwardDistance);
            for (double dy = 0.0; dy <= maxStep; dy += stepIncrement) {
                Vec3 offset = forward.add(0.0, dy, 0.0);
                AABB movedBox = bb.move(offset);
                if (world.noCollision((Entity)this, movedBox)) continue block0;
            }
            this.bounceShell(world, dir);
        }
    }

    public void bounceShell(Level world, Direction dir) {
        Crackiness.Level crackinessLevel = this.getCrackiness();
        Vec3 motion = this.slidingMovement;
        double speed = motion.horizontalDistance();
        if (speed < 1.0E-6) {
            return;
        }
        double newX = motion.x;
        double newZ = motion.z;
        if (dir.getAxis() == Direction.Axis.X && Math.signum(motion.x) == (double)Math.signum(dir.getStepX())) {
            newX = -motion.x;
        }
        if (dir.getAxis() == Direction.Axis.Z && Math.signum(motion.z) == (double)Math.signum(dir.getStepZ())) {
            newZ = -motion.z;
        }
        Vec3 hitPos = this.position().add(Vec3.atLowerCornerOf((Vec3i)dir.getNormal()).scale(0.4));
        double tolerance = (double)this.getBbWidth() / 2.0 + 0.075;
        if (this.position().distanceTo(hitPos) <= tolerance) {
            Vec3 newMotion = new Vec3(newX, 0.0, newZ).normalize().scale(speed);
            newMotion = newMotion.add(0.0, this.getDeltaMovement().y, 0.0);
            this.setDeltaMovement(newMotion);
            this.slidingMovement = newMotion;
            this.hasImpulse = true;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (this.getDeltaMovement().horizontalDistance() > 0.25) {
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.CRIT, hitPos.x, hitPos.y + (double)(this.getBbHeight() / 2.0f), hitPos.z, 3, 0.1, 0.1, 0.1, 0.0);
                if (this.getBounceCount() != -1) {
                    this.setBounceCount(this.getBounceCount() + 1);
                }
            }
        }
        if (this.getDeltaMovement().horizontalDistance() > 0.25) {
            world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.KOOPA_SHELL_BOUNCED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        if (this.getCrackiness() != crackinessLevel) {
            this.playSound((SoundEvent)SoundRegistry.KOOPA_SHELL_SHATTER.get(), 1.0f, 1.0f);
        }
    }

    public void collideWithEntity() {
        AABB collisionBox = this.getBoundingBox().inflate(0.1, 0.0, 0.1);
        List entities = this.level().getEntities((Entity)this, collisionBox);
        double shellSpeed = this.getDeltaMovement().horizontalDistance();
        HashSet<UUID> newCollisions = new HashSet<UUID>();
        for (Entity entityHit : entities) {
            Object part;
            LivingEntity livingEntity;
            double entityHitSpeed = entityHit.getDeltaMovement().horizontalDistance();
            if (!(shellSpeed >= 0.1) || this.hasPassenger(entityHit)) continue;
            if (entityHit instanceof VehicleEntity) {
                VehicleEntity vehicle = (VehicleEntity)entityHit;
                vehicle.getPersistentData().putInt("marioverse:spinning_ticks", 30);
                for (Entity rider : vehicle.getPassengers()) {
                    float shellDamage;
                    LivingEntity livingEntity2;
                    if (!(rider instanceof LivingEntity) || (livingEntity2 = (LivingEntity)rider).getType().is(TagRegistry.KOOPA_SHELL_CANNOT_DAMAGE)) continue;
                    float f = shellDamage = livingEntity2.getType().is(this.getInstaKillEntityTag()) ? livingEntity2.getHealth() * 1.25f : this.getShellDamage();
                    if (this.getOwner() != null && this.leftOwner) {
                        entityHit.hurt(DamageSourceRegistry.spinningShell(entityHit, this.getOwner()), shellDamage);
                    } else if (this.getOwner() == null) {
                        entityHit.hurt(DamageSourceRegistry.spinningShell(entityHit, (Entity)this), shellDamage);
                    }
                    if (rider.getType().is(this.getInstaKillEntityTag())) {
                        this.setKillCount(this.getKillCount() + 1);
                    }
                    if (entityHit.isAlive()) continue;
                    this.playDeathAnimation((Entity)this);
                    this.discard();
                }
            }
            if (entityHit instanceof KoopaShellEntity) {
                KoopaShellEntity koopaShell = (KoopaShellEntity)entityHit;
                if (entityHitSpeed >= 0.1 && koopaShell.isAlive()) {
                    this.playDeathAnimation((Entity)this);
                    this.discard();
                    koopaShell.playDeathAnimation((Entity)koopaShell);
                    koopaShell.discard();
                    return;
                }
            }
            if (entityHit instanceof LivingEntity && (livingEntity = (LivingEntity)entityHit).isAlive() && !livingEntity.getType().is(TagRegistry.KOOPA_SHELL_CANNOT_DAMAGE)) {
                this.damageEntity(livingEntity, newCollisions);
            }
            if (entityHit instanceof EnderDragonPart && (part = (EnderDragonPart)entityHit).isAlive() && !part.getType().is(TagRegistry.KOOPA_SHELL_CANNOT_DAMAGE)) {
                this.damageEntity((LivingEntity)part.parentMob, newCollisions);
            }
            if (!(entityHit instanceof PiranhaPlantPart) || !(part = (PiranhaPlantPart)entityHit).isAlive() || part.getType().is(TagRegistry.KOOPA_SHELL_CANNOT_DAMAGE)) continue;
            this.damageEntity((LivingEntity)part.parentMob, newCollisions);
        }
        this.entityCollided.retainAll(newCollisions);
        this.entityCollided.addAll(newCollisions);
    }

    public void damageEntity(LivingEntity entityHit, Set<UUID> newCollisions) {
        Level world = this.level();
        ItemStack shield = entityHit.getUseItem();
        Vec3 toShell = this.position().subtract(entityHit.position()).normalize();
        Vec3 look = entityHit.getLookAngle().normalize();
        double dot = toShell.dot(look);
        UUID id = entityHit.getUUID();
        newCollisions.add(id);
        if (!this.entityCollided.contains(id)) {
            float shellDamage;
            if (entityHit.isBlocking() && dot > 0.25) {
                this.deflect((Entity)entityHit, this.getOwner(), true);
                shield.hurtAndBreak(1, entityHit, LivingEntity.getSlotForHand((InteractionHand)entityHit.getUsedItemHand()));
                world.playSound(null, this.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.NEUTRAL, 1.0f, 1.0f);
                world.playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.KOOPA_SHELL_BOUNCED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                return;
            }
            if (entityHit instanceof Breeze) {
                this.deflect((Entity)entityHit, this.getOwner(), true);
                world.playSound(null, entityHit.blockPosition(), SoundEvents.BREEZE_DEFLECT, entityHit.getSoundSource(), 1.0f, 1.0f);
                return;
            }
            float f = shellDamage = entityHit.getType().is(this.getInstaKillEntityTag()) ? entityHit.getHealth() * 1.25f : this.getShellDamage();
            if (this.getOwner() != null && this.leftOwner) {
                entityHit.hurt(DamageSourceRegistry.spinningShell((Entity)entityHit, this.getOwner()), shellDamage);
            } else if (this.getOwner() == null) {
                entityHit.hurt(DamageSourceRegistry.spinningShell((Entity)entityHit, (Entity)this), shellDamage);
            }
            this.getDamageFromKills();
            if (this.getOwner() != null && this.leftOwner) {
                this.consecutiveReward(this.getOwner(), entityHit);
            }
            if (entityHit.getType().is(this.getInstaKillEntityTag())) {
                this.setKillCount(this.getKillCount() + 1);
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.CRIT, entityHit.getX(), entityHit.getY() + (double)(this.getBbHeight() / 2.0f), entityHit.getZ(), 3, 0.1, 0.1, 0.1, 0.0);
            }
            if (entityHit.isPassenger() && entityHit.getVehicle() != null) {
                Entity vehicle = entityHit.getVehicle();
                vehicle.getPersistentData().putInt("marioverse:spinning_ticks", 30);
            }
            if (!entityHit.getType().is(this.getInstaKillEntityTag()) && (this.getOwner() != null && this.leftOwner || this.getOwner() == null)) {
                this.playDeathAnimation((Entity)this);
                this.discard();
            }
        }
    }

    private void getDamageFromKills() {
        if (this.getBounceCount() != -1) {
            this.setBounceCount(this.getBounceCount() + (Integer)ConfigRegistry.KOOPA_SHELL_DAMAGE_FROM_KILLS.get());
        }
    }

    public void consecutiveReward(Entity attackingEntity, LivingEntity damagedEntity) {
        if (attackingEntity instanceof AbilitiesHandler) {
            AbilitiesHandler handler = (AbilitiesHandler)attackingEntity;
            int oneUpsRewarded = handler.mv$getOneUpsRewarded();
            int killCount = this.getKillCount();
            handler.mv$setConsecutiveBounces(killCount + 1);
            if (killCount == 0) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GOOD.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.good"), Boolean.TRUE.booleanValue());
                }
            } else if (killCount == 1) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.GREAT.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.great"), Boolean.TRUE.booleanValue());
                }
            } else if (killCount == 2) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.SUPER.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.super"), Boolean.TRUE.booleanValue());
                }
            } else if (killCount == 3) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.FANTASTIC.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.fantastic"), Boolean.TRUE.booleanValue());
                }
            } else if (killCount == 4) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.EXCELLENT.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.excellent"), Boolean.TRUE.booleanValue());
                }
            } else if (killCount == 5) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.INCREDIBLE.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.incredible"), Boolean.TRUE.booleanValue());
                }
            } else if (killCount == 6) {
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.WONDERFUL.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.wonderful"), Boolean.TRUE.booleanValue());
                }
            } else if (killCount >= 7 && (Integer)ConfigRegistry.MAX_ONE_UP_SHELL_KILL_REWARD.get() > oneUpsRewarded) {
                handler.mv$setOneUpsRewarded(oneUpsRewarded + 1);
                this.oneUpReward(attackingEntity);
                if (!((Boolean)ConfigRegistry.DISABLE_REWARD_PARTICLES.get()).booleanValue()) {
                    Level level = damagedEntity.level();
                    if (level instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)level;
                        ServerParticleUtils.spawnRewardParticle((ParticleOptions)ParticleRegistry.ONE_UP.get(), serverWorld, (Entity)damagedEntity, 0.0);
                    }
                } else if (attackingEntity instanceof Player) {
                    Player player = (Player)attackingEntity;
                    player.displayClientMessage((Component)Component.translatable((String)"display.marioverse.consecutive_bounce.one_up"), Boolean.TRUE.booleanValue());
                }
            }
        }
    }

    @Unique
    public void oneUpReward(Entity attackingEntity) {
        DeferredItem<Item> item = ItemRegistry.ONE_UP_MUSHROOM;
        if (attackingEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)attackingEntity;
            if (((Boolean)ConfigRegistry.ONE_UP_HEALS_ALL_MOBS.get()).booleanValue() || attackingEntity.getType().is(TagRegistry.CAN_CONSUME_ONE_UPS)) {
                AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)livingEntity);
                ItemStack offhandStack = livingEntity.getOffhandItem();
                if (capability != null && !capability.isEquipped((Item)ItemRegistry.ONE_UP_MUSHROOM.get())) {
                    capability.attemptToEquipAccessory(new ItemStack((ItemLike)ItemRegistry.ONE_UP_MUSHROOM.get()));
                } else if (offhandStack.isEmpty()) {
                    livingEntity.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack(item));
                } else if (offhandStack.getItem() instanceof OneUpMushroomItem) {
                    offhandStack.grow(1);
                }
                this.level().playSound(null, this.blockPosition(), (SoundEvent)SoundRegistry.ONE_UP_COLLECTED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
    }

    private void spawnKoopaTroopa() {
        KoopaTroopaEntity troopa = this.getKoopaTroopaEntity();
        troopa.setBounceCount(this.getBounceCount());
        troopa.setPos(this.getX(), this.getY(), this.getZ());
        troopa.setYRot(this.getYRot());
        troopa.setXRot(this.getXRot());
        troopa.yBodyRot = this.yBodyRot;
        troopa.setYHeadRot(this.getYHeadRot());
        troopa.setHealth(this.getHealth());
        troopa.setNoAi(this.isNoAi());
        KoopaShellEntity koopaShellEntity = this;
        if (koopaShellEntity instanceof AbilitiesHandler) {
            EquipmentSlot[] handler = (EquipmentSlot[])koopaShellEntity;
            if (troopa instanceof AbilitiesHandler) {
                AbilitiesHandler entityHandler = (AbilitiesHandler)((Object)troopa);
                entityHandler.mv$setSuperMushroom(handler.mv$hasSuperMushroom());
                entityHandler.mv$setMegaMushroom(handler.mv$hasMegaMushroom());
                entityHandler.mv$setFireFlower(handler.mv$hasFireFlower());
                entityHandler.mv$setIceFlower(handler.mv$hasIceFlower());
                troopa.setData(DataAttachmentRegistry.HAS_SUPER_STAR, (Boolean)this.getData(DataAttachmentRegistry.HAS_SUPER_STAR));
                troopa.setData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN, (Integer)this.getData(DataAttachmentRegistry.SUPER_STAR_COOLDOWN));
            }
        }
        this.copyAttributeWithModifiers((LivingEntity)troopa, (Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE);
        this.copyAttributeWithModifiers((LivingEntity)troopa, (Holder<Attribute>)Attributes.SCALE);
        this.copyAttributeWithModifiers((LivingEntity)troopa, (Holder<Attribute>)AttributesRegistry.HEIGHT_SCALE);
        this.copyAttributeWithModifiers((LivingEntity)troopa, (Holder<Attribute>)AttributesRegistry.WIDTH_SCALE);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            troopa.setItemSlot(slot, this.getItemBySlot(slot).copy());
        }
        AccessoriesCapability capability = AccessoriesCapability.get((LivingEntity)this);
        if (capability != null && ((Boolean)ConfigRegistry.EQUIP_COSTUMES_MOBS.get()).booleanValue() && !this.getType().is(TagRegistry.CANNOT_LOSE_POWER_UP)) {
            String[] slotTypes;
            for (String slotType : slotTypes = new String[]{"costume_hat", "costume_shirt", "costume_pants", "costume_shoes"}) {
                AccessoriesContainer container = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)this, (String)slotType));
                AccessoriesContainer containerEntity = capability.getContainer(SlotTypeLoader.getSlotType((LivingEntity)troopa, (String)slotType));
                if (container == null) continue;
                ItemStack stack = container.getAccessories().getItem(0);
                if (containerEntity == null) continue;
                containerEntity.getAccessories().setItem(0, stack);
            }
        }
        this.level().addFreshEntity((Entity)troopa);
        this.discard();
    }

    private void copyAttributeWithModifiers(LivingEntity entity, Holder<Attribute> attribute) {
        AttributeInstance fromAttr = this.getAttribute(attribute);
        AttributeInstance toAttr = entity.getAttribute(attribute);
        if (fromAttr != null && toAttr != null) {
            toAttr.setBaseValue(fromAttr.getBaseValue());
            for (AttributeModifier modifier : fromAttr.getModifiers()) {
                toAttr.addPermanentModifier(modifier);
            }
        }
    }

    public void playDeathAnimation(Entity entity) {
        float scale = (float)this.getAttributeValue(Attributes.SCALE);
        float heightScale = (float)this.getAttributeValue((Holder)AttributesRegistry.HEIGHT_SCALE);
        float widthScale = (float)this.getAttributeValue((Holder)AttributesRegistry.WIDTH_SCALE);
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            float height = this.getBbHeight() * scale * heightScale;
            float width = this.getBbWidth() * scale * widthScale;
            if (this.getBbHeight() >= this.getBbWidth() * 3.0f) {
                width *= 2.0f;
            }
            float scaleFactor = height * width * 1.2f;
            int numParticles = (int)(scaleFactor * 15.0f);
            for (int i = 0; i < numParticles; ++i) {
                ServerParticleUtils.spawnEntityBreakParticles((ParticleOptions)this.getShatterParticle(), serverWorld, entity, height * 1.55f + 0.1f, width * 1.55f);
            }
        }
        if (this.getDeathSound() != null) {
            this.playSound(this.getDeathSound(), this.getSoundVolume(), (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected void spawnTrailParticles() {
        BlockPos posLegacy = this.getOnPosLegacy();
        BlockState state = this.level().getBlockState(posLegacy);
        float scale = (float)this.getAttributeValue(Attributes.SCALE);
        float widthScale = (float)this.getAttributeValue((Holder)AttributesRegistry.WIDTH_SCALE);
        if (!state.addRunningEffects(this.level(), posLegacy, (Entity)this) && state.getRenderShape() != RenderShape.INVISIBLE) {
            Vec3 vec3 = this.getDeltaMovement();
            BlockPos pos = this.blockPosition();
            double x = this.getX() + (this.random.nextDouble() - 0.5) * (double)scale * (double)widthScale;
            double z = this.getZ() + (this.random.nextDouble() - 0.5) * (double)scale * (double)widthScale;
            if (pos.getX() != posLegacy.getX()) {
                x = Mth.clamp((double)x, (double)posLegacy.getX(), (double)((double)posLegacy.getX() + 1.0));
            }
            if (pos.getZ() != posLegacy.getZ()) {
                z = Mth.clamp((double)z, (double)posLegacy.getZ(), (double)((double)posLegacy.getZ() + 1.0));
            }
            this.trailParticles(state, posLegacy, x, z, vec3);
        }
    }

    public void trailParticles(BlockState state, BlockPos posLegacy, double x, double z, Vec3 vec3) {
        this.level().addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state).setPos(posLegacy), x, this.getY() + 0.1, z, vec3.x * -4.0, 1.5, vec3.z * -4.0);
    }
}

